<?php defined('SYSPATH') or die('No direct script access.');

require_once Kohana::find_file('vendor/mpdf', 'mpdf');

class Controller_Admin_Certificates_Histories extends Relio_Controller_Admin {
    public function action_index()
    {
        parent::$_acl->check('certificates_completed', 'list');
        
        $this->template->content = View::factory('admin/certificates/histories/list.tpl')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();
        
        $builder_courses = Jelly::select('course');
        
        if (Auth::instance()->get_user()->has_role('moderator'))
        {
            $builder_courses->join('course_moderators', 'LEFT')
                ->on('course_moderators.course_id', '=', DB::expr('courses.id'))
                ->where('course_moderators.user_id', '=', Auth::instance()->get_user()->id);
        }
        
        $courses = $builder_courses->execute();
        
        $in_courses = array();
        foreach($courses as $c) {
            $in_courses[] = $c->id;
        }

        $builder = Jelly::select('certificate_history')
            ->with('course')
            ->with('user');
        
        if (Auth::instance()->get_user()->has_role('moderator'))
        {
            $builder->where('course_id', 'IN', $in_courses);
        }
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'name'       => URL::query(array('sort' => 'name', 'how' => $order_direction)),
            'course'     => URL::query(array('sort' => 'course', 'how' => $order_direction)),
            'date'       => URL::query(array('sort' => 'date', 'how' => $order_direction)),
            'downloaded' => URL::query(array('sort' => 'downloaded', 'how' => $order_direction)),
            'downloads'  => URL::query(array('sort' => 'downloads', 'how' => $order_direction)),
            'status'     => URL::query(array('sort' => 'status', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'name':
                $builder->order_by('_user:user.firstname', $order_how)
                    ->order_by('_user:user.lastname', $order_how);                    
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;
            case 'course':
                $builder->with('course')->order_by('_course:course.name', $order_how);
                $current_sort = array('type' => 'course', 'how' => $order_how);
            break;
            case 'date':
                $builder->order_by('generated_on', $order_how);       
                $current_sort = array('type' => 'date', 'how' => $order_how);
            break;
            case 'downloaded':
                $builder->order_by('downloaded_on', $order_how);       
                $current_sort = array('type' => 'downloaded', 'how' => $order_how);
            break;
            case 'downloads':
                $builder->order_by('downloads', $order_how);       
                $current_sort = array('type' => 'downloads', 'how' => $order_how);
            break;
            case 'status':
                $builder->order_by('active', $order_how);       
                $current_sort = array('type' => 'status', 'how' => $order_how);
            break;
            default:
            break;
        }
        
        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items'    => $builder->count(),
            'items_per_page' => $limit
        ));
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_status()
    {
        parent::$_acl->check('certificates_completed', 'block');
        
        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status))
        {
            $item = Jelly::select('certificate_history', $this->request->param('id'));
            if ($item->loaded())
            {
                $item->active = $this->request->param('stuff');
                $item->save();

                Tracker::track('Zmiana statusu wystawionego certyfikatu ID: '.$item->id);

                message::good('Status został zmieniony pomyślnie', 'admin/certificates_histories'.URL::query());
            }
            else
            {
                message::error('Status nie został zmieniony', 'admin/certificates_histories'.URL::query());
            }
        }
        else
        {
            message::error('Status nie został zmieniony', 'admin');
        }
    }

    public function action_send()
    {
        parent::$_acl->check('certificates_completed', 'send');
        
        $item = Jelly::select('certificate_history', $this->request->param('id'));
        if ($item->loaded())
        {
            $replaceData = array();
            $replaceData['%firstname%'] = $item->user->firstname;
            $replaceData['%lastname%'] = $item->user->lastname;
            $replaceData['%course%'] = $item->course->name;
            $replaceData['%certificate_link%'] = URL::site('course/certificate/'.$item->id, 'http');
            $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
            xwContentTemplateWrapper::parameter_email(12, $replaceData, $item->user->email, CFG_WEBMASTER_EMAIL);
            
            Tracker::track('Wysłano certyfikat do studenta ID: '.$item->user->id);

            message::good('Certyfikat został wysłany pomyślnie', 'admin/certificates_histories'.URL::query());
        }
        else
        {
            message::error('Nie udało się wysłać certyfikatu', 'admin/certificates_histories'.URL::query());
        }
    }
    
    public function action_download()
    {
        parent::$_acl->check('certificates_completed', 'send');
        
        $item = Jelly::select('certificate_history', $this->request->param('id'));
        if ($item->loaded())
        {
            Certificate::download($item);
        }
        else
        {
            message::error('Nie udało się wysłać certyfikatu', 'admin/certificates_histories'.URL::query());
        }
    }
    
    public function action_checkbox()
    {
        if ($_POST)
        {
            $method_to_call = '_checkbox_'.input::post('action');
            if (method_exists($this, $method_to_call))
            {
                $this->$method_to_call();
            }
        }
        
        message::good('Operacja przeprowadzona pomyślnie', 'admin/certificates_histories'.URL::query());
    }
    
    /**
     * Checkbox - Aktywuj
     */
    private function _checkbox_publish()
    {
        $in_items = array();
        if (is_array(input::post('list')))
        {
            foreach(input::post('list') as $key => $value) {
                $in_items[] = $value;
            }
        }
        
        if (!empty($in_items))
        {
            $items = Jelly::select('certificate_history')
                ->where('id', 'IN', $in_items)
                ->execute();
            
            foreach($items as $it) {
                Tracker::track('Zmiana statusu wystawionego certyfikatu ID: '.$it->id);
                    
                $it->active = 1;
                $it->save();
            }
        }
    }
    
    /**
     * Checkbox - Deaktywuj
     */
    private function _checkbox_unpublish()
    {
        $in_items = array();
        if (is_array(input::post('list')))
        {
            foreach(input::post('list') as $key => $value) {
                $in_items[] = $value;
            }
        }
        
        if (!empty($in_items))
        {
            $items = Jelly::select('certificate_history')
                ->where('id', 'IN', $in_items)
                ->execute();
            
            foreach($items as $it) {
                Tracker::track('Zmiana statusu wystawionego certyfikatu ID: '.$it->id);
                    
                $it->active = 0;
                $it->save();
            }
        }
    }
}
