<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Content extends Relio_Controller_Admin {
    public function action_edit()
    {
        parent::$_acl->check('content', 'edit');
        
        $this->template->content = View::factory('admin/pages/content/edit.tpl')
            ->bind('errors', $errors)
            ->bind('message', $message)
            ->bind('tree', $tree)
            ->bind('item', $content);
        
        $message = message::get_once();
        
        $current_root = Kohana::config('devilcms.defaults.languages.pl.id');
        $root = Jelly::factory('page')->root($current_root);
        
        $tree = $root->render_descendants('jstree', false, 'ASC');
        
        $page = Jelly::select('page', $this->request->param('id'));
		$content = $page->content;
        
        if ($_POST)
        {
            try {
                $content->set($_POST);
                $content->save();
                
                message::good(__('Edycja przebiegła pomyślnie'), 'admin/content/edit/'.$this->request->param('id'));
            }
            catch(Validate_Exception $e) {
                $errors = $e->array->errors('shindig/crud');
            }
        }
    }
}
