<?php defined('SYSPATH') or die('No direct script access.');

require_once Kohana::find_file('vendor/PHPExcel/', 'IOFactory');

class Controller_Admin_Courses extends Relio_Controller_Admin {
    public function action_index() {
        parent::$_acl->check('courses', 'list');

        $this->template->content = View::factory('smarty:admin/courses/list')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();


        $builder = Jelly::select('course')
            ->filter(input::get('term'));
        
        if (Auth::instance()->get_user()->has_role('moderator'))
        {
            $builder->join('course_moderators', 'LEFT')
                ->on('course_moderators.course_id', '=', DB::expr('courses.id'))
                ->where('course_moderators.user_id', '=', Auth::instance()->get_user()->id);
        }
        
		if (Auth::instance()->get_user()->has_role('teacher'))
		{
			$subject = explode(',', Auth::instance()->get_user()->subject);
			
			if (! empty($subject))
			{
				$builder->where('subject_id', 'IN', $subject);
			}
		}
		
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'name'     => URL::query(array('sort' => 'name', 'how' => $order_direction)),
            'start'    => URL::query(array('sort' => 'start', 'how' => $order_direction)),
            'end'      => URL::query(array('sort' => 'end', 'how' => $order_direction)),
            'cert'     => URL::query(array('sort' => 'cert', 'how' => $order_direction)),
            'status'   => URL::query(array('sort' => 'status', 'how' => $order_direction)),
            'promoted' => URL::query(array('sort' => 'promoted', 'how' => $order_direction)),
            'comments' => URL::query(array('sort' => 'comments', 'how' => $order_direction)),
            'users'    => URL::query(array('sort' => 'users', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'name':
                $builder->order_by('name', $order_how);
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;
            case 'start':
                $builder->order_by('publish_on', $order_how);
                $current_sort = array('type' => 'start', 'how' => $order_how);
            break;
            case 'end':
                $builder->order_by('archive_on', $order_how);                    
                $current_sort = array('type' => 'end', 'how' => $order_how);
            break;
            case 'cert':
                $builder->order_by('certificate_id', $order_how);
                $current_sort = array('type' => 'cert', 'how' => $order_how);
            break;
            case 'status':
                $builder->order_by('status', $order_how);
                $current_sort = array('type' => 'status', 'how' => $order_how);
            break;
            case 'promoted':
                $builder->order_by('promoted', $order_how);
                $current_sort = array('type' => 'promoted', 'how' => $order_how);
            break;
            case 'comments':
                $current_sort = array('type' => 'comments', 'how' => $order_how);
            break;
            case 'users':
                $builder->order_by('subscribers', $order_how);
                $current_sort = array('type' => 'users', 'how' => $order_how);
            break;
            default:
            break;
        }
        
        if (input::get('limit')) {
            $limit = input::get('limit');  
        }
        else {
            $limit = 10;  
        }

        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add()
    {
        parent::$_acl->check('courses', 'add');

        $this->template->content = View::factory('smarty:admin/courses/add')
            ->bind('errors', $errors)
            ->bind('moderators', $moderators)
            ->bind('certificates', $certificates)
            ->bind('base', $base)
            ->bind('students_groups', $students_groups)
            ->bind('groups', $groups)
            ->bind('categories', $categories)
			->bind('subjects', $subjects);

        //moderatorzy
        $moderators = Jelly::select('user')
            ->join('roles_users','LEFT')
            ->on('users.id','=','roles_users.user_id')
            ->on('roles_users.role_id','=',DB::expr(3))
            ->where('roles_users.role_id','=',DB::expr(3))
            ->order_by('firstname', 'ASC')
            ->execute();

        $certificates = Jelly::select('certificate')->execute();
        $students_groups = Jelly::select('user_group')->execute();
        $base = Jelly::select('category')->filter(0)->execute();
        $groups = Jelly::select('course_group')->execute();
        $categories = Jelly::factory('course_category')->root(1)->descendants(false, 'ASC');
		$subjects = Jelly::select('subject')->execute();
		
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('base', 'not_empty')
                ->rule('name', 'not_empty')
                ->rule('publish_on', 'not_empty')
                ->rule('archive_on', 'not_empty');
            
            if ($post->check())
            {
                //video
                if (input::post('movie'))
                {
                    $moviefilename = trim(input::post('movie'), '/');

                    if (in_array(File::getExt($moviefilename), Kohana::config('devilcms.extensions.movies')))
                    {
                        $fileid = substr(md5(basename($moviefilename)), 0, 10);
                        $target = $fileid.'.jpg';
                        
                        $vthumb = XgFFMpeg_Video::thumb(DOCROOT.$moviefilename, 'upload/courses/movie/'.$target, '00:00:10', '640x360');
                        $vinfo = XgFFMpeg_Video::info(DOCROOT.$moviefilename);
                        
                        $timer = $vinfo['duration'];
                    }
                }
                
                $dependencies = '';
                foreach(input::post('depends') as $depends) {
                    if (!empty($depends['id']))
                    {
                        $dependencies .= ','.$depends['id'];
                    }
                }
                $dependencies = trim($dependencies, ',');
                
                $item = Jelly::factory('course');
                $item->category = Security::xss_clean(input::post('base'));
                $item->certificate = Security::xss_clean(input::post('certificate'));
				$item->subject = Security::xss_clean(input::post('subject'));
                $item->name = Security::xss_clean(input::post('name'));
                $item->content_short = Security::xss_clean(input::post('content_short'));
                $item->content = Security::xss_clean(input::post('content'));
                $item->options = serialize(input::post('option'));
                $item->publish_on = Security::xss_clean(input::post('publish_on'));
                $item->archive_on = Security::xss_clean(input::post('archive_on'));
                $item->hours = Security::xss_clean(input::post('hours'));                           
                $item->icon = trim(input::post('icon'), '/');
                $item->icon_entry = trim(input::post('icon_entry'), '/');
                $item->movie = trim(input::post('movie'), '/');
                $item->movie_duration = input::post('movie') ? $timer : '';
                $item->notify_notstart = input::post('notify_notstart');
                $item->notify_progress = input::post('notify_progress');
                $item->notify_finish = input::post('notify_finish');
                $item->accept = Security::xss_clean(input::post('accept'));
                $item->type = Security::xss_clean(input::post('type'));           

                if (input::post('category')) {
                    $item->course_category = input::post('category');
                }

                if (input::post('group')) {
                    $item->course_group = input::post('group');
                }
                
                if (Auth::instance()->get_user()->has_role('moderator'))
                {
                    $item->moderators = Auth::instance()->get_user()->id;
                }
                else
                {
                    foreach ((array)input::post('moderators') as $key) {
                        $item->add('moderators', $key);
                    }
                }

                foreach ((array)input::post('user_groups') as $key) {
                    $item->add('user_group', $key);
                }
                
                $item->dependence = $depends;
                $item->save();
                
                //dodaj forum
                $forum = Jelly::factory('forum_forum');
                $forum->preparePosy(16);
                $forum->course = $item->id;
                $forum->category = 16;
                $forum->name = $item->name;
                $forum->content = 'Forum szkolenia: '.$item->name;
                $forum->posy = 1;
                $forum->save();
                
                $item->forum = $forum->id;
                $item->save();
                
                //dodaj chat
                $chat = Jelly::factory('chat');
                $chat->course = $item->id;
                $chat->name = $item->name;
                $chat->save();
                
                $item->chat = $chat->id;
                $item->save();

                //Przypisywanie moderatorow jako uczestnikow szkolen
                foreach ((array)input::post('moderators') as $key) {
                    $subscribe = Jelly::factory('course_user');
                    $subscribe->user = $key;
                    $subscribe->course = $item->id;
                    $subscribe->active = 1;
                    $subscribe->save();

                    $item->updateSubscribers();
                }

                Tracker::track(__('Dodano szkolenie ID: ').$item->id);

                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/courses');
            }
            else
            {
                $errors = $post->errors('backend/course/form');
            }
        }
    }

    public function action_edit()
    {
        parent::$_acl->check('courses', 'edit');

        $this->template->content = View::factory('smarty:admin/courses/edit')
            ->bind('errors', $errors)
            ->bind('moderators', $moderators)
            ->bind('certificates', $certificates)
            ->bind('base', $base)
            ->bind('students_groups', $students_groups)
            ->bind('groups', $groups)
            ->bind('categories', $categories)
			->bind('subjects', $subjects)
            ->bind('checked_moderators', $checked_moderators)
            ->bind('checked_user_groups', $checked_user_groups)
            ->bind('checked_course_groups', $checked_course_groups)
            ->bind('checked_course_categories', $checked_course_categories)
            ->bind('item', $item)
            ->bind('options', $options);

        $item = Jelly::select('course', $this->request->param('id'));

        $options = unserialize($item->options);

        //moderatorzy
        $moderators = Jelly::select('user')
            ->join('roles_users','LEFT')
            ->on('users.id','=','roles_users.user_id')
            ->on('roles_users.role_id','=',DB::expr(3))
            ->where('roles_users.role_id','=',DB::expr(3))
            ->order_by('firstname', 'ASC')
            ->execute();

        $certificates = Jelly::select('certificate')->execute();
        $students_groups = Jelly::select('user_group')->execute();
        $base = Jelly::select('category')->filter(0)->execute();
        $groups = Jelly::select('course_group')->execute();
        $categories = Jelly::factory('course_category')->root(1)->descendants(false, 'ASC');
        $subjects = Jelly::select('subject')->execute();
		
        $checked_moderators = array();
        foreach ($item->moderators as $row) {
            $checked_moderators[] = $row->id;
        }

        $checked_user_groups = array();
        foreach ($item->user_group as $row) {
            $checked_user_groups[] = $row->id;
        }

        $checked_course_groups = array();
        foreach($item->course_group as $row) {
            $checked_course_groups[] = $row->id;
        }

        $checked_course_categories = array();
        foreach($item->course_category as $row) {
            $checked_course_categories[] = $row->id;
        }
                
        //jezeli z relacji nic nie wyszlo to ustawiamy ze kazda grupa ma dostep
        if (empty($checked_user_groups)) {
            $checked_user_groups[] = 0;
        }

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('base', 'not_empty')
                ->rule('name', 'not_empty')
                ->rule('publish_on', 'not_empty')
                ->rule('archive_on', 'not_empty');
            
            if ($post->check())
            {
                //video
                if (input::post('movie'))
                {
                    $moviefilename = trim(input::post('movie'), '/');
                    
                    if (in_array(File::getExt($moviefilename), Kohana::config('devilcms.extensions.movies')))
                    {
                        $fileid = substr(md5(basename($moviefilename)), 0, 10);
                        $target = $fileid.'.jpg';
                            
                        $vthumb = XgFFMpeg_Video::thumb(DOCROOT.$moviefilename, 'upload/courses/movie/'.$target, '00:00:10', '640x360');
                        $vinfo = XgFFMpeg_Video::info(DOCROOT.$moviefilename);
                            
                        $timer = $vinfo['duration'];
                    }
                }
                
                //usun moderatorow
                DB::delete('course_moderators')
                    ->where('course_id', '=', $item->id)
                    ->execute();

                //usun przydzial szkolenie - grupa
                DB::delete('course_group_courses')
                    ->where('course_id', '=', $item->id)
                    ->execute();

                //usun przydzial szkolenie - kategoria
                DB::delete('course_category_courses')
                    ->where('course_id', '=', $item->id)
                    ->execute();
                
                $dependencies = '';
                foreach(input::post('depends') as $depends) {
                    if (!empty($depends['id']))
                    {
                        $dependencies .= ','.$depends['id'];
                    }
                }
                $dependencies = trim($dependencies, ',');
                
                $item->category = Security::xss_clean(input::post('base'));
                $item->certificate = Security::xss_clean(input::post('certificate'));
				$item->subject = Security::xss_clean(input::post('subject'));
                $item->name = Security::xss_clean(input::post('name'));
                $item->content_short = Security::xss_clean(input::post('content_short'));
                $item->content = Security::xss_clean(input::post('content'));
                $item->options = serialize(input::post('option'));
                $item->publish_on = Security::xss_clean(input::post('publish_on'));
                $item->archive_on = Security::xss_clean(input::post('archive_on'));
                $item->hours = Security::xss_clean(input::post('hours'));              
                $item->icon = trim(input::post('icon'), '/');
                $item->icon_entry = trim(input::post('icon_entry'), '/');
                $item->movie = trim(input::post('movie'), '/');
                $item->movie_duration = input::post('movie') ? $timer : '';
                $item->notify_notstart = input::post('notify_notstart');
                $item->notify_progress = input::post('notify_progress');
                $item->notify_finish = input::post('notify_finish');
                $item->accept = Security::xss_clean(input::post('accept'));
                $item->type = Security::xss_clean(input::post('type'));           

                if (input::post('category')) {
                    $item->course_category = input::post('category');
                }

                if (input::post('group')) {
                    $item->course_group = input::post('group');
                }
                
                if (Auth::instance()->get_user()->has_role('moderator'))
                {
                    $item->moderators = Auth::instance()->get_user()->id;
                }
                else
                {
                    if (input::post('moderators')) {
                        $item->moderators = input::post('moderators');
                    }
                }

                if (input::post('user_groups')) {
                    $item->user_group = input::post('user_groups');
                }
                
                $item->dependence = $dependencies;
                $item->save();
                
                if (! $item->forum->id)
                {
                    $forum = Jelly::factory('forum_forum');
                    $forum->preparePosy(16);
                    $forum->course = $item->id;
                    $forum->category = 16;
                    $forum->name = $item->name;
                    $forum->content = 'Forum szkolenia: '.$item->name;
                    $forum->posy = 1;
                    $forum->save();
                    
                    $item->forum = $forum->id;
                    $item->save();
                }
                
                if (! $item->chat->id)
                {
                    //dodaj chat
                    $chat = Jelly::factory('chat');
                    $chat->course = $item->id;
                    $chat->name = $item->name;
                    $chat->save();
                    
                    $item->chat = $chat->id;
                    $item->save();
                }
                
                //Przypisywanie moderatorow jako uczestnikow szkolen
                /*
                foreach((array)input::post('moderators') as $key) {
                $subscribe = Jelly::factory('course_user');
                $subscribe->user = $key;
                $subscribe->course = $item->id;
                $subscribe->active = 1;
                $subscribe->save();
                
                $item->updateSubscribers();
                }
                */

                Tracker::track(__('Edycja szkolenia ID: ').$item->id);

                message::good(__('Edycja przebiegła pomyślnie'), 'admin/courses'.URL::query());
            }
            else {
                $errors = $post->errors('backend/course/form');
            }
        }
    }
    
    public function action_user_assign()
    {
        $this->template->content = View::factory('admin/courses/assign.tpl')
            ->bind('errors', $errors)
            ->bind('groups', $groups)
            ->bind('item', $item);
            
        $groups = Jelly::select('user_group')->execute();
        
        $item = Jelly::select('course', $this->request->param('id'));
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('type', 'not_empty');
            
            if (input::post('type') == 'groups')
            {
                $post->rule('groups', 'not_empty');
            }
            else if (input::post('type') == 'students')
            {
                $post->rule('students', 'not_empty');
            }
            
            if ($post->check())
            {
                if (input::post('type') == 'groups')
                {
                    foreach(input::post('groups') as $groups) {
                        $items = Jelly::select('user')
                            ->join('user_groups_users', 'LEFT')
                            ->on('user_groups_users.user_id', '=', DB::expr('users.id'))
                            ->join('roles_users', 'LEFT')
                            ->on('users.id', '=', DB::expr('roles_users.user_id'))
                            ->join('courses_users', 'LEFT')
                            ->on('courses_users.user_id', '=', DB::expr('users.id'))
                            ->by_group($groups)
                            ->distinct(true)
                            ->execute();
                            
                        foreach($items as $it) {
                            $subscribe = Jelly::factory('course_user');
                            $subscribe->user = $it->id;
                            $subscribe->course = $item->id;
                            $subscribe->active = 1;
                            $subscribe->save();
                            
                            $item->updateSubscribers();
                            /*
                            $replaceData = array();
                            $replaceData['%firstname%'] = $it->firstname;
                            $replaceData['%lastname%'] = $it->lastname;
                            $replaceData['%course%'] = $item->name;
                            $replaceData['%day%'] = date('d', time());
                            $replaceData['%month%'] = date('m', time());
                            $replaceData['%year%'] = date('Y', time());
                            $replaceData['%hour%'] = date('H', time());
                            $replaceData['%minute%'] = date('i', time());
                            $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
                            xwContentTemplateWrapper::parameter_email(9, $replaceData, $it->email, CFG_WEBMASTER_EMAIL);*/
                        }
                    }
                }
                else if (input::post('type') == 'students')
                {
                    foreach(input::post('students') as $students) {
                        $user = Jelly::select('user', $students['id']);
                        
                        $subscribe = Jelly::factory('course_user');
                        $subscribe->user = $user->id;
                        $subscribe->course = $item->id;
                        $subscribe->active = 1;
                        $subscribe->save();
                        
                        $item->updateSubscribers();
                        /*
                        $replaceData = array();
                        $replaceData['%firstname%'] = $user->firstname;
                        $replaceData['%lastname%'] = $user->lastname;
                        $replaceData['%course%'] = $item->name;
                        $replaceData['%day%'] = date('d', time());
                        $replaceData['%month%'] = date('m', time());
                        $replaceData['%year%'] = date('Y', time());
                        $replaceData['%hour%'] = date('H', time());
                        $replaceData['%minute%'] = date('i', time());
                        $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
                        xwContentTemplateWrapper::parameter_email(9, $replaceData, $user->email, CFG_WEBMASTER_EMAIL);*/
                    }
                }
                
                message::good('Przypisanie przebiegło pomyślnie', 'admin/courses');
            }
            else
            {
                $errors = $post->errors('backend/course/assign/form');
            }
        }
    }
    
    public function action_status()
    {
        parent::$_acl->check('courses', 'edit');

        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status))
        {
            $item = Jelly::select('course', (int)$this->request->param('id'));
            if ($item->loaded())
            {
                Tracker::track(__('Zmiana statusu szkolenia ID: ').$item->id);
                
                $item->active = Security::xss_clean($this->request->param('stuff'));
                $item->save();

                message::good(__('Status został zmieniony pomyślnie'), 'admin/courses'.URL::query());
            }
            else
            {
                message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
            }
        }
        else
        {
            message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
        }
    }

    public function action_promote()
    {
        parent::$_acl->check('courses', 'edit');

        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status))
        {
            $item = Jelly::select('course', (int)$this->request->param('id'));
            if ($item->loaded())
            {                
                Tracker::track(__('Zmiana statusu szkolenia ID: ').$item->id);
                
                $item->promoted = Security::xss_clean($this->request->param('stuff'));
                $item->save();


                message::good(__('Status został zmieniony pomyślnie'), 'admin/courses'.URL::query());
            }
            else
            {
                message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
            }
        }
        else
        {
            message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
        }
    }
    
    public function action_preview()
    {
        parent::$_acl->check('courses', 'list');
        
        $item = Jelly::select('course', $this->request->param('id'));
        if ($item->loaded())
        {
            Tracker::track(__('Podgląd szkolenia ID: ').$item->id);
            
            $user = Jelly::select('user', Session::instance()->get('auth_user')->id);
            if (! $user->is_subscribed($item->id))
            {
                $subscribe = Jelly::factory('course_user');
                $subscribe->user = $user->id;
                $subscribe->course = $item->id;
                $subscribe->required_complete_on = null;
                $subscribe->active = 1;
                $subscribe->save();
            }
            
            Session::instance()->set('admin_preview', 1);
            
            $this->request->redirect('course/index/'.$item->id);
        }
        else
        {
            message::error(__('Nie znaleziono takiego szkolenia'), 'admin');
        }
    }

    public function action_delete() 
    {
        parent::$_acl->check('courses', 'delete');

        $item = Jelly::select('course', $this->request->param('id'));

        if ($item->loaded())
        {
            
            Tracker::track(__('Usunięto szkolenie ID: ').$item->id);
            
            $item->delete();

            message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/courses'.URL::query());
        }
        else
        {
            message::error(__('Wystąpił błąd podczas usuwania'), 'admin');
        }
    }
    
    public function action_preview_movie()
    {
        $item = Jelly::select('course', Request::instance()->param('id'));
        
        echo View::factory('smarty:admin/courses/preview')
            ->bind('item', $item)
            ->render();
        
        exit;
    }

    public function action_checkbox() {
        if ($_POST) {
            switch (input::post('action')) {
                case 'delete':
                    parent::$_acl->check('courses', 'delete');

                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('course', $value);
                            if ($item->loaded()) {
                                Tracker::track(__('Usunięto szkolenie ID: ').$item->id);
                                
                                $item->delete();
                            }
                        }
                    }
                break;
                case 'publish':
                    parent::$_acl->check('courses', 'edit');

                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('course', $value);
                            
                            Tracker::track(__('Zmiana statusu szkolenia ID: ').$item->id);
                            
                            $item->active = 1;
                            $item->save();
                        }
                    }
                break;
                case 'unpublish':
                    parent::$_acl->check('courses', 'edit');

                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('course', $value);
                            
                            Tracker::track(__('Zmiana statusu szkolenia ID: ').$item->id);
                            
                            $item->active = 0;
                            $item->save();
                        }
                    }
                break;
            }

            message::good(__('Operacja przeprowadzona pomyślnie'), 'admin/courses'.URL::query());
        }
    }
}