<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Forum_Emoticons extends Relio_Controller_Admin {
    public function action_index()
    {
        $this->template->content = View::factory('admin/forum/emoticons/list.tpl')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();
        
        $builder = Jelly::select('forum_emoticon');
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'code' => URL::query(array('sort' => 'code', 'how' => $order_direction)),
            'status' => URL::query(array('sort' => 'status', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'code':
                $builder->order_by('code', $order_how);
                $current_sort = array('type' => 'code', 'how' => $order_how);
            break;
            case 'status':
                $builder->order_by('active', $order_how);
                $current_sort = array('type' => 'status', 'how' => $order_how);
            break;
            default:
            break;
        }
        
        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add()
    {
        $this->template->content = View::factory('admin/forum/emoticons/add.tpl')
            ->bind('errors', $errors);

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('code', 'not_empty')
                ->rule('icon', 'not_empty');
            
            if ($post->check())
            {
                $item = Jelly::factory('forum_emoticon');
                $item->code = input::post('code');
                $item->icon = trim(input::post('icon'), '/');
                $item->save();

                Tracker::track('Dodano emotikone ID: '.$item->id);

                message::good('Dodanie przebiegło pomyślnie', 'admin/forum_emoticons'.URL::query());
            }
            else
            {
                $errors = $post->errors('backend/forum/emoticons/form');
            }
        }
    }

    public function action_edit()
    {
        $this->template->content = View::factory('admin/forum/emoticons/edit.tpl')
            ->bind('errors', $errors)
            ->bind('item', $item);

        $item = Jelly::select('forum_emoticon', $this->request->param('id'));

        if ($_POST) {
            $post = Validate::factory($_POST)
                ->rule('code', 'not_empty')
                ->rule('icon', 'not_empty');
            
            if ($post->check())
            {
                $item->code = input::post('code');
                $item->icon = trim(input::post('icon'), '/');
                $item->save();

                Tracker::track('Edycja emotikony ID: ' . $this->request->param('id'));

                message::good('Edycja przebiegła pomyślnie', 'admin/forum_emoticons'.URL::query());
            }
            else
            {
                $errors = $post->errors('backend/forum/emoticons/form');
            }
        }
    }

    public function action_status()
    {
        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status))
        {
            $item = Jelly::select('forum_emoticon', $this->request->param('id'));
            if ($item->loaded())
            {
                $item->active = $this->request->param('stuff');
                $item->save();

                Tracker::track('Zmiana statusu emotikony ID: '.$this->request->param('id'));

                message::good('Status został zmieniony pomyślnie', 'admin/forum_emoticons'.URL::query());
            }
            else
            {
                message::error('Status nie został zmieniony', 'admin/forum_emoticons'.URL::query());
            }
        }
        else
        {
            message::error('Status nie został zmieniony', 'admin');
        }
    }
    
    public function action_delete()
    {
        $item = Jelly::select('forum_emoticon', $this->request->param('id'));

        if ($item->loaded())
        {
            Tracker::track('Usunięto emotikone ID: '.$item->id);
            
            $item->delete();

            message::good('Usunięcie przebiegło pomyślnie', 'admin/forum_emoticons'.URL::query());
        }
        else
        {
            message::error('Wystąpił błąd podczas usuwania', 'admin');
        }
    }
    
    public function action_checkbox()
    {
        if ($_POST)
        {
            $method_to_call = '_checkbox_'.input::post('action');
            if (method_exists($this, $method_to_call))
            {
                $this->$method_to_call();
            }
        }
        
        message::good('Operacja przeprowadzona pomyślnie', 'admin/forum_emoticons'.URL::query());
    }
    
    /**
     * Checkbox - Aktywuj
     */
    private function _checkbox_publish()
    {
        $in_items = array();
        if (is_array(input::post('list')))
        {
            foreach(input::post('list') as $key => $value) {
                $in_items[] = $value;
            }
        }
        
        if (!empty($in_items))
        {
            $items = Jelly::select('forum_emoticon')
                ->where('id', 'IN', $in_items)
                ->execute();
            
            foreach($items as $it) {
                Tracker::track('Zmiana statusu emotikony ID: '.$it->id);
                    
                $it->active = 1;
                $it->save();
            }
        }
    }
    
    /**
     * Checkbox - Deaktywuj
     */
    private function _checkbox_unpublish()
    {
        $in_items = array();
        if (is_array(input::post('list')))
        {
            foreach(input::post('list') as $key => $value) {
                $in_items[] = $value;
            }
        }
        
        if (!empty($in_items))
        {
            $items = Jelly::select('forum_emoticon')
                ->where('id', 'IN', $in_items)
                ->execute();
            
            foreach($items as $it) {
                Tracker::track('Zmiana statusu emotikony ID: '.$it->id);
                    
                $it->active = 0;
                $it->save();
            }
        }
    }
    
    /**
     * Checkbox - Usuwanie
     */
    private function _checkbox_delete()
    {
        $in_items = array();
        if (is_array(input::post('list')))
        {
            foreach(input::post('list') as $key => $value) {
                $in_items[] = $value;
            }
        }
        
        if (!empty($in_items))
        {
            $items = Jelly::select('forum_emoticon')
                ->where('id', 'IN', $in_items)
                ->execute();
            
            foreach($items as $it) {
                Tracker::track('Usunięto emotikone ID: '.$it->id);
                    
                $it->delete();
            }
        }
    }
}