<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Forum_Topics extends Relio_Controller_Admin {
    public function action_index()
    {
        $this->template->content = View::factory('admin/forum/topics/list.tpl')
            ->bind('message', $message)
            ->bind('item_id', $item_id)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();
        
        $item_id = $this->request->param('id');
        
        $builder = Jelly::select('forum_topic')
            ->with('post')
            ->where('forum_id', '=', $item_id);
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'name'    => URL::query(array('sort' => 'name', 'how' => $order_direction)),
            'replies' => URL::query(array('sort' => 'replies', 'how' => $order_direction)),
            'type'    => URL::query(array('sort' => 'type', 'how' => $order_direction)),
            'opened'  => URL::query(array('sort' => 'opened', 'how' => $order_direction)),
            'status'  => URL::query(array('sort' => 'status', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'name':
                $builder->order_by('name', $order_how);
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;
            case 'replies':
                $builder->order_by('replies', $order_how);
                $current_sort = array('type' => 'replies', 'how' => $order_how);
            break;
            case 'type':
                $builder->order_by('type', $order_how);
                $current_sort = array('type' => 'type', 'how' => $order_how);
            break;
            case 'opened':
                $builder->order_by('opened', $order_how);
                $current_sort = array('type' => 'status', 'opened' => $order_how);
            break;
            case 'status':
                $builder->order_by('active', $order_how);
                $current_sort = array('type' => 'status', 'how' => $order_how);
            break;
            default:
            break;
        }
        
        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add()
    {
        $this->template->content = View::factory('admin/forum/topics/add.tpl')
            ->bind('errors', $errors)
            ->bind('posticons', $posticons)
            ->bind('emoticons', $emoticons);
        
        $posticons = Jelly::select('forum_posticon')
            ->filter(array(
                'active' => 1
            ))
            ->execute();
                
        $emoticons = Jelly::select('forum_emoticon')
            ->filter(array(
                'active' => 1
            ))
            ->execute()
            ->as_array();
        
        $forum = Jelly::select('forum_forum', $this->request->param('id'));
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty')
                ->rule('content', 'not_empty');
            
            if ($post->check())
            {
                $notification = (input::post('notification')) ? ';' . Auth::instance()->get_user()->id : '';
                    
                $active = ($forum->moderated == 1) ? 0 : 1;
                                       
                //zapisz temat do bazy
                $topic = Jelly::factory('forum_topic');
                $topic->forum = $forum->id;
                $topic->user = Auth::instance()->get_user()->id;
                $topic->icon = input::post('icon');
                $topic->name = Security::xss_clean(input::post('name'));
                $topic->slug = URL::prepare_url(Security::xss_clean(input::post('name')));                    
                $topic->notification = $notification;
                $topic->views = 1;
                $topic->replies = 1;
                
                if (input::post('subaction') == 'announce')
                {
                    $topic->type = 100;
                }
                else if (input::post('subaction') == 'attention')
                {
                    $topic->type = 1;
                }
                 
                $topic->active = $active;
                    
                if (input::post('subaction') == 'close')
                {
                    $topic->opened = 0;
                }
                   
                $topic->save();
                    
                //zapisz post do bazy
                $disable_bbcode = (input::post('disablebb') == 1 ) ? 1 : 0;
                $disable_smilies = (input::post('disablesmileys') == 1 ) ? 1 : 0;
                $use_links = (input::post('parseurl') == 1) ? 1 : 0;
                    
                $posting = Jelly::factory('forum_post');
                $posting->user = Auth::instance()->get_user()->id;
                $posting->topic = $topic->id;
                $posting->name = Security::xss_clean(input::post('name'));
                $posting->content = Security::xss_clean(input::post('content'));
                $posting->use_bbcode = $use_bbcode;
                $posting->use_smilies = $use_smilies;
                $posting->use_links = $use_links;
                $posting->opened = $active;
                $posting->save();
                    
                //dodaj zalaczniki do posta
                foreach(input::post('attachments') as $a) {
                    $attachment = Jelly::select('attachment', $a);
                    $attachment->obj_id = $posting->id;
                    $attachment->save();
                }
                    
                //zaktualizuj temat
                $topic->post = $posting->id;
                $topic->post_on = date('Y-m-d H:i:s');
                $topic->save();
                    
                //zaktualizuj forum
                $forum->post = $posting->id;
                $forum->post_on = date('Y-m-d H:i:s');
                $forum->save();
                
                //oznacz jako przeczytane
                Forum::set_topic_read($topic->id, Auth::instance()->get_user()->id);
                
                Tracker::track('Dodano wątek ID: '.$topic->id.' na forum ID: '.$forum->id);

                message::good('Wątek został dodany pomyślnie', 'admin/forum_topics/index/'.$forum->id.URL::query());
            }
            else
            {
                $errors = $post->errors('backend/forum/topics/form');
            }
        }
    }

    public function action_edit()
    {
        $this->template->content = View::factory('admin/forum/topics/edit.tpl')
            ->bind('errors', $errors)
            ->bind('posticons', $posticons)
            ->bind('item', $item)
            ->bind('poster', $poster)
            ->bind('attachments', $attachments);

        $posticons = Jelly::select('forum_posticon')
            ->filter(array(
                'active' => 1
            ))
            ->execute();
                
        $emoticons = Jelly::select('forum_emoticon')
            ->filter(array(
                'active' => 1
            ))
            ->execute()
            ->as_array();
        
        $item = Jelly::select('forum_topic', $this->request->param('id'));
        
        $poster = Jelly::select('forum_post')
            ->where('topic_id', '=', $item->id)
            ->order_by('id', 'ASC')
            ->limit(1)
            ->execute();
        
        $attachments = Jelly::select('attachment')
            ->filter($poster->id, 'forum_post')
            ->execute();
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty')
                ->rule('content', 'not_empty');
            
            if ($post->check())
            {
                //zapisz temat do bazy
                $topic->icon = input::post('icon');
                $topic->name = Security::xss_clean(input::post('name'));
                $topic->slug = URL::prepare_url(Security::xss_clean(input::post('name')));
                
                if (input::post('subaction') == 'announce')
                {
                    $topic->type = 100;
                }
                else if (input::post('subaction') == 'attention')
                {
                    $topic->type = 1;
                }
                
                if (input::post('subaction') == 'close')
                {
                    $topic->opened = 0;
                }
                   
                $topic->save();
                
                //zapisz post do bazy
                $disable_bbcode = (input::post('disablebb') == 1 ) ? 1 : 0;
                $disable_smilies = (input::post('disablesmileys') == 1 ) ? 1 : 0;
                $use_links = (input::post('parseurl') == 1) ? 1 : 0;
                    
                $poster->name = Security::xss_clean(input::post('name'));
                $poster->content = Security::xss_clean(input::post('content'));
                $poster->use_bbcode = $use_bbcode;
                $poster->use_smilies = $use_smilies;
                $poster->use_links = $use_links;
                $poster->opened = $opened;
                $poster->save();
                
                /**
                 * Dodaj zalaczniki do posta
                 */
                foreach(input::post('attachments') as $a) {
                    $attachment = Jelly::select('attachment', $a);
                    $attachment->obj_id = $poster->id;
                    $attachment->save();
                }
                
                Tracker::track('Edycja wątka ID: '.$item->id);

                message::good('Edycja przebiegła pomyślnie', 'admin/forum_topics/index/'.$item->forum->id.URL::query());
            }
            else
            {
                $errors = $post->errors('backend/forum/topics/form');
            }
        }
    }

    public function action_status()
    {
        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status)) {
            $item = Jelly::select('forum_topic', $this->request->param('id'));
            if ($item->loaded())
            {
                $item->active = $this->request->param('stuff');
                $item->save();

                Tracker::track('Zmiana statusu tematu ID: '.$item->id.' na forum ID: '.$item->forum->id);

                message::good('Status został zmieniony pomyślnie', 'admin/forum_topics/index/'.$item->forum->id.URL::query());
            }
            else
            {
                message::error('Status nie został zmieniony', 'admin/forum_topics/index/'.$item->forum->id.URL::query());
            }
        }
        else
        {
            message::error('Status nie został zmieniony', 'admin');
        }
    }
    
    public function action_close()
    {
        $allowed_status = array('0', '1', '2');
        if (in_array($this->request->param('stuff'), $allowed_status))
        {
            $item = Jelly::select('forum_topic', $this->request->param('id'));
            if ($item->loaded())
            {
                $item->opened = $this->request->param('stuff');
                $item->save();

                Tracker::track('Zmiana blokady tematu ID: '.$item->id.' na forum ID: '.$item->forum->id);

                message::good('Status został zmieniony pomyślnie', 'admin/forum_topics/index/'.$item->forum->id.URL::query());
            }
            else
            {
                message::error('Status nie został zmieniony', 'admin/forum_topics/index/'.$item->forum->id.URL::query());
            }
        }
        else
        {
            message::error('Status nie został zmieniony', 'admin');
        }
    }
    
    public function action_delete()
    {
        $item = Jelly::select('forum_topic', $this->request->param('id'));
        if ($item->loaded())
        {
            $forum_id = $item->forum->id;
            
            Tracker::track('Usunięto wątek ID: '.$item->id.' na forum ID: '.$item->forum->id);
            
            $item->delete();
            
            //ustawienie nowego postu jako ostatnio dodany 
            $post = Jelly::select('forum_topic')
                ->where('forum_id', '=', $forum_id)
                ->order_by('post_on', 'DESC')
                ->limit(1)
                ->execute();
                    
            if ($post->loaded())
            {
                DB::update('forum_forums')
                    ->set(array(
                        'post_on' => $post->created_on,
                        'post_id' => $post->id
                    ))
                    ->where('id', '=', $forum_id)
                    ->execute(); 
            }
            else
            {
                DB::update('forum_forums')
                    ->set(array(
                        'post_on' => NULL,
                        'post_id' => NULL
                ))
                ->where('id', '=', $forum_id)
                ->execute(); 
                       
            }

            message::good('Usunięcie przebiegło pomyślnie', 'admin/forum_topics/index/'.$forum_id.URL::query());
        }
        else
        {
            message::error('Wystąpił błąd podczas usuwania', 'admin');
        }
    }
    
    public function action_checkbox()
    {
        if ($_POST)
        {
            $method_to_call = '_checkbox_'.input::post('action');
            if (method_exists($this, $method_to_call))
            {
                $this->$method_to_call();
            }
        }
        
        message::good('Operacja przeprowadzona pomyślnie', 'admin/forum_topics/index/'.$this->request->param('id').URL::query());
    }
    
    /**
     * Checkbox - Aktywuj
     */
    private function _checkbox_publish()
    {
        $in_items = array();
        if (is_array(input::post('list')))
        {
            foreach(input::post('list') as $key => $value) {
                $in_items[] = $value;
            }
        }
        
        if (!empty($in_items))
        {
            $items = Jelly::select('forum_topic')
                ->where('id', 'IN', $in_items)
                ->execute();
            
            foreach($items as $it) {
                Tracker::track('Zmiana statusu tematu ID: '.$it->id.' na forum ID: '.$it->forum->id);
                    
                $it->active = 1;
                $it->save();
            }
        }
    }
    
    /**
     * Checkbox - Deaktywuj
     */
    private function _checkbox_unpublish()
    {
        $in_items = array();
        if (is_array(input::post('list')))
        {
            foreach(input::post('list') as $key => $value) {
                $in_items[] = $value;
            }
        }
        
        if (!empty($in_items))
        {
            $items = Jelly::select('forum_topic')
                ->where('id', 'IN', $in_items)
                ->execute();
            
            foreach($items as $it) {
                Tracker::track('Zmiana statusu tematu ID: '.$it->id.' na forum ID: '.$it->forum->id);
                    
                $it->active = 0;
                $it->save();
            }
        }
    }
    
    /**
     * Checkbox - Zamknij
     */
    private function _checkbox_open()
    {
        $in_items = array();
        if (is_array(input::post('list')))
        {
            foreach(input::post('list') as $key => $value) {
                $in_items[] = $value;
            }
        }
        
        if (!empty($in_items))
        {
            $items = Jelly::select('forum_topic')
                ->where('id', 'IN', $in_items)
                ->execute();
            
            foreach($items as $it) {
                Tracker::track('Zmiana blokady tematu ID: '.$it->id.' na forum ID: '.$it->forum->id);
                    
                $it->opened = 1;
                $it->save();
            }
        }
    }
    
    /**
     * Checkbox - Zamknij
     */
    private function _checkbox_close()
    {
        $in_items = array();
        if (is_array(input::post('list')))
        {
            foreach(input::post('list') as $key => $value) {
                $in_items[] = $value;
            }
        }
        
        if (!empty($in_items))
        {
            $items = Jelly::select('forum_topic')
                ->where('id', 'IN', $in_items)
                ->execute();
            
            foreach($items as $it) {
                Tracker::track('Zmiana blokady tematu ID: '.$it->id.' na forum ID: '.$it->forum->id);
                    
                $it->opened = 0;
                $it->save();
            }
        }
    }
    
    /**
     * Checkbox - Ogłoszenie
     */
    private function _checkbox_announcement()
    {
        $in_items = array();
        if (is_array(input::post('list')))
        {
            foreach(input::post('list') as $key => $value) {
                $in_items[] = $value;
            }
        }
        
        if (!empty($in_items))
        {
            $items = Jelly::select('forum_topic')
                ->where('id', 'IN', $in_items)
                ->execute();
            
            foreach($items as $it) {
                Tracker::track('Zmiana typu tematu ID: '.$it->id.' na forum ID: '.$it->forum->id);
                    
                $it->type = 100;
                $it->save();
            }
        }
    }
    
    /**
     * Checkbox - Ogłoszenie
     */
    private function _checkbox_sticky()
    {
        $in_items = array();
        if (is_array(input::post('list')))
        {
            foreach(input::post('list') as $key => $value) {
                $in_items[] = $value;
            }
        }
        
        if (!empty($in_items))
        {
            $items = Jelly::select('forum_topic')
                ->where('id', 'IN', $in_items)
                ->execute();
            
            foreach($items as $it) {
                Tracker::track('Zmiana typu tematu ID: '.$it->id.' na forum ID: '.$it->forum->id);
                    
                $it->type = 1;
                $it->save();
            }
        }
    }
    
    /**
     * Checkbox - Normalny
     */
    private function _checkbox_normal()
    {
        $in_items = array();
        if (is_array(input::post('list')))
        {
            foreach(input::post('list') as $key => $value) {
                $in_items[] = $value;
            }
        }
        
        if (!empty($in_items))
        {
            $items = Jelly::select('forum_topic')
                ->where('id', 'IN', $in_items)
                ->execute();
            
            foreach($items as $it) {
                Tracker::track('Zmiana typu tematu ID: '.$it->id.' na forum ID: '.$it->forum->id);
                    
                $it->type = 0;
                $it->save();
            }
        }
    }
    
    /**
     * Checkbox - Usuwanie
     */
    private function _checkbox_delete()
    {
        $in_items = array();
        if (is_array(input::post('list')))
        {
            foreach(input::post('list') as $key => $value) {
                $in_items[] = $value;
            }
        }
        
        if (!empty($in_items))
        {
            $items = Jelly::select('forum_posticon')
                ->where('id', 'IN', $in_items)
                ->execute();
            
            foreach($items as $it) {
                $forum_id = $item->forum->id;
            
                Tracker::track('Usunięto wątek ID: '.$it->id.' na forum ID: '.$it->forum->id);
                
                $it->delete();
                
                //ustawienie nowego postu jako ostatnio dodany 
                $post = Jelly::select('forum_topic')
                    ->where('forum_id', '=', $forum_id)
                    ->order_by('post_on', 'DESC')
                    ->limit(1)
                    ->execute();
                        
                if ($post->loaded())
                {
                    DB::update('forum_forums')
                        ->set(array(
                            'post_on' => $post->created_on,
                            'post_id' => $post->id
                        ))
                        ->where('id', '=', $forum_id)
                        ->execute(); 
                }
                else
                {
                    DB::update('forum_forums')
                        ->set(array(
                            'post_on' => NULL,
                            'post_id' => NULL
                    ))
                    ->where('id', '=', $forum_id)
                    ->execute(); 
                           
                }
            }
        }
    }
}