<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Login extends Relio_Controller_Admin {
    public $template = 'admin/layout_login.tpl';
    
    public function action_index()
    {
        if ( ! Auth::instance()->logged_in())
        {
            $this->template->content = View::factory('admin/login.tpl')
                ->bind('message', $message)
                ->bind('errors', $errors);
            
            $message = message::get_once();
            
            if ($_POST)
            {
                if (Auth::instance()->login(input::post('username'), input::post('password'), false))
                {
                    if (Session::instance()->get('auth_user')->logins == 1)
                    {
                        Request::instance()->redirect('admin/users/profile');
                    }
                    else
                    {
                        Request::instance()->redirect('admin/welcome');
                    }
                }
                else
                {
                    $errors = 'Błędny login i/lub hasło';
                }
            }
        }
        else
        {
            Request::instance()->redirect('admin/welcome');
        }
    }
    
    public function action_lostpassword()
    {
        if ($_POST)
        {
            $user = Jelly::select('user')
                ->where('email', '=', Security::xss_clean(input::post('email')))
                ->limit(1)
                ->execute();
                    
            if ($user->loaded())
            {
                $message = View::factory('smarty:admin/emails/lostpass_first')
                    ->set('validationKey', SHA1(input::post('email')))
                    ->render();
                    
                $swift = Email::connect();
                Email::send(input::post('email'), CFG_WEBMASTER_EMAIL, 'Platforma e-learningowa - Resetowanie hasła krok 1', $message, true);
                    
                message::good('Instrukcja została wysłana na podany e-mail', 'admin/login#lostpass');
            }
            else
            {
                message::error('Błędny adres e-mail', 'admin/login#lostpass');
            }
        }
    }
    
    public function action_regenerate()
    {
        $user = Jelly::select('user')
            ->where(DB::expr('SHA1("email")'), '=', Security::xss_clean($this->request->param('id')))
            ->limit(1)
            ->execute();
        
        if ($user->loaded())
        {
            $newPassword = Text::random('alnum', 8);
            
            $message = View::factory('smarty:admin/emails/lostpass_second')
                    ->set('newPassword', $newPassword)
                    ->render();

            $user->password = $newPassword;
			$user->password_confirm = $newPassword;
            $user->save();
            
            $swift = Email::connect();
            Email::send($user->email, CFG_WEBMASTER_EMAIL, 'Platforma e-learningowa - Resetowania hasła krok 2', $message, true);
            
            message::good('Wysłano e-mail z nowym hasłem', 'admin/login#lostpass');
        }
        else
        {
       	    message::error('Błędny kod autoryzacji', 'admin/login#lostpass');
        }
    }
}
