<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Material extends Relio_Controller_Admin {
    
    public function action_add()
    {
        parent::$_acl->check('materials', 'add');
        
        $this->template->content = View::factory('smarty:admin/materials/add')
            ->bind('errors', $errors)
            ->bind('parent_id', $parent_id);
        
        $parent_id = $this->request->param('id');
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty')
                ->rule('type', 'not_empty');
            
            if ($post->check())
            {
                $item = Jelly::factory('material');
                $max_posy = $item->preparePosyLast($this->request->param('stuff'));
                $item->name = Security::xss_clean(input::post('name'));
                $item->type = Security::xss_clean(input::post('type'));
                $item->posy = ($max_posy+1);
                $item->save();
                
                $material = Jelly::select('category', $this->request->param('stuff'));
                $material->add('material', $item);
                $material->save();
                    
                Tracker::track(__('Dodano materiał ID: ').$item->id);
                
                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/base/index/'.$this->request->param('id'));
            }
            else
            {
                $errors = $post->errors('backend/material/form');
            }
        }
    }

    public function action_add_popup()
    {
        $this->template->content = View::factory('admin/materials/popup/add.tpl')
            ->bind('errors', $errors)
            ->bind('item', $item)
            ->bind('parent_id', $parent_id);
        
        $item = Jelly::select('material', $this->request->param('id'));

        $lesson = Jelly::select('material_lesson')
            ->by_material($item->id)
            ->limit(1)
            ->execute();
        
        $parent_id = $item->category->first_parent_id;
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty')
                ->rule('content', 'not_empty')
                ->rule('content', 'min_length', array('10'));
            
            if ($post->check())
            {
                $popup = Jelly::factory('material_popup');
                $popup->set(array(
                    'name' => Security::xss_clean(input::post('name')),
                    'content' => input::post('content'),
                    'material' => $item->id
                ));
                $popup->save();
                
                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/material_lesson/index/'.$lesson->id);
            }
            else
            {
                $errors = $post->errors();
            }
        }
    }
    
    public function action_edit()
    {
        parent::$_acl->check('materials', 'edit');
        
        $this->template->content = View::factory('smarty:admin/materials/edit')
            ->bind('errors', $errors)
            ->bind('item', $item)
            ->bind('parent_id', $parent_id)
            ->bind('modules', $modules);
    
        $item = Jelly::select('material', (int)$this->request->param('id'));
        
        $parent_id = $item->category->first_parent_id;

        $modules = Jelly::select('category')->filter($parent_id, 0)->execute();
        
        if ($_POST)
        {
            $post = Validate::factory($_POST);
            $post->rule('name', 'not_empty');
            $post->rule('type', 'not_empty');
            
            if ($post->check())
            {
                $item->name = Security::xss_clean(input::post('name'));
                $item->type = Security::xss_clean(input::post('type'));
                $item->save();

                if (input::post('module') <> $item->category->id)
                {
                    $item->preparePosy(Security::xss_clean(input::post('module')));
                    $item->category = Security::xss_clean(input::post('module'));
                    $item->save();
                }
                
                Tracker::track(__('Edycja materiału ID: ').$this->request->param('id'));
                
                message::good(__('Edycja przebiegła pomyślnie'), 'admin/base/index/'.$item->category->first_parent_id);
            }
            else 
            {
                $errors = $post->errors('backend/material/form');
            }
        }
    }

    public function action_edit_popup()
    {
        $this->template->content = View::factory('admin/materials/popup/edit.tpl')
            ->bind('errors', $errors)
            ->bind('item', $item)
            ->bind('popup', $popup)
            ->bind('parent_id', $parent_id);
        
        $popup = Jelly::select('material_popup', $this->request->param('id'));
        
        $item = Jelly::select('material', $popup->material->id);

        $lesson = Jelly::select('material_lesson')
            ->by_material($item->id)
            ->limit(1)
            ->execute();
        
        $parent_id = $item->category->first_parent_id;
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty')
                ->rule('content', 'not_empty')
                ->rule('content', 'min_length', array('10'));
            
            if ($post->check())
            {
                $popup->set(array(
                    'name' => Security::xss_clean(input::post('name')),
                    'content' => input::post('content')
                ));
                $popup->save();
                
                message::good(__('Edycja przebiegła pomyślnie'), 'admin/material_lesson/index/'.$lesson->id);
            }
            else
            {
                $errors = $post->errors();
            }
        }
    }
    
    public function action_sort()
    {
        $sort = input::post('material');
        
        for ($i = 0; $i < count($sort); $i++) {
            $z = ($i+1);
            DB::update('materials')
                ->set(array(
                    'posy' => $z
                ))
                ->where('id', '=', $sort[$i])
                ->where('category_id', '=', input::get('category'))
                ->execute();
        }
    }
    
    public function action_delete()
    {
        parent::$_acl->check('materials', 'delete');
        
        $item = Jelly::select('material', (int)$this->request->param('id'));
        if ($item->loaded())
        {
            Tracker::track(__('Usunięto materiał ID: :material z kategorii ID: :category', array('material' => $this->request->param('id'), 'category' => $this->request->param('stuff'))));
            
            $item->rePosy($item->category->id);
            
            $item->delete();
                        
            message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/base/index/'.$this->request->param('stuff'));
        }
        else
        {
            message::error(__('Wystąpił błąd podczas usuwania'), 'admin');
        }
    }

    public function action_delete_popup()
    {
        $item = Jelly::select('material_popup', $this->request->param('id'));
        if ($item->loaded())
        {
            $material_id = $item->material->id;

            $lesson = Jelly::select('material_lesson')
                ->by_material($item->id)
                ->limit(1)
                ->execute();

            $item->delete();
            
            message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/material_lesson/edit/'.$lesson->id);
        }
        else
        {
            message::error(__('Wystąpił błąd podczas usuwania'), 'admin');
        }
    }
}