<?php defined('SYSPATH') or die('No direct script access.');

require_once Kohana::find_file('vendor', 'pclzip/pcltrace.lib');
require_once Kohana::find_file('vendor', 'pclzip/pclzip-trace.lib');

require_once Kohana::find_file('vendor', 'scorm/lms_scorm.class');
require_once Kohana::find_file('vendor', 'scorm/lms_scorm.lib');
require_once Kohana::find_file('vendor', 'scorm/lms_scorm.operate');

class Controller_Admin_Material_Scorm extends Relio_Controller_Admin {
    public function action_index() {
        parent::$_acl->check('materials', 'edit');
        
        $this->template->content = View::factory('smarty:admin/materials/scorm/edit')
            ->bind('errors', $errors)
            ->bind('item', $item)
            ->bind('lesson', $lesson)
            ->bind('scorm', $scorm)
            ->bind('parent_id', $parent_id);
    
        $item = Jelly::select('material', $this->request->param('id'));
        
        $lesson = Jelly::select('material_scorm')->by_material($item->id)->limit(1)->execute();
        
        $scorm = Jelly::select('scorm')->where('material_id', '=', $item->id)->limit(1)->execute();
        
        $parent_id = $item->category->first_parent_id;
        
        if ($_POST) {
            if (input::post('scorm_action') == '3') {
                if (input::post('hidFileID')) {
                    $filenamescorm = input::post('hidFileID');
                    
                    $scorm_pack_id = Scorm::instance()->upload($filenamescorm);
                    
                    $package = Jelly::select('scorm_package', $scorm_pack_id);
                    $package->window_height = '800';
                    $package->save();

                    $scorm_instance = jlms_scorm_add_instance($item->id, $scorm_pack_id);
                    
                    if ((isset($scorm_instance->id) and $scorm_instance->id)) {
                        $scorm = Jelly::select('scorm', $scorm_instance->id);
                        $scorm->material_id = $item->id;
                        $scorm->save();
                    }
                    else {
                        Scorm::instance()->deldir(DOCROOT.'upload/materials/scorm/'.$package->folder_srv_name.'/');
                        unlink(DOCROOT.'upload/materials/scorm/'.$package->package_srv_name);
                        
                        DB::delete('jos_lms_n_scorm_packages')->where('id', '=', $package->id)->execute();
                        
                        message::good('Wystąpił błąd podczas dodawania paczki SCORM', 'admin/base/index/'.$item->category->first_parent_id);
                    }
                }
                else {
                    $filenamescorm = null;
                }
            }
            elseif (input::post('scorm_action') == '1') {
                $filenamescorm = input::post('tmpScorm');
            }
            elseif (input::post('scorm_action') == '2') {
                $filenamescorm = null;
            }
            else {
                $filenamescorm = null;
            }
            
            if (!$lesson->loaded()) {
                $lesson = Jelly::factory('material_scorm');
            }
            
            $lesson->help = input::post('help');
            $lesson->material = $item->id;
            $lesson->file = $filenamescorm;
            $lesson->save();
            
            /**
             * Załączniki
             */
            $attachments = explode(',', input::post('attachments_id'));
            for ($i = 0; $i <= sizeof($attachments); $i++) {
                if (isset($attachments[$i])) {
                    $attachment = Jelly::select('attachment')->where('slug','=',$attachments[$i])->limit(1)->execute();
                    if ($attachment->loaded()) {
                        $attachment->obj_id = $item->id;
                        $attachment->save();
                    }
                }
            }
            
            if ($scorm->loaded()) {
                $scorm->maxgrade = Security::xss_clean(input::post('maxgrade'));
                $scorm->maxattempt = Security::xss_clean(input::post('maxattempt'));
                $scorm->popup = Security::xss_clean(input::post('popup'));
                $scorm->save();
            }
            
            Tracker::track(__('Edycja materiału w bazie szkoleń ID: ').$this->request->param('id'));
            
            message::good(__('Edycja przebiegła pomyślnie'), 'admin/base/index/'.$item->category->first_parent_id);
        }
    }
}