<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Modules_Articles extends Relio_Controller_Admin {
    public function action_index() {
        parent::$_acl->check('articles', 'list');

        $this->template->content = View::factory('admin/modules/articles/list.tpl')
            ->bind('message', $message)
            ->bind('page_id', $page_id)
            ->bind('tree', $tree)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();
        $page_id = $this->request->param('id');

        $current_root = Kohana::config('devilcms.defaults.languages.pl.id');
        $root = Jelly::factory('page')->root($current_root);

        $tree = $root->render_descendants('jstree', false, 'ASC');

        $builder = Jelly::select('modules_article')->by_page($page_id);

        $order_how = (input::get('how')) ? input::get('how') : 'DESC';

        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';

        $sort = array(
            'name'   => URL::query(array('sort' => 'name', 'how' => $order_direction)),
            'date'   => URL::query(array('sort' => 'date', 'how' => $order_direction)),
            'status' => URL::query(array('sort' => 'status', 'how' => $order_direction))
        );

        switch (input::get('sort')) {
            case 'name':
                $builder->order_by('name', $order_how);
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;
            case 'date':
                $builder->order_by('created_on', $order_how);
                $current_sort = array('type' => 'date', 'how' => $order_how);
            break;
            case 'status':
                $builder->order_by('active', $order_how);
                $current_sort = array('type' => 'status', 'how' => $order_how);
            break;
            default:
            break;
        }

        if (input::get('limit')) {
            $limit = input::get('limit');
        }
        else {
            $limit = 10;
        }
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add() {
        parent::$_acl->check('articles', 'add');

        $this->template->content = View::factory('smarty:admin/modules/articles/add')
            ->bind('errors', $errors)
            ->bind('tree', $tree);

        $current_root = Kohana::config('devilcms.defaults.languages.pl.id');
        $root = Jelly::factory('page')->root($current_root);

        $tree = $root->render_descendants('jstree', false, 'ASC');

        if ($_POST) {
            //ikona
            if (input::post('icon')) {
                $filenameicon = trim(urldecode(input::post('icon')), '/');
            }
            else {
                $filenameicon = '';
            }

            $item = Jelly::factory('modules_article');
            $item->preparePosy($this->request->param('id'));
            $item->name = Security::xss_clean(input::post('name'));
            $item->content_short = Security::xss_clean(input::post('content_short'));
            $item->content = Security::xss_clean(input::post('content'));
            $item->slug = $item->mod_url(Url::prepare_url(Security::xss_clean(input::post('name'))));
            $item->icon = $filenameicon;
            $item->save();

            $page = Jelly::select('page', $this->request->param('id'));
            $page->add('articles', $item);
            $page->save();

            /**
             * Załączniki
             */
            $attachments = explode(',', input::post('attachments_id'));
            for ($i = 0; $i <= sizeof($attachments); $i++) {
                if (isset($attachments[$i])) {
                    $attachment = Jelly::select('attachment')->where('slug', '=', $attachments[$i])->limit(1)->execute();
                    if ($attachment->loaded()) {
                        $attachment->obj_id = $item->id;
                        $attachment->save();
                    }
                }
            }

            Tracker::track(__('Dodano artykuł ID: ').$item->id);

            message::good(__('Dodanie przebiegło pomyślnie'), 'admin/modules_articles/index/'.$this->request->param('id'));
        }
    }

    public function action_edit() {
        parent::$_acl->check('articles', 'edit');

        $this->template->content = View::factory('smarty:admin/modules/articles/edit')
            ->bind('errors', $errors)
            ->bind('tree', $tree)
            ->bind('item', $item);

        $current_root = Kohana::config('devilcms.defaults.languages.pl.id');
        $root = Jelly::factory('page')->root($current_root);

        $tree = $root->render_descendants('jstree', false, 'ASC');

        $item = Jelly::select('modules_article', $this->request->param('id'));

        if ($_POST) {
            //ikona
            if (input::post('image_action') == '3') {
                if (input::post('icon')) {
                    $filenameicon = trim(urldecode(input::post('icon')), '/');
                }
                else {
                    $filenameicon = '';
                }
            }
            elseif (input::post('image_action') == '1') {
                $filenameicon = input::post('tmpIcon');
            }
            elseif (input::post('image_action') == '2') {
                $filenameicon = '';
            }
            else {
                $filenameicon = '';
            }

            $item->name = Security::xss_clean(input::post('name'));
            $item->content_short = Security::xss_clean(input::post('content_short'));
            $item->content = Security::xss_clean(input::post('content'));
            $item->icon = $filenameicon;
            $item->save();


            Tracker::track(__('Edycja artykułu ID: ').$item->id);
            
            message::good(__('Edycja przebiegła pomyślnie'), 'admin/modules_articles/index/'.$item->page->id.URL::query());
        }
    }

    public function action_status() {
        parent::$_acl->check('articles', 'edit');

        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status)) {
            $item = Jelly::select('modules_article', $this->request->param('id'));
            if ($item->loaded()) {
                Tracker::track(__('Zmiana statusu artykułu ID: ').$item->id);
                
                $item->active = $this->request->param('stuff');
                $item->save();

                message::good(__('Status został zmieniony pomyślnie'), 'admin/modules_articles/index/'.$item->page->id.URL::query());
            }
            else {
                message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
            }
        }
        else {
            message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
        }
    }

    public function action_up() {
        parent::$_acl->check('articles', 'edit');

        $item = Jelly::select('modules_article', $this->request->param('id'));
        if ($item->loaded()) {
            $item->positionUp('page_id', '=', $item->page->id);

            message::good(__('Pozycja została zmieniona pomyślnie'), 'admin/modules_articles/index/'.$item->page->id.URL::query());
        }
        else {
            message::error(__('Wystąpił błąd podczas zmiany pozycji'), 'admin');
        }
    }

    public function action_down() {
        parent::$_acl->check('articles', 'edit');

        $item = Jelly::select('modules_article', $this->request->param('id'));
        if ($item->loaded()) {
            $item->positionDown('page_id', '=', $item->page->id);

            message::good(__('Pozycja została zmieniona pomyślnie'), 'admin/modules_articles/index/'.$item->page->id.URL::query());
        }
        else {
            message::error(__('Wystąpił błąd podczas zmiany pozycji'), 'admin');
        }
    }

    public function action_delete() {
        parent::$_acl->check('articles', 'delete');

        $item = Jelly::select('modules_article', $this->request->param('id'));

        if ($item->loaded()) {
            Tracker::track(__('Usunięto artykuł ID: ').$item->id);
            
            $item->delete();

            message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/modules_articles/index/'.$item->page->id.URL::query());
        }
        else {
            message::error(__('Wystąpił błąd podczas usuwania'), 'admin');
        }
    }

    public function action_checkbox() {
        if ($_POST) {
            switch (input::post('action')) {
                case 'delete':
                    parent::$_acl->check('articles', 'delete');

                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('modules_article', $value);
                            if ($item->loaded()) {
                                Tracker::track(__('Usunięto artykuł ID: ').$item->id);
                                
                                $item->delete();
                            }
                        }
                    }
                break;
                case 'publish':
                    parent::$_acl->check('articles', 'edit');

                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('modules_article', $value);
                            if ($item->loaded()) {
                                Tracker::track(__('Zmiana statusu artykułu ID: ').$item->id);
                                
                                $item->active = 1;
                                $item->save();
                            }
                        }
                    }
                break;
                case 'unpublish':
                    parent::$_acl->check('articles', 'edit');

                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('modules_article', $value);
                            if ($item->loaded()) {
                                Tracker::track(__('Zmiana statusu artykułu ID: ').$item->id);
                                
                                $item->active = 0;
                                $item->save();
                            }
                        }
                    }
                break;
            }

            message::good(__('Operacja przeprowadzona pomyślnie'), 'admin/modules_articles/index/'.$this->request->param('id').URL::query());
        }
    }
}
