<?php defined('SYSPATH') or die('No direct script access.');

require_once Kohana::find_file('vendor', 'FlashUploader.class');

class Controller_Admin_Modules_Contact extends Relio_Controller_Admin {
    public function action_index() {
        parent::$_acl->check('content', 'edit');
        
        $this->template->content = View::factory('smarty:admin/modules/contact/list')
            ->bind('errors', $errors)
            ->bind('message', $message)
            ->bind('tree', $tree)
            ->bind('item', $item);
        
        $message = message::get_once();
        
        $current_root = Kohana::config('devilcms.defaults.languages.pl.id');
        $root = Jelly::factory('page')->root($current_root);
        
        $tree = $root->render_descendants('jstree', false, 'ASC');
        
        $page = Jelly::select('page', $this->request->param('id'));
		
        $check = Jelly::select('modules_contact_detail')->by_page($this->request->param('id'))->limit(1)->execute();
        if ($check->loaded()) {
            $item = Jelly::select('modules_contact_detail')->by_page($this->request->param('id'))->limit(1)->execute();

        }
                
        if ($_POST) {
            try {
                if ($check->loaded()) {
                    $item->set($_POST);
                    $item->save();
                }
                else {
                    $item = Jelly::factory('modules_contact_detail');
                    $item->set($_POST);
                    $item->save();
                                
                    $page = Jelly::select('page', $this->request->param('id'));
                    $page->add('contact', $item);
                    $page->save();
                }
                
                message::good(__('Edycja przebiegła pomyślnie'), 'admin/modules_contact/index/'.$this->request->param('id'));
            }
            catch(Validate_Exception $e) {
                $errors = $e->array->errors('shindig/crud');
            }
        }
    }
}
