<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Schools extends Relio_Controller_Admin {
    public function action_index()
    {
        parent::$_acl->check('schools', 'list');
        
        $this->template->content = View::factory('admin/schools/list.tpl')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();

        $builder = Jelly::select('school')
            ->with('user');
        
        if (Auth::instance()->get_user()->has_role('moderator'))
        {
            $builder->where('user_id', '=', Auth::instance()->get_user()->id);
        }
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'name' => URL::query(array('sort' => 'name', 'how' => $order_direction)),
            'user' => URL::query(array('sort' => 'user', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'name':
                $builder->order_by('name', $order_how);
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;
            case 'user':
                $builder->order_by('_user:user.firstname', $order_how);
                $current_sort = array('type' => 'user', 'how' => $order_how);
            break;            
            default:
            break;
        }
        
        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add()
    {
        parent::$_acl->check('schools', 'add');
        
        $this->template->content = View::factory('admin/schools/add.tpl')
            ->bind('errors', $errors)
            ->bind('users', $users);
        
        $users = Jelly::select('user')
            ->join('roles_users', 'LEFT')
            ->on('users.id', '=', 'roles_users.user_id')
            ->on('roles_users.role_id', '=', DB::expr(3))
            ->where('roles_users.role_id', '=', '3')
            ->execute();
            
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('user', 'not_empty')
                ->rule('name', 'not_empty');
            
            if ($post->check())
            {
                $item = Jelly::factory('school');
                $item->user = Security::xss_clean(input::post('user'));
                $item->name = Security::xss_clean(input::post('name'));
                $item->save();

                Tracker::track('Dodano szkołę ID: '.$item->id);

                message::good('Dodanie przebiegło pomyślnie', 'admin/schools');
            }
            else
            {
                $errors = $post->errors('backend/schools/form');
            }
        }
    }

    public function action_edit()
    {
        parent::$_acl->check('schools', 'edit');
        
        $this->template->content = View::factory('admin/schools/edit.tpl')
            ->bind('errors', $errors)
            ->bind('users', $users)
            ->bind('item', $item);
        
        $users = Jelly::select('user')
            ->join('roles_users', 'LEFT')
            ->on('users.id', '=', 'roles_users.user_id')
            ->on('roles_users.role_id', '=', DB::expr(3))
            ->where('roles_users.role_id', '=', '3')
            ->execute();
            
        $item = Jelly::select('school', $this->request->param('id'));

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('user', 'not_empty')
                ->rule('name', 'not_empty');
            
            if ($post->check())
            {
                $item->user = Security::xss_clean(input::post('user'));
                $item->name = Security::xss_clean(input::post('name'));
                $item->save();

                Tracker::track('Edycja szkoły ID: '.$item->id);

                message::good('Edycja przebiegła pomyślnie', 'admin/schools');
            }
            else
            {
                $errors = $post->errors('backend/schools/form');
            }
        }
    }
    
    public function action_delete()
    {
        parent::$_acl->check('schools', 'delete');
        
        $item = Jelly::select('school', $this->request->param('id'));
        if ($item->loaded())
        {
            $item->delete();

            Tracker::track('Usunięto szkołę ID: ' . $this->request->param('id'));

            message::good('Zlecenie zostało usunięte pomyślnie', 'admin/schools');
        }
        else
        {
            message::error('Wystąpił błąd podczas usuwania zlecenia', 'admin');
        }
    }
    
    public function action_checkbox()
    {
        if ($_POST)
        {
            $method_to_call = '_checkbox_'.input::post('action');
            if (method_exists($this, $method_to_call))
            {
                $this->$method_to_call();
            }
            
            message::good('Operacja przeprowadzona pomyślnie', 'admin/schools'.URL::query());
        }
    }
    
    /**
     * Checkbox - Usuń
     */
    private function _checkbox_delete()
    {
        parent::$_acl->check('schools', 'delete');
        
        if (is_array(input::post('list')))
        {
            $ids = array();
            foreach(input::post('list') as $key => $value) {
                $ids[] = $value;
            }
            
            if (empty($ids))
            {
                $ids[] = 0;
            }
            
            $items = Jelly::select('school')
                ->where('id', 'IN', $ids)
                ->execute();
        
            foreach($items as $it) {
                Tracker::track('Usunięto szkołę ID: '.$it->id);
                
                $it->delete();
            }
        }
    }
}