<?php defined('SYSPATH') or die('No direct script access.');

require_once Kohana::find_file('vendor', 'OFC/open-flash-chart');
require_once Kohana::find_file('vendor/', 'PHPExcel');
require_once Kohana::find_file('vendor/PHPExcel/Writer/', 'Excel5');
require_once Kohana::find_file('vendor/mpdf', 'mpdf');
require_once Kohana::find_file('vendor', 'scorm/lms_scorm.class');
require_once Kohana::find_file('vendor', 'scorm/lms_scorm.lib');

class Controller_Admin_Students_Waiting extends Relio_Controller_Admin {
    public function action_index() {
        parent::$_acl->check('students_waiting', 'list');
        
        $this->template->content = View::factory('smarty:admin/students/waiting/list')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('courses', $courses)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $builder_courses = Jelly::select('course')->filter(null, null);
        
        if (Auth::instance()->get_user()->has_role('moderator')) {
            $builder_courses->join('course_moderators', 'LEFT')
                ->on('course_moderators.course_id', '=', DB::expr('courses.id'))
                ->where('course_moderators.user_id', '=', Auth::instance()->get_user()->id);
        }
        
        $courses = $builder_courses->execute();
        
        $in_courses = ',0';
        foreach($courses as $c) {
            $in_courses .= ','.$c->id;
        }
        $in_courses = substr($in_courses, 1);
        
        $message = message::get_once();

        if (input::get('course')) {
            $builder = Jelly::select('course_user')
				->with('user')
				->filter(null, input::get('course'), input::get('course_status'), input::get('date_start'), input::get('date_end'), input::get('q'), null);
        }
        else {
            $builder = Jelly::select('course_user')
				->with('user')
				->filter(null, null, input::get('course_status'), input::get('date_start'), input::get('date_end'), input::get('q'), null);
        
            if (Auth::instance()->get_user()->has_role('moderator')) {
                $builder->where('course_id', 'IN', array(DB::expr($in_courses)));
            }
        }

        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'firstname' => URL::query(array('sort' => 'firstname', 'how' => $order_direction)),
            'lastname'  => URL::query(array('sort' => 'lastname', 'how' => $order_direction)),
            'course'    => URL::query(array('sort' => 'course', 'how' => $order_direction)),
            'signed'    => URL::query(array('sort' => 'signed', 'how' => $order_direction)),
            'laston'    => URL::query(array('sort' => 'laston', 'how' => $order_direction)),
            'complete'  => URL::query(array('sort' => 'complete', 'how' => $order_direction)),
            'time'      => URL::query(array('sort' => 'time', 'how' => $order_direction)),
            'login'     => URL::query(array('sort' => 'login', 'how' => $order_direction)),
            'status'    => URL::query(array('sort' => 'status', 'how' => $order_direction)),
            'payment'   => URL::query(array('sort' => 'payment', 'how' => $order_direction)),
            'percent'   => URL::query(array('sort' => 'percent', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'firstname':
                $builder->order_by('_user:user:firstname', $order_how);
                $current_sort = array('type' => 'firstname', 'how' => $order_how);
            break;
            case 'lastname':
                $builder->order_by('_user:user.lastname', $order_how);
                $current_sort = array('type' => 'lastname', 'how' => $order_how);
            break;
            case 'course':
                $builder->order_by('_course:course.name', $order_how);                    
                $current_sort = array('type' => 'course', 'how' => $order_how);
            break;
            case 'signed':
                $builder->order_by('signed_on', $order_how);
                $current_sort = array('type' => 'signed', 'how' => $order_how);
            break;
            case 'laston':
                $builder->order_by('last_on', $order_how);
                $current_sort = array('type' => 'laston', 'how' => $order_how);
            break;
            case 'complete':
                $builder->order_by('complete_on', $order_how);
                $current_sort = array('type' => 'complete', 'how' => $order_how);
            break;
            case 'time':
                $builder->order_by('time_on', $order_how);
                $current_sort = array('type' => 'time', 'how' => $order_how);
            break;
            case 'login':
                $builder->order_by('last_login', $order_how);
                $current_sort = array('type' => 'login', 'how' => $order_how);
            break;
            case 'status':
                $builder->order_by('active', $order_how);
                $current_sort = array('type' => 'status', 'how' => $order_how);
            break;
            case 'payment':
                $builder->order_by('_xwpayment:xwpayment.status', $order_how);
                $current_sort = array('type' => 'payment', 'how' => $order_how);
            break;
            case 'percent':
                $builder->order_by('percent', $order_how);
                $current_sort = array('type' => 'percent', 'how' => $order_how);
            break;
            default:
                $builder->order_by('id', 'DESC');
            break;
        }
        
        if (input::get('limit')) {
            $limit = input::get('limit');  
        }
        else {
            $limit = 10;  
        }
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));

        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_csv()
    {
        parent::$_acl->check('students_waiting', 'list');
        
        $builder_courses = Jelly::select('course')->filter(null, null);
        
        if (Auth::instance()->get_user()->has_role('moderator')) {
            $builder_courses->join('course_moderators', 'LEFT')
                ->on('course_moderators.course_id', '=', DB::expr('courses.id'))
                ->where('course_moderators.user_id', '=', Auth::instance()->get_user()->id);
        }
        
        $courses = $builder_courses->execute();
        
        $in_courses = ',0';
        foreach($courses as $c) {
            $in_courses .= ','.$c->id;
        }
        $in_courses = substr($in_courses, 1);
        
        $message = message::get_once();

        if (input::get('course'))
        {
            $builder = Jelly::select('course_user')
				->with('user')
				->filter(null, input::get('course'), input::get('course_status'), input::get('date_start'), input::get('date_end'), input::get('q'), null);
        }
        else
        {
            $builder = Jelly::select('course_user')
				->with('user')
				->filter(null, null, input::get('course_status'), input::get('date_start'), input::get('date_end'), input::get('q'), null);
        
            if (Auth::instance()->get_user()->has_role('moderator')) {
                $builder->where('course_id', 'IN', array(DB::expr($in_courses)));
            }
        }
        
        $items = $builder->execute();
        
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getProperties()->setCreator("etdXLSexport");
        $objPHPExcel->getProperties()->setLastModifiedBy("etdXLSexport");
        $objPHPExcel->getProperties()->setTitle("etdXLSexport");
        $objPHPExcel->getProperties()->setSubject("etdXLSexport");
        $objPHPExcel->getProperties()->setDescription("etdXLSexport");
        $objPHPExcel->setActiveSheetIndex(0);
        
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 1, 'Imię');
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 1, 'Nazwisko');
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 1, 'Szkolenie');
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 1, 'Zapisano');
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 1, 'Ostatnia akcja');
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 1, 'Ukończono');
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 1, 'Czas na szkoleniu');
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 1, 'Status');
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 1, 'Postęp (%)');
        
        
        $int_rowCounter = 2;
        
        foreach($items as $it) {
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, $int_rowCounter, $it->user->firstname);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $int_rowCounter, $it->user->lastname);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $int_rowCounter, $it->course->name);
            
            if ($it->signed_on)
            {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $int_rowCounter, $it->signed_on);
            }
            else
            {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $int_rowCounter, 'Brak danych');
            }
            
            if ($it->last_on)
            {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $int_rowCounter, $it->last_on);
            }
            else
            {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $int_rowCounter, 'Brak danych');
            }
            
            if ($it->complete_on)
            {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, $int_rowCounter, $it->complete_on);
            }
            else
            {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, $int_rowCounter, 'Brak danych');
            }
            
            if ($it->time_on)
            {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, $int_rowCounter, Date::seconds2time($it->time_on));
            }
            else
            {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, $int_rowCounter, 'Nie rozpoczęto');
            }
            
            
            if ($it->active == 2)
            {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, $int_rowCounter, 'Oczekuje');
            }
            else if($it->active == 1)
            {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, $int_rowCounter, 'Zaakceptowane');
            }
            else
            {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, $int_rowCounter, 'Odrzucone');
            }
                         
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, $int_rowCounter, $it->percent);
            
            $int_rowCounter++;
        }
        
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="zgloszenia_na_szkolenie'.date('Y_m_d').'.csv"');
        header('Cache-Control: max-age=0');
        
        $objWriter = new PHPExcel_Writer_CSV($objPHPExcel);
        $objWriter->save('php://output');
        exit;
    }
    
    public function action_pdf()
    {
        parent::$_acl->check('students_waiting', 'list');
        
        $builder_courses = Jelly::select('course')->filter(null, null);
        
        if (Auth::instance()->get_user()->has_role('moderator')) {
            $builder_courses->join('course_moderators', 'LEFT')
                ->on('course_moderators.course_id', '=', DB::expr('courses.id'))
                ->where('course_moderators.user_id', '=', Auth::instance()->get_user()->id);
        }
        
        $courses = $builder_courses->execute();
        
        $in_courses = ',0';
        foreach($courses as $c) {
            $in_courses .= ','.$c->id;
        }
        $in_courses = substr($in_courses, 1);
        
        $message = message::get_once();

        if (input::get('course'))
        {
            $builder = Jelly::select('course_user')
				->with('user')
				->filter(null, input::get('course'), input::get('course_status'), input::get('date_start'), input::get('date_end'), input::get('q'), null);
        }
        else
        {
            $builder = Jelly::select('course_user')
				->with('user')
				->filter(null, null, input::get('course_status'), input::get('date_start'), input::get('date_end'), input::get('q'), null);
        
            if (Auth::instance()->get_user()->has_role('moderator')) {
                $builder->where('course_id', 'IN', array(DB::expr($in_courses)));
            }
        }
        
        $items = $builder->execute();
        
        $table = '<table style="margin:0 0 33px 19px; border-right: 1px solid #ddd; border-top: 1px solid #ddd; font-size: 12px;" width="100%">'."\n";
        $table .= "\t<tr>";
        $table .= '<th style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; font-size: 12px; font-weight: bold; text-align: center;">Imię</th>';
        $table .= '<th style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; font-size: 12px; font-weight: bold; text-align: center;">Nazwisko</th>';
        $table .= '<th style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; font-size: 12px; font-weight: bold; text-align: center;">Szkolenie</th>';
        $table .= '<th style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; font-size: 12px; font-weight: bold; text-align: center;">Zapisano</th>';
        $table .= '<th style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; font-size: 12px; font-weight: bold; text-align: center;">Ostatnia akcja</th>';
        $table .= '<th style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; font-size: 12px; font-weight: bold; text-align: center;">Ukończono</th>';
        $table .= '<th style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; font-size: 12px; font-weight: bold; text-align: center;">Czas na szkoleniu</th>';
        $table .= '<th style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; font-size: 12px; font-weight: bold; text-align: center;">Status</th>';
        $table .= '<th style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; font-size: 12px; font-weight: bold; text-align: center;">Postęp (%)</th>';
        $table .= "</tr>\n";
        
        foreach($items as $it) {             
            $table .= "\t<tr>" ;                
            $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
            $table .= "\n" . $it->user->firstname . "\n";
            $table .= '</td>';
            
            $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
            $table .= "\n" . $it->user->lastname . "\n";
            $table .= '</td>';
            
            $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
            $table .= "\n" . $it->course->name . "\n";
            $table .= '</td>';
            
            if ($it->signed_on)
            {
                $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
                $table .= "\n" . $it->signed_on . "\n";
                $table .= '</td>';
            }
            else
            {
                $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
                $table .= "\nBrak danych\n";
                $table .= '</td>';
            }
            
            if ($it->last_on)
            {
                $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
                $table .= "\n" . $it->last_on . "\n";
                $table .= '</td>';
            }
            else
            {
                $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
                $table .= "\nBrak danych\n";
                $table .= '</td>';
            }
            
            if ($it->complete_on)
            {
                $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
                $table .= "\n" . $it->complete_on . "\n";
                $table .= '</td>';
            }
            else
            {
                $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
                $table .= "\nBrak danych\n";
                $table .= '</td>';
            }
            
            if ($it->time_on)
            {
                $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
                $table .= "\n" . Date::seconds2time($it->time_on) . "\n";
                $table .= '</td>';
            }
            else
            {
                $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
                $table .= "\nNie rozpoczęto\n";
                $table .= '</td>';
            }
            
            
            if ($it->active == 2)
            {
                $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
                $table .= "\nOczekuje\n";
                $table .= '</td>';
            }
            else if($it->active == 1)
            {
                $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
                $table .= "\nZaakceptowane\n";
                $table .= '</td>';
            }
            else
            {
                $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
                $table .= "\nOdrzucone\n";
                $table .= '</td>';
            }
                         
            $table .= '<td style="border-left: 1px solid #ddd; border-bottom: 1px solid #ddd; padding: 5px; background-color: #F9F9F9; text-align: center;">';
            $table .= "\n".$it->percent."\n";
            $table .= '</td>';
            $table .= "</tr>\n";          
        }
        
        $table .= '</table>';
        
        $parameters = array(
            '%title%' => 'Zgłoszenia na szkolenie',
            '%content%' => $table
        );
        
        $body = str_replace(array_keys($parameters), array_values($parameters), CFG_PDF_REPORT_TEMPLATE);
        
        $content_html = View::factory('smarty:site/emails/pdf')
            ->set('content', $body)
            ->render();
        
        $mpdf=new mPDF('UTF-8', array(298.89,340.55), 12, 'minyaregular'); 
        $mpdf->mirrorMargins = 1;	// Use different Odd/Even headers and footers and mirror margins
        
        $mpdf->defaultheaderfontsize = 10;	/* in pts */
        $mpdf->defaultheaderfontstyle = B;	/* blank, B, I, or BI */
        $mpdf->defaultheaderline = 1; 	/* 1 to include line below header/above footer */
        
        $mpdf->defaultfooterfontsize = 12;	/* in pts */
        $mpdf->defaultfooterfontstyle = B;	/* blank, B, I, or BI */
        $mpdf->defaultfooterline = 1; 	/* 1 to include line below header/above footer */
        
        $mpdf->SetFooter(array(
           'odd' => array(
               'L' => array(
            		'content' => CFG_PLATFORM_NAME,
            		'font-family' => 'arial',
            		'font-style' => 'B',	/* blank, B, I, or BI */
            		'font-size' => '10',	/* in pts */
    	       ),
               'C' => array(
                    'content' => '{PAGENO}/{nb}',
            		'font-family' => 'arial',
            		'font-style' => 'BI',
            		'font-size' => '10',	/* gives default */
               ),
               'R' => array(
            		'content' => 'Wydrukowano {DATE j-m-Y H:i}',
            		'font-family' => 'arial',
            		'font-style' => '',
            		'font-size' => '10',
               ),
               'line' => 1
           ),
           'even' => array(
               'L' => array(
            		'content' => CFG_PLATFORM_NAME,
            		'font-family' => 'arial',
            		'font-style' => 'B',	/* blank, B, I, or BI */
            		'font-size' => '10',	/* in pts */
    	       ),
               'C' => array(
                    'content' => '{PAGENO}/{nb}',
            		'font-family' => 'arial',
            		'font-style' => 'BI',
            		'font-size' => '10',	/* gives default */
               ),
               'R' => array(
            		'content' => 'Wydrukowano {DATE j-m-Y H:i}',
            		'font-family' => 'arial',
            		'font-style' => '',
            		'font-size' => '10',
               ),
               'line' => 1
           )
        ));
        
        $mpdf->WriteHTML($content_html);
        $mpdf->Output('zgloszenia_na_szkolenie_'.date('Y_m_d').'.pdf', 'D');
    }

    public function action_stats() {
        parent::$_acl->check('students_waiting', 'stats');
        
        $this->template->content = View::factory('smarty:admin/students/waiting/stats')
            ->bind('item', $item)
            ->bind('items', $items)
            ->bind('items_stats', $items_stats);
            
        $item = Jelly::select('course_user', $this->request->param('id'));
        
        $items = Jelly::select('category')->filter($item->course->category->id, 0)->execute();
        
        $items_stats = array();
        
        $stats = Jelly::select('material_stat')
            ->where('user_id','=',$item->user->id)
            ->where('course_id','=',$item->course->id)
            ->execute();
            
        foreach($stats as $s) {
            if ($s->status == '1') {
                $items_stats[$s->material->id] = array(
                    'status' => __('Zaliczone'),
                    'color'  => 'green',
                    'trials' => $s->trials
                );
            }
            
            if ($s->status == '0') {
                $items_stats[$s->material->id] = array(
                    'status' => __('Niezaliczone'),
                    'color'  => 'red',
                    'trials' => $s->trials
                );
            }
        }
    }
    
    public function action_stats_test() {
        parent::$_acl->check('students_waiting', 'stats_test');
        
        $this->template->content = View::factory('smarty:admin/students/waiting/stats_test')
            ->bind('questions', $questions)
            ->bind('answers', $answers)
            ->bind('is_correct', $is_correct)
            ->bind('trials', $trials)
            ->bind('percent', $percent);
        
        $test = Jelly::select('material_test')->by_material($this->request->param('id'))->limit(1)->execute();
        
        $questions = Jelly::select('question')->filter($test->id)->execute();
        
        $trials = Jelly::select('material_stat')
            ->where('test_id', '=', $test->id)
            ->where('material_id', '=', $this->request->param('id'))
            ->where('user_id', '=', $this->request->param('stuff'))
            ->limit(1)
            ->execute();
        
        $is_correct = array();
        $answers = array();
        $good_questions = 0;
        
        foreach($questions as $q) {
            $correct = Jelly::select('material_test_stat')
                ->where('question_id', '=', $q->id)
                ->where('user_id', '=', $this->request->param('stuff'))
                ->where('trial', '=', $this->request->param('stuff2'))
                ->limit(1)
                ->execute();
            
            switch ($q->type) {
                case '1':
                    $answers[$q->id] = Jelly::select('question_choice')->where('question_id','=',$q->id)->limit(1)->execute();
                    
                    $is_correct[$q->id] = array(
                        'answer' => unserialize($correct->answer),
                        'status' => $correct->is_good
                    );
                    
                    if ($correct->is_good) {
                        $good_questions++;
                    }
                
                break;
                case '2':
                    $answers[$q->id] = Jelly::select('question_choice')->where('question_id','=',$q->id)->limit(1)->execute();
                    
                    $is_correct[$q->id] = array(
                        'answer' => unserialize($correct->answer),
                        'status' => $correct->is_good
                    );
                    
                    if ($correct->is_good) {
                        $good_questions++;
                    }
                break;
                case '3':
                    $answers[$q->id] = Jelly::select('question_matching')->where('question_id','=',$q->id)->execute()->as_array();
                    
                    $is_correct[$q->id] = array(
                        'answer' => unserialize($correct->answer),
                        'status' => $correct->is_good
                    );
                    
                    if ($correct->is_good) {
                        $good_questions++;
                    }
                break;
                case '4':
                    $answers[$q->id] = Jelly::select('question_hotspot')->where('question_id','=',$q->id)->limit(1)->execute();
                
                    $is_correct[$q->id] = array(
                        'answer' => unserialize($correct->answer),
                        'status' => $correct->is_good
                    );
                    
                    if ($correct->is_good) {
                        $good_questions++;
                    }
                break;
                case '5':
                    $answers[$q->id] = Jelly::select('question_boolean')->where('question_id','=',$q->id)->limit(1)->execute();
                    
                    $is_correct[$q->id] = array(
                        'answer' => unserialize($correct->answer),
                        'status' => $correct->is_good
                    );
                    
                    if ($correct->is_good) {
                        $good_questions++;
                    }
                break;
                case '6':
                    $answers[$q->id] = null;
                    
                    $is_correct[$q->id] = array(
                        'answer' => unserialize($correct->answer),
                        'status' => $correct->is_good
                    );
                    
                    if ($correct->is_good) {
                        $good_questions++;
                    }
                break;
                case '7':
                    $answers[$q->id] = Jelly::select('question_list')->where('question_id','=',$q->id)->limit(1)->execute();
                
                    $is_correct[$q->id] = array(
                        'answer' => explode('```', unserialize($correct->answer)),
                        'status' => $correct->is_good
                    );
                    
                    if ($correct->is_good) {
                        $good_questions++;
                    }
                break;
            }
        }
        
        if ($good_questions < 1) {
            $percent = 0;
        }
        else {
            $percent = floor((($good_questions/$test->active_questions())*100));
        }
    }
    
    public function action_stats_scorm() {
        $this->template->content = View::factory('admin/students/waiting/scorm/tracks.tpl')
            ->bind('scorm', $scorm)
            ->bind('items', $items)
            ->set('user', $this->request->param('stuff'))
            ->set('material', $this->request->param('id'));
            
        $scorm = Jelly::select('scorm')->where('material_id', '=', $this->request->param('id'))->limit(1)->execute();
        
        $tracks = Jelly::select('scorm_scoe_track')
            ->where('scormid', '=', $scorm->id)
            ->where('userid', '=', $this->request->param('stuff'))
            ->group_by('userid')
            ->group_by('scormid')
            ->execute();

        $items = array();
        foreach($tracks as $track) {
            $userdata = scorm_get_user_data($track->userid);
            $attempt = scorm_get_last_attempt($scorm->id, $track->userid);
            
            for ($a = 1; $a<=$attempt; $a++) {
                $timetracks = scorm_get_sco_runtime($scorm->id, false, $track->userid, $a);
                
                $items[] = array(
                    'attempt' => $a,
                    'firstname' => $userdata->firstname,
                    'lastname' => $userdata->lastname,
                    'start' => $timetracks->start,
                    'finish' => $timetracks->finish,
                    'percent' => scorm_grade_user_attempt($scorm, $track->userid, $a)
                );
                
                if (!$timetracks->start) {
                    continue;
   	            }
            }                
        }
    }
    
    public function action_stats_scorm_toc() {
        $this->template->content = View::factory('admin/students/waiting/scorm/toc.tpl')
            ->bind('scorm', $scorm)
            ->bind('items', $items)
            ->set('user', $this->request->param('stuff'))
            ->set('material', $this->request->param('id'))
            ->set('attempt', $this->request->param('stuff2'));
            
        $scorm = Jelly::select('scorm')->where('material_id', '=', $this->request->param('id'))->limit(1)->execute();
        
        $scoes = Jelly::select('scorm_scoe')
            ->where('scorm', '=', $scorm->id)
            ->execute();
        
        $statuses = array(
            'notattempted' => __('Brak podejścia'), 
            'completed'    => __('Ukończone'), 
            'passed'       => __('Zaliczone'), 
            'failed'       => __('Nie zaliczone'), 
            'incomplete'   => __('Nie skończone')
        );

        $items = array();
        foreach ($scoes as $sco) {
            if ($sco->launch!='') {
                $score = '';
                if ($trackdata = scorm_get_tracks($sco->id, $this->request->param('stuff'), $this->request->param('stuff2'))) {
                    if ($trackdata->score_raw != '') {
                        $score = $trackdata->score_raw;
                    }
    				
                    if ($trackdata->status == '') {
                        $trackdata->status = 'notattempted';
   					}
                }
                else {
                    $trackdata->status = 'notattempted';
                    $trackdata->total_time = '&nbsp;';
                }
                
                $items[] = array(
                    'parent' => 0,
                    'id' => $sco->id,
                    'title' => $sco->title,
                    'status' => $trackdata->status,
                    'status_raw' => $statuses[$trackdata->status],
                    'score' => $score,
                    'time' => $trackdata->total_time
                );
            }
            else {
                $items[] = array(
                    'parent' => 1,
                    'title' => $sco->title                    
                );
            }
     	}
    }
    
    public function action_stats_scorm_debug() {
        $this->template->content = View::factory('admin/students/waiting/scorm/debug.tpl')
            ->bind('scorm', $scorm)
            ->bind('items', $items)
            ->bind('scorm_debug', $scorm_debug)
            ->set('user', $this->request->param('stuff'))
            ->set('material', $this->request->param('id'))
            ->set('attempt', $this->request->param('stuff2'));
            
        $scorm = Jelly::select('scorm')->where('material_id', '=', $this->request->param('id'))->limit(1)->execute();
        
        $sco = Jelly::select('scorm_scoe', $this->request->param('stuff3'));
        
        
        $statuses = array(
            'notattempted' => __('Brak podejścia'), 
            'completed'    => __('Ukończone'), 
            'passed'       => __('Zaliczone'), 
            'failed'       => __('Nie zaliczone'), 
            'incomplete'   => __('Nie skończone')
        );
        
        $langs = array(
            'raw' => 'Raw score',
            'max' => 'Max score', 
            'min' => 'Min score', 
            'status' => 'Status', 
            'time' => 'Czas'
        );
        
        $scorm_debug = '';
        $scoreview = '';
        if ($trackdata = scorm_get_tracks($sco->id, $this->request->param('stuff'), $this->request->param('stuff2'))) {
        	if ($trackdata->score_raw != '') {
        		$scoreview = 'Procent:&nbsp;'.$trackdata->score_raw;
            }
            if ($trackdata->status == '') {
                $trackdata->status = 'notattempted';
            }
        } else {
            $trackdata->status = 'notattempted';
            $trackdata->total_time = '';
        }
        
        $strstatus = $statuses[$trackdata->status];      
        
        $existelements = false;
		if ($scorm->version == 'SCORM_1.3') {
			$elements = array(
				'raw'    => 'cmi.score.raw',
                'min'    => 'cmi.score.min',
                'max'    => 'cmi.score.max',
                'status' => 'cmi.completion_status',
                'time'   => 'cmi.total_time'
            );
        }
        else {
        	$elements = array(
        		'raw'    => 'cmi.core.score.raw',
                'min'    => 'cmi.core.score.min',
                'max'    => 'cmi.core.score.max',
                'status' => 'cmi.core.lesson_status',
                'time'   => 'cmi.core.total_time'
            );
        }
        
        $table_element = '';
        $printedelements = array();
        foreach ($elements as $key => $element) {
        	if (isset($trackdata->$element)) {
        		$existelements = true;
                $printedelements[]=$element;
                
                $elem = (isset($statuses[$trackdata->$element])) ? $statuses[$trackdata->$element] : $trackdata->$element;
                
                $table_element .= '<tr>';
                $table_element .= '<td>'.$langs[$key].'</td>';
                $table_element .= '<td>'.$elem.'</td>';
                $table_element .= '</tr>';
            }
        }
        
        if ($existelements) {
            $scorm_debug .= '<div class="inner-page-title">'."\n";
            $scorm_debug .= '    <h3>Podstawowe</h3>'."\n";
            $scorm_debug .= '</div>'."\n";
            $scorm_debug .= '<div class="hastable">'."\n";
            $scorm_debug .= '  <table>'."\n"; 
            $scorm_debug .= '      <thead>'."\n";
            $scorm_debug .= '          <tr>'."\n";
            $scorm_debug .= '              <th>'."\n";
            $scorm_debug .= '                  Element'."\n";
            $scorm_debug .= '              </th>'."\n";
            $scorm_debug .= '              <th>'."\n";
            $scorm_debug .= '                  Wartość'."\n";
            $scorm_debug .= '              </th>'."\n";
            $scorm_debug .= '          </tr>'."\n"; 
            $scorm_debug .= '      </thead>'."\n";
            $scorm_debug .= '      <tbody>'."\n";
            $scorm_debug .= $table_element;
            $scorm_debug .= '      </tbody>'."\n";
            $scorm_debug .= '  </table>'."\n";
            $scorm_debug .= '</div>';
        }
        
        // Print Interactions data
        $existinteraction = false;

        $i = 0;
        $interactionid = 'cmi.interactions.'.$i.'.id';

        while (isset($trackdata->$interactionid)) {
            $existinteraction = true;
            $printedelements[]=$interactionid;
            $elements = array(
            	$interactionid,
                'cmi.interactions.'.$i.'.type',
                'cmi.interactions.'.$i.'.result',
                'cmi.interactions.'.$i.'.learner_response'
            );
                
            $row = array();
            foreach ($elements as $element) {
                if (isset($trackdata->$element)) {
                    $row[] = s($trackdata->$element);
                    $printedelements[]=$element;
                } else {
                    $row[] = '&nbsp;';
                }
            }
            
            //$table->data[] = $row;

            $i++;
            $interactionid = 'cmi.interactions.'.$i.'.id';
        }
        
        if ($existinteraction) {
            $scorm_debug .= '<br /><br />';
            $scorm_debug .= '<div class="inner-page-title">'."\n";
            $scorm_debug .= '    <h3>Interakcje</h3>'."\n";
            $scorm_debug .= '</div>'."\n";
            $scorm_debug .= '<div class="hastable">'."\n";
            $scorm_debug .= '  <table>'."\n"; 
            $scorm_debug .= '      <thead>'."\n";
            $scorm_debug .= '          <tr>'."\n";
            $scorm_debug .= '              <th>'."\n";
            $scorm_debug .= '                  Identyfikator'."\n";
            $scorm_debug .= '              </th>'."\n";
            $scorm_debug .= '              <th>'."\n";
            $scorm_debug .= '                  Typ'."\n";
            $scorm_debug .= '              </th>'."\n";
            $scorm_debug .= '              <th>'."\n";
            $scorm_debug .= '                  Wynik'."\n";
            $scorm_debug .= '              </th>'."\n";
            $scorm_debug .= '              <th>'."\n";
            $scorm_debug .= '                  Odpowiedź'."\n";
            $scorm_debug .= '              </th>'."\n";
            $scorm_debug .= '          </tr>'."\n"; 
            $scorm_debug .= '      </thead>'."\n";
            $scorm_debug .= '      <tbody>'."\n";
            $scorm_debug .= $table_element2;
            $scorm_debug .= '      </tbody>'."\n";
            $scorm_debug .= '  </table>'."\n";
            $scorm_debug .= '</div>';
        }

        // Print Objectives data
        $existobjective = false;

        $i = 0;
        $objectiveid = 'cmi.objectives.'.$i.'.id';

        while (isset($trackdata->$objectiveid)) {
            $existobjective = true;
            $printedelements[]=$objectiveid;
            $elements = array(
            	$objectiveid,
                'cmi.objectives.'.$i.'.status',
                'cmi.objectives.'.$i.'.score.raw',
                'cmi.objectives.'.$i.'.score.min',
                'cmi.objectives.'.$i.'.score.max'
            );
            
            $row = array();
            foreach ($elements as $element) {
                if (isset($trackdata->$element)) {
                    $row[] = s($trackdata->$element);
                    $printedelements[]=$element;
                } else {
                    $row[] = '&nbsp;';
                }
            }
            
            //$table->data[] = $row;
            
            $i++;
            $objectiveid = 'cmi.objectives.'.$i.'.id';
        }
        
        if ($existobjective) {
            $scorm_debug .= '<br /><br />';
            $scorm_debug .= '<div class="inner-page-title">'."\n";
            $scorm_debug .= '    <h3>Obiekty</h3>'."\n";
            $scorm_debug .= '</div>'."\n";
            $scorm_debug .= '<div class="hastable">'."\n";
            $scorm_debug .= '  <table>'."\n"; 
            $scorm_debug .= '      <thead>'."\n";
            $scorm_debug .= '          <tr>'."\n";
            $scorm_debug .= '              <th>'."\n";
            $scorm_debug .= '                  Identyfikator'."\n";
            $scorm_debug .= '              </th>'."\n";
            $scorm_debug .= '              <th>'."\n";
            $scorm_debug .= '                  Status'."\n";
            $scorm_debug .= '              </th>'."\n";
            $scorm_debug .= '              <th>'."\n";
            $scorm_debug .= '                  Raw'."\n";
            $scorm_debug .= '              </th>'."\n";
            $scorm_debug .= '              <th>'."\n";
            $scorm_debug .= '                  Min'."\n";
            $scorm_debug .= '              </th>'."\n";
            $scorm_debug .= '              <th>'."\n";
            $scorm_debug .= '                  Max'."\n";
            $scorm_debug .= '              </th>'."\n";
            $scorm_debug .= '          </tr>'."\n"; 
            $scorm_debug .= '      </thead>'."\n";
            $scorm_debug .= '      <tbody>'."\n";
            $scorm_debug .= $table_element3;
            $scorm_debug .= '      </tbody>'."\n";
            $scorm_debug .= '  </table>'."\n";
            $scorm_debug .= '</div>';
        }
        
        $existelements = false;
        
        $table_element4 = '';
        foreach($trackdata as $element => $value) {
            if (substr($element,0,3) == 'cmi') {
                if (!(in_array ($element, $printedelements))) {
                    $existelements = true;
                    
                    $table_element4 .= '<tr>';
                    $table_element4 .= '<td>'.$element.'</td>';
                    $table_element4 .= '<td>'.$value.'</td>';
                    $table_element4 .= '</tr>';
                }
            }
        }
        
        if ($existelements) {
            $scorm_debug .= '<br /><br />';
            $scorm_debug .= '<div class="inner-page-title">'."\n";
            $scorm_debug .= '    <h3>Inne</h3>'."\n";
            $scorm_debug .= '</div>'."\n";
            $scorm_debug .= '<div class="hastable">'."\n";
            $scorm_debug .= '  <table>'."\n"; 
            $scorm_debug .= '      <thead>'."\n";
            $scorm_debug .= '          <tr>'."\n";
            $scorm_debug .= '              <th>'."\n";
            $scorm_debug .= '                  Element'."\n";
            $scorm_debug .= '              </th>'."\n";
            $scorm_debug .= '              <th>'."\n";
            $scorm_debug .= '                  Wartość'."\n";
            $scorm_debug .= '              </th>'."\n";
            $scorm_debug .= '          </tr>'."\n"; 
            $scorm_debug .= '      </thead>'."\n";
            $scorm_debug .= '      <tbody>'."\n";
            $scorm_debug .= $table_element4;
            $scorm_debug .= '      </tbody>'."\n";
            $scorm_debug .= '  </table>'."\n";
            $scorm_debug .= '</div>';
        }
        
        $content = ob_get_contents(); ob_end_clean();
    }

    public function action_status() {
        parent::$_acl->check('students_waiting', 'edit');
        
        $allowed_status = array('0', '1', '2');
        if (in_array($this->request->param('stuff'), $allowed_status)) {
            $item = Jelly::select('course_user', $this->request->param('id'));
            if ($item->loaded()) {
                $item->active = $this->request->param('stuff');
                $item->updated_on = date('Y-m-d H:i:s', time());
                $item->save();
                
                $signed_on = new DateTime($item->signed_on);

                $replaceData = array();
                $replaceData['%firstname%'] = $item->user->firstname;
                $replaceData['%lastname%'] = $item->user->lastname;
                $replaceData['%course%'] = $item->course->name;
                $replaceData['%day%'] = $signed_on->format('d');
                $replaceData['%month%'] = $signed_on->format('m');
                $replaceData['%year%'] = $signed_on->format('Y');
                $replaceData['%hour%'] = $signed_on->format('H');
                $replaceData['%minute%'] = $signed_on->format('i');
                $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;

                if ($item->active == '1') {
                    xwContentTemplateWrapper::parameter_email(9, $replaceData, $item->user->email, CFG_WEBMASTER_EMAIL);
                }
                elseif ($item->active == '2') {
                    xwContentTemplateWrapper::parameter_email(8, $replaceData, $item->user->email, CFG_WEBMASTER_EMAIL);
                }     
                elseif ($item->active == '0') {
                    xwContentTemplateWrapper::parameter_email(10, $replaceData, $item->user->email, CFG_WEBMASTER_EMAIL);
                }                  
                
                
                Tracker::track(__('Zmiana statusu na szkoleniu dla studenta ID: ').$item->user->id);

                message::good(__('Status został zmieniony pomyślnie'), 'admin/students_waiting'.Url::query());
            }
            else {
                message::error('Wystąpił błąd podczas zmiany statusu', 'admin');
            }
        }
        else {
            message::error('Wystąpił błąd podczas zmiany statusu', 'admin');
        }
    }
    
    public function action_delete() {
        parent::$_acl->check('students_waiting', 'edit');

        $item = Jelly::select('course_user', $this->request->param('id'));

        if ($item->loaded()) {
            DB::delete('material_stats')->where('course_id','=',$item->course->id)->where('user_id','=',$item->user->id)->execute();
            DB::delete('material_test_stats')->where('course_id','=',$item->course->id)->where('user_id','=',$item->user->id)->execute();
            
            $item->delete();
            
            message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/students_waiting'.Url::query());
        }
        else {
            message::error(__('Wystąpił błąd podczas usuwania'), 'admin');
        }
    }
    
    public function action_checkbox() {
        if ($_POST) {
            switch (input::post('action')) {
                case 'publish':
                    parent::$_acl->check('students_waiting', 'edit');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('course_user', $value);
                            if ($item->loaded()) {
                                Tracker::track(__('Zmiana statusu na szkoleniu dla studenta ID: ').$item->user->id);
                                
                                $item->active = 1;
                                $item->updated_on = date('Y-m-d H:i:s', time());
                                $item->save();

                                $signed_on = new DateTime($item->signed_on);
                                
                                $replaceData = array();
                                $replaceData['%firstname%'] = $item->user->firstname;
                                $replaceData['%lastname%'] = $item->user->lastname;
                                $replaceData['%course%'] = $item->course->name;
                                $replaceData['%day%'] = $signed_on->format('d');
                                $replaceData['%month%'] = $signed_on->format('m');
                                $replaceData['%year%'] = $signed_on->format('Y');
                                $replaceData['%hour%'] = $signed_on->format('H');
                                $replaceData['%minute%'] = $signed_on->format('i');
                                $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;                                        
                                xwContentTemplateWrapper::parameter_email(9, $replaceData, $item->user->email, CFG_WEBMASTER_EMAIL);
                                
                            }
                        }
                    }
                break;
                case 'unpublish':
                    parent::$_acl->check('students_waiting', 'edit');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('course_user', $value);
                            if ($item->loaded()) {
                                Tracker::track(__('Zmiana statusu na szkoleniu dla studenta ID: ').$item->user->id);
                                
                                $item->active = 0;
                                $item->updated_on = date('Y-m-d H:i:s', time());
                                $item->save();
                                
                                $signed_on = new DateTime($item->signed_on);
                                
                                $replaceData = array();
                                $replaceData['%firstname%'] = $item->user->firstname;
                                $replaceData['%lastname%'] = $item->user->lastname;
                                $replaceData['%course%'] = $item->course->name;
                                $replaceData['%day%'] = $signed_on->format('d');
                                $replaceData['%month%'] = $signed_on->format('m');
                                $replaceData['%year%'] = $signed_on->format('Y');
                                $replaceData['%hour%'] = $signed_on->format('H');
                                $replaceData['%minute%'] = $signed_on->format('i');
                                $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
                                        
                                xwContentTemplateWrapper::parameter_email(10, $replaceData, $item->user->email, CFG_WEBMASTER_EMAIL);
                            }
                        }
                    }
                break;
                case 'prepublish':
                    parent::$_acl->check('students_waiting', 'edit');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('course_user', $value);
                            if ($item->loaded()) {
                                Tracker::track(__('Zmiana statusu na szkoleniu dla studenta ID: ').$item->user->id);
                                
                                $item->active = 2;
                                $item->updated_on = date('Y-m-d H:i:s', time());
                                $item->save();
 
                                $signed_on = new DateTime($item->signed_on);
                                
                                $replaceData = array();
                                $replaceData['%firstname%'] = $item->user->firstname;
                                $replaceData['%lastname%'] = $item->user->lastname;
                                $replaceData['%course%'] = $item->course->name;
                                $replaceData['%day%'] = $signed_on->format('d');
                                $replaceData['%month%'] = $signed_on->format('m');
                                $replaceData['%year%'] = $signed_on->format('Y');
                                $replaceData['%hour%'] = $signed_on->format('H');
                                $replaceData['%minute%'] = $signed_on->format('i');
                                $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
                                        
                                xwContentTemplateWrapper::parameter_email(8, $replaceData, $item->user->email, CFG_WEBMASTER_EMAIL);
                            }
                        }
                    }
                break;
            }

            message::good(__('Operacja przeprowadzona pomyślnie'), 'admin/students_waiting'.Url::query());
        }
    }
}
