<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Subjects extends Relio_Controller_Admin {
    public function action_index()
    {
        //parent::$_acl->check('subjects', 'list');
        
        $this->template->content = View::factory('admin/subjects/list.tpl')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();

        $builder = Jelly::select('subject');
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'name' => URL::query(array('sort' => 'name', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'name':
                $builder->order_by('name', $order_how);
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;         
            default:
            break;
        }
        
        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add()
    {
        //parent::$_acl->check('subjects', 'add');
        
        $this->template->content = View::factory('admin/subjects/add.tpl')
            ->bind('errors', $errors);
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');
            
            if ($post->check())
            {
                $item = Jelly::factory('subject');
                $item->name = Security::xss_clean(input::post('name'));
                $item->save();

                Tracker::track('Dodano przedmiot ID: '.$item->id);

                message::good('Dodanie przebiegło pomyślnie', 'admin/subjects');
            }
            else
            {
                $errors = $post->errors('backend/subjects/form');
            }
        }
    }

    public function action_edit()
    {
        //parent::$_acl->check('subjects', 'edit');
        
        $this->template->content = View::factory('admin/subjects/edit.tpl')
            ->bind('errors', $errors)
            ->bind('item', $item);
        
        $item = Jelly::select('subject', $this->request->param('id'));

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');
            
            if ($post->check())
            {
                $item->name = Security::xss_clean(input::post('name'));
                $item->save();

                Tracker::track('Edycja przedmiotu ID: '.$item->id);

                message::good('Edycja przebiegła pomyślnie', 'admin/subjects');
            }
            else
            {
                $errors = $post->errors('backend/subjects/form');
            }
        }
    }
    
    public function action_delete()
    {
        parent::$_acl->check('subjects', 'delete');
        
        $item = Jelly::select('subject', $this->request->param('id'));
        if ($item->loaded())
        {
            $item->delete();

            Tracker::track('Usunięto przedmiot ID: ' . $this->request->param('id'));

            message::good('Przedmiot został usunięty pomyślnie', 'admin/subjects');
        }
        else
        {
            message::error('Wystąpił błąd podczas usuwania przedmiotu', 'admin');
        }
    }
    
    public function action_checkbox()
    {
        if ($_POST)
        {
            $method_to_call = '_checkbox_'.input::post('action');
            if (method_exists($this, $method_to_call))
            {
                $this->$method_to_call();
            }
            
            message::good('Operacja przeprowadzona pomyślnie', 'admin/subjects'.URL::query());
        }
    }
    
    /**
     * Checkbox - Usuń
     */
    private function _checkbox_delete()
    {
        //parent::$_acl->check('subjects', 'delete');
        
        if (is_array(input::post('list')))
        {
            $ids = array();
            foreach(input::post('list') as $key => $value) {
                $ids[] = $value;
            }
            
            if (empty($ids))
            {
                $ids[] = 0;
            }
            
            $items = Jelly::select('subject')
                ->where('id', 'IN', $ids)
                ->execute();
        
            foreach($items as $it) {
                Tracker::track('Usunięto przedmiot ID: '.$it->id);
                
                $it->delete();
            }
        }
    }
}