<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Course extends Relio_Controller_Website {
    public function action_index()
    {
        if (!$this->auth->logged_in())
        {
            message::error(__('Musisz być zalogowany aby uczestniczyć w szkoleniu'), 'user/login', 'frontend');
        }
        
        View::set_global('in_page', 'course');
        
        $course = Jelly::select('course', $this->request->param('id'));
        
        $subscribe = Jelly::select('course_user')->filter(Session::instance()->get('auth_user')->id, $course->id)->limit(1)->execute();
		if (!$subscribe->loaded())
        {
		    message::error(__('Nie jesteś zapisany na to szkolenie'), 'mycourses', 'frontend'); 
		}
		
        //opcje szkolenia
        $course_options = unserialize($course->options);
        
        if (!$this->auth->logged_in('admin') && !$this->auth->logged_in('teacher') && !$this->auth->logged_in('moderator'))
        {
    		switch($subscribe->active) {
    			case '0':
    				message::error(__('Nie możesz uczestniczyć w tym szkoleniu gdyż Twoje zgłoszenie zostało odrzucone'), 'mycourses', 'frontend');
    			break;
    			case '2':
    				message::error(__('Nie możesz uczestniczyć w tym szkoleniu gdyż Twoje zgłoszenie nie zostało jeszcze rozpatrzone'), 'mycourses', 'frontend');
    			break;
    		}
            
            /**
             * Szkolenie nie jest jeszcze rozpoczete - zaloz blokade
             */
            if (strtotime($course->publish_on) > time())
            {
                message::error(__('Szkolenie nie zostało jeszcze rozpoczęte, nie możesz go oglądać'), 'mycourses', 'frontend');
            }
                
            /**
             * Szkolenie zakonczone - zaloz blokade
             */
            if (strtotime($course->archive_on) < time())
            {
                message::error(__('Szkolenie zostało zakończone, nie możesz go więcej oglądać'), 'mycourses', 'frontend');
            }
        }
        
        if (date('Y-m-d', strtotime($subscribe->login_on)) != date('Y-m-d'))
        {
            $subscribe->login_on = date('Y-m-d H:i:s', time());
        }
        
        if ($this->request->param('stuff'))
        {
            $material = Jelly::select('material')
                ->where('id', '=', $this->request->param('stuff'))
                ->limit(1)
                ->cached(3600)
                ->execute();
                
            if ($material->loaded())
            {
                switch ($material->type) {
                    case 'lesson':
                        $this->content = Request::factory('module/'.$material->type .'/'.$course->id.'/'.$material->id.'/'.Request::instance()->param('stuff2').'/'.Request::instance()->param('stuff3').'/'.Request::instance()->param('stuff4'))->execute()->response;
                    break;
                    case 'test':
                        $this->content = Request::factory('module/'.$material->type .'/'.$course->id.'/'.$material->id.'/'.Request::instance()->param('stuff2').'/'.Request::instance()->param('stuff3').'/'.Request::instance()->param('stuff4'))->execute()->response;
                    break;
                    case 'exercise':
                        $this->content = Request::factory('module/'.$material->type .'/'.$course->id.'/'.$material->id.'/'.Request::instance()->param('stuff2').'/'.Request::instance()->param('stuff3').'/'.Request::instance()->param('stuff4'))->execute()->response;
                    break;
                    case 'scorm':
                        $this->content = Request::factory('module/'.$material->type.'/'.$course->id.'/'.$material->id.'/'.Request::instance()->param('stuff2').'/'.Request::instance()->param('stuff3').'/'.Request::instance()->param('stuff4'))->execute()->response;
                    break;
                    case 'videosync':
                        $this->content = Request::factory('module/'.$material->type.'/'.$course->id.'/'.$material->id.'/'.Request::instance()->param('stuff2').'/'.Request::instance()->param('stuff3').'/'.Request::instance()->param('stuff4'))->execute()->response;
                    break;
                }
            }
        }
        else
        {
            list($new_pager, $pager_prev_page, $pager_next_page, $current_page) = Lms::get_course_pager($course, $subscribe);
            
            $znew_pager = unserialize(Session::instance()->get('znewPager'));            
            
            $first_lesson = $znew_pager[1];
            $this->request->redirect($first_lesson['link'].'?page=1&lesson=1');         
        }
        
        /**
         * Czas spedzony na szkoleniu
         */
        if ($subscribe->percent < 100)
        { 
            $timer = Jelly::select('course_user')->where('user_id','=',Session::instance()->get('auth_user')->id)->where('course_id','=',$course->id)->limit(1)->execute();
            if ($timer->loaded())
            {
                if ($timer->last_on <> '0000-00-00 00:00:00' && !is_null($timer->last_on))
                {
                    $dataold = mktime((int)substr($timer->last_on, 11, 2),  (int)substr($timer->last_on, 14, 2), (int)substr($timer->last_on, 17, 2), (int)substr($timer->last_on, 5, 2), (int)substr($timer->last_on, 8, 2),  substr($timer->last_on, 0, 4));
                    $datanew = time();
                    $dodaj = $datanew - $dataold;
                    $new_time = $timer->time_on + $dodaj;
                    
                    $timer->time_on = $new_time;
                    $timer->last_on = date('Y-m-d H:i:s', time());
                    $timer->save();
                }
                else
                {
                    $timer->time_on = 0;
                    $timer->last_on = date('Y-m-d H:i:s', time());
                    $timer->save();
                }
            }
        }
    }
    
    public function action_continue()
    {
        if (!$this->auth->logged_in())
        {
            message::error(__('Musisz być zalogowany aby uczestniczyć w szkoleniu'), 'user/login', 'frontend');
        }
        
        $course = Jelly::select('course', $this->request->param('id'));
        
        $subscribe = Jelly::select('course_user')
            ->filter(Auth::instance()->get_user()->id, $course->id)
            ->limit(1)
            ->execute();
        
        list($new_pager, $pager_prev_page, $pager_next_page, $current_page) = Lms::get_course_pager($course, $subscribe);
        
        $last_material = Jelly::select('material_stat')
            ->where('user_id', '=', Auth::instance()->get_user()->id)
            ->where('course_id', '=', $this->request->param('id'))
            ->order_by('id', 'DESC')
            ->limit(1)
            ->execute();

        $znew_pager = unserialize(Session::instance()->get('znewPager'));
        $first_lesson = $znew_pager[1];

        foreach($znew_pager as $zp) {
            if ($last_material->material->id == $zp['id'])
            {
                $this->request->redirect('course/index/'.$course->id.'/'.$last_material->material->id.'?page='.$zp['pager'].'&lesson='.$zp['pager']);
                break;
            }
        }

        $this->request->redirect($first_lesson['link'].'?page=1&lesson=1');
    }
    
    public function action_finish()
    {
        $this->template->content = View::factory('site/modules/course/finish.tpl')
            ->bind('errors', $errors)
            ->bind('course', $course)
            ->bind('item', $item);
        
        $item = Jelly::select('user', Auth::instance()->get_user()->id);
        
        $course = Jelly::select('course', $this->request->param('id'));
        
        $subscribe = Jelly::select('course_user')
            ->where('user_id', '=', Auth::instance()->get_user()->id)
            ->where('course_id', '=', $course->id)
            ->limit(1)
            ->execute();
            
        if (!$subscribe->loaded())
        {
		    message::error('Nie jesteś zapisany na to szkolenie', 'mycourses', 'frontend');
            exit;
		}
        
        if ($subscribe->percent < 100)
        {
		    message::error('Najpierw musisz ukończyć szkolenie', 'mycourses', 'frontend');
		}
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('is_good', 'not_empty');
                        
            if ($post->check())
            {
                if (input::post('is_good') == '1')
                {
                    $subscribe->verified_end = 1;
                    $subscribe->verified_send = date('Y-m-d H:i:s', time());
                    $subscribe->save();
                    
                    message::good('Twoje dane zostały zapisane pomyślnie', 'mycourses', 'frontend');
                }
                else if (input::post('is_good') == '0')
                {
                    $subscribe->verified_end = 0;
                    $subscribe->verified_send = date('Y-m-d H:i:s', time());
                    $subscribe->save();
                    
                    $replaceData = array();
                    $replaceData['%course%'] = $subscribe->course->name;
                    $replaceData['%signed_day%'] = date('d', strtotime($subscribe->signed_on));
                    $replaceData['%signed_month%'] = date('m', strtotime($subscribe->signed_on));
                    $replaceData['%signed_year%'] = date('Y', strtotime($subscribe->signed_on));
                    $replaceData['%publish_on%'] = $subscribe->course->publish_on;
                    $replaceData['%firstname%'] = $item->firstname;
                    $replaceData['%lastname%'] = $item->full_lastname();
                    $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
                    $replaceData['%email%'] = $item->emai;
                    $replaceData['%day%'] = date('d');
                    $replaceData['%month%'] = date('m');
                    $replaceData['%year%'] = date('Y');
                    $replaceData['%broker_name%'] = $item->broker_name;
                    
                        
                    xwContentTemplateWrapper::parameter_email(20, $replaceData, $item->get_guardian_email(), CFG_WEBMASTER_EMAIL);
                    xwContentTemplateWrapper::parameter_email(20, $replaceData, CFG_CONTACT_EMAIL, CFG_WEBMASTER_EMAIL);
                                
                    message::notice('Twoje zgłoszenie o błędzie zostało wysłane do administratora oraz opiekuna szkolenia. Pamiętaj jednak aby skontaktować się z Opiekunem w celu poprawy danych', 'mycourses', 'frontend');
                }
            }
            else
            {
                $errors = $post->errors('frontend/users/firsttime/form');
            }
        }
    }
    
    public function action_comment()
    {
        if ($_POST)
        {
            $item = Jelly::factory('comment');
            $item->set(array(
                'parent_id' => ((input::post('parent_id')) ? Security::xss_clean(input::post('parent_id')) : 0),
                'obj_id'    => Security::xss_clean(input::post('obj_id')),
                'obj_type'  => Security::xss_clean(input::post('obj_type')),
                'content'   => Security::xss_clean(input::post('content')),
                'user'      => Auth::instance()->get_user()->id
            ));
            $item->save();
                
            $user = Jelly::select('user', Session::instance()->get('auth_user')->id);
            $user->add('comment', $item);
            $user->save();
        }
        
        $course = Jelly::select('course', Security::xss_clean(input::post('obj_id')));
        
        //pobierz komentarze
        $comments = Lms::get_course_comments($course->id);
            
        echo View::factory('site/modules/course/comments.tpl')
            ->bind('course', $course)
            ->bind('comments', $comments[0]);
        exit;
    }
    
    public function action_material_help()
    {
        $material = Jelly::select('material')->where('id', '=', $this->request->param('id'))->limit(1)->cached(3600)->execute();
        if ($material->loaded())
        {
            switch ($material->type) {
                case 'lesson':
                    $item = Jelly::select('material_lesson')->by_material($material->id)->limit(1)->cached(3600)->execute();
                break;
                case 'scorm':
                    $item = Jelly::select('material_scorm')->by_material($material->id)->limit(1)->cached(3600)->execute();
                break;
                case 'videosync':
                    $item = Jelly::select('material_videosync')->by_material($material->id)->limit(1)->cached(3600)->execute();
                break;
            }
        }
        
        echo View::factory('site/modules/course/help.tpl')
            ->bind('item', $item)
            ->render();
        exit;
    }
    
    public function action_question_help()
    {
        $item = Jelly::select('question', $this->request->param('id'));

        echo View::factory('site/modules/course/help.tpl')
            ->bind('item', $item)
            ->render();
        exit;
    }
    
    public function action_attachments()
    {
        $attachments = Jelly::select('attachment')->order_by('posy','ASC')->filter(Request::instance()->param('id'), 'materials', 1)->cached(3600)->execute();
                
        echo View::factory('smarty:site/ajax/attachments')
            ->bind('attachments', $attachments)->render();
    }
    
    public function action_question_attachments()
    {
        $attachments = Jelly::select('attachment')->order_by('posy','ASC')->filter(Request::instance()->param('id'), 'questions', 1)->cached(3600)->execute();

        echo View::factory('smarty:site/ajax/question_attachments')
            ->bind('attachments', $attachments)->render();
    }
    
    public function action_program()
    {
        $course = Jelly::select('course', $this->request->param('id'));
        $subscribe = Jelly::select('course_user')->filter(Auth::instance()->get_user()->id, $course->id)->limit(1)->execute();
		
        $chapter_stats = array();
        
        $items = Jelly::select('category')->filter($subscribe->course->category->id, 0)->execute();
        foreach($items as $it) {
            //policz zaliczone materialy dla tej kategorii\
            $materials = ',0';
            foreach($it->material as $itm) {
                $materials .= ','.$itm->id;
            }
            $materials = substr($materials, 1);
                
            $count_passed = Jelly::select('material_stat')->where('material_id','IN', array(DB::expr($materials)))->where('status','=','1')->where('user_id','=',$subscribe->user->id)->where('course_id','=',$subscribe->course->id)->count();
            
            if ($count_passed > 0)
            {
                $percent = ceil(($count_passed*100) / $it->material->count());
            }
            else
            {
                $percent = 0;
            }
            
            $chapter_stats[$it->id] = array(
                'percent' => $percent,
                'passed' => $count_passed,
                'tm' => $it->material->count(),
                'materials' => $materials
            );
            
            //unset($materials);
        }
        
        $items_stats = array();
        
        $stats = Jelly::select('material_stat')->where('user_id','=',$subscribe->user->id)->where('course_id','=',$subscribe->course->id)->execute();
        foreach($stats as $s) {
            if ($s->status == '1')
            {
                $items_stats[$s->material->id] = array(
                    'status' => __('Zaliczone'),
                    'color'  => 'green'
                );
            }
                
            if ($s->status == '0')
            {
                $items_stats[$s->material->id] = array(
                    'status' => __('Niezaliczone'),
                    'color'  => 'red'
                );
            }
        }
        
        echo View::factory('smarty:site/modules/course/program')
            ->bind('course', $course)
            ->bind('subscribe', $subscribe)
            ->bind('items', $items)
            ->bind('items_stats', $items_stats)
            ->bind('chapter_stats', $chapter_stats)->render();
        exit;
    }
    
    public function action_certificate()
    {
        if (!$this->auth->logged_in())
        {
            message::error(__('Musisz być zalogowany aby pobrać certyfikat'), 'user/login', 'frontend');
        }
        
        if ($this->request->param('id'))
        {
            $item = Jelly::select('certificate_history', $this->request->param('id'));
            if ($item->loaded())
            {
                if ($item->active == 0)
                {
                    message::error(__('Możliwość pobierania certyfikatu została zablokowana'), 'mycourses', 'frontend');
                }
                else
                {
                    if ($item->user->id == Auth::instance()->get_user()->id)
                    {
                        //+1 do ilosci pobran
                        $item->downloads = ($item->downloads+1);
                        $item->save();
                        
                        Certificate::download($item);
                    }
                    else
                    {
                        $this->request->redirect('/');
                    }
                }
            }
            else
            {
                message::error(__('Nie znaleziono certyfikatu'), 'mycourses', 'frontend');
            }
        }
        else
        {
            message::error(__('Nie znaleziono certyfikatu'), 'mycourses', 'frontend');
        }
    }
}
