<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Courses extends Relio_Controller_Website {
    public function before()
    {
        parent::before();
        
        
        View::set_global('in_page', 'courses');
    }
    
    public function action_index()
    {
        
        if ( ! Auth::instance()->logged_in())
        {
            message::error(__('Aby uzyskać dostęp do szkoleń musisz się zalogować'), 'user/login', 'frontend');
        }
        

        if (input::get('list'))
        {
            Session::instance()->set('product_list_type', input::get('list'));
        }
        else
        {
            Session::instance()->set('product_list_type', 'matrix');
        }

        $this->template->content =  View::factory('smarty:site/courses/list')
            ->bind('breadcrumbs', $breadcrumbs)
            ->bind('message', $message)
            ->bind('groups', $groups)
            ->bind('categories', $categories)
            ->bind('course_info', $course_info)
            ->bind('tree', $tree)
            ->bind('items', $items_array)
            ->bind('pagination', $pagination)
            ->set('listing', Session::instance()->get('product_list_type', 'matrix'));
        
        $message = message::get_once('frontend');

        $groups = Jelly::select('course_group')
            ->filter(1)
            ->execute();        
        
        $categories = Jelly::factory('course_category')->root(1)->descendants(false, 'ASC');

        $children_categories = Jelly::select('course_category', input::get('category'))->children(true);
        
        $in_categories = array();
        foreach($children_categories as $cat) {
            $in_categories[] = $cat->id;
        }

        $items_array = array();

        $builder = Jelly::select('course')
            ->is_active(1);

        if (input::get('group'))
        {
            $builder->join('course_group_courses', 'LEFT')
                ->on('course_group_courses.course_id', '=', DB::expr('courses.id'))
                ->in_group(array(input::get('group')));
        }

        if (input::get('category'))
        {
            $builder->join('course_category_courses', 'LEFT')
                ->on('course_category_courses.course_id', '=', DB::expr('courses.id'))
                ->in_category($in_categories);
        }
            
        $builder->distinct(true);

        $limit = 12;
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
            
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();

        foreach($items as $it) {
            $items_array[] = array(
                'id'            => $it->id,
                'name'          => $it->name,
                'content_short' => $it->content_short,
                'icon'          => $it->icon,
                'hours'         => $it->hours,
                'total_users'   => $it->users->count(),
                'publish_on'    => $it->publish_on,
                'archive_on'    => $it->archive_on,
                'type'          => $it->type
            );
        }

        $breadcrumbs = Breadcrumbs::getInstance()
            ->addItem(__('Strona główna'), URL::site('/'))
            ->addItem(__('Lista szkoleń'), URL::site('courses'))
            ->render();
    }
    
    public function action_detail() 
    {
        if ( ! Auth::instance()->logged_in())
        {
            message::error(__('Aby uzyskać dostęp do szkoleń musisz się zalogować'), 'user/login', 'frontend');
        }        
        
        $this->template->content = View::factory('site/courses/detail.tpl')
            ->bind('breadcrumbs', $breadcrumbs)
            ->bind('errors', $errors)
            ->bind('message', $message)
            ->bind('item', $item)
            ->bind('items', $items_array)
            ->bind('attachments', $attachments)
            ->bind('moderators', $moderators)
            ->bind('is_subscribed', $is_subscribed)
            ->bind('course_status', $course_status);
            
        $message = message::get_once('frontend');
        
        $item = Jelly::select('course', $this->request->param('id'));
        if ($item->loaded())
        {
            $attachments_query = Jelly::select('attachment')
                ->order_by('posy','ASC')
                ->filter($item->id, 'courses', 1)
                ->execute();
            
            $attachments = array();
            foreach($attachments_query as $aq) {
                $attachments[] = array(
                    'id'      => $aq->id,
                    'name'    => $aq->name,
                    'preview' => $aq->file_extension_icon()
                );
            }
            
            $moderators = Jelly::select('course_moderator')
                ->where('course_id','=',$item->id)
                ->execute();

            $items = Jelly::select('course')
                ->filter(1)
                ->limit(8)
                ->order_by(DB::expr('RAND()'), null)
                ->execute();

            $items_array = array();
            foreach($items as $it) {
                $items_array[] = array(
                    'id'            => $it->id,
                    'name'          => $it->name,
                    'content_short' => $it->content_short,
                    'icon'          => $it->icon,
                    'hours'         => $it->hours,
                    'total_users'   => $it->users->count(),
                    'publish_on'    => $it->publish_on,
                    'archive_on'    => $it->archive_on,
                    'type'          => $it->type
                );
            }

            if (Auth::instance()->logged_in())
            {
                $is_subscribed = Auth::instance()->get_user()->is_subscribed($item->id);
                $course_status = Auth::instance()->get_user()->course_status($item->id);
            }
            else
            {
                $is_subscribed = false;
                $course_status = 0;
            }

            $this->title = $item->name;

            $breadcrumbs = Breadcrumbs::getInstance()
                ->addItem(__('Strona główna'), URL::site('/'))
                ->addItem(__('Lista szkoleń'), URL::site('courses'))
                ->addItem($item->name, URL::site('courses/detail/'.$item->id), true)
                ->render();  
        }
        else
        {
            $this->request->redirect('/');
        }
    }
    
    public function action_subscribe()
    {
        if ( ! Auth::instance()->logged_in())
        {
            message::error(__('Musisz być zalogowany aby zapisać się na szkolenie'), 'user/login', 'frontend');
        }
        
        $item = Jelly::select('course', $this->request->param('id'));
        if ($item->loaded())
        {
            $options = unserialize($item->options);
            
            $user = Jelly::select('user', Auth::instance()->get_user()->id);
            
            if ($user->is_subscribed($item->id))
            {
                message::error(__('Twoje zgłoszenie oczekuje na akceptację administratora'), 'courses', 'frontend');
            }
            else
            {
                if ($item->dependence)
                {
                    $depends = explode(',', $item->dependence);
                    
                    $subscribed_courses = Jelly::select('course_user')
                        ->where('user_id', '=', Auth::instance()->get_user()->id)
                        ->where('percent', '=', '100')
                        ->execute();
                    
                    $passed_courses = array();
                    foreach($subscribed_courses as $sc) {
                        $passed_courses[] = $sc->id;
                    }
                    
                    $diff = array_diff($depends, $passed_courses);
                    if (count($diff) > 0)
                    {
                        $to_pass = '';
                        foreach($depends as $d) {
                            $course = Jelly::select('course', $d);
                            
                            $to_pass .= '- '.$course->name.'<br>';
                        }
                        
                        message::error('Aby uzyskać dostęp do tego szkolenia musisz zaliczyć:<br/>'.$to_pass, 'courses/detail/'.$item->id, 'frontend');
                    }
                }
                
                //sprawdz czy mam dobra grupe ...
                if (Lms::subscribe_compare_groups($item, Auth::instance()->get_user()->id))
                {
                    $subscribe = Jelly::factory('course_user');
                    $subscribe->user = $user->id;
                    $subscribe->course = $item->id;
                    $subscribe->active = ($item->accept) ? 1 : 2;
                    $subscribe->save();

                    if ($item->accept == '1')
                    {
                        $item->updateSubscribers();

                        $replaceData = array();
                        $replaceData['%firstname%'] = $user->firstname;
                        $replaceData['%lastname%'] = $user->lastname;
                        $replaceData['%course%'] = $item->name;
                        $replaceData['%day%'] = date('d', time());
                        $replaceData['%month%'] = date('m', time());
                        $replaceData['%year%'] = date('Y', time());
                        $replaceData['%hour%'] = date('H', time());
                        $replaceData['%minute%'] = date('i', time());
                        $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
                        xwContentTemplateWrapper::parameter_email(9, $replaceData, $user->email, CFG_WEBMASTER_EMAIL);
                            
                        $this->request->redirect('course/index/'.$item->id);
                    }
                    else
                    {
                        $item->updateSubscribers();

                        $replaceData = array();
                        $replaceData['%firstname%'] = $user->firstname;
                        $replaceData['%lastname%'] = $user->lastname;
                        $replaceData['%course%'] = $item->name;
                        $replaceData['%day%'] = date('d', time());
                        $replaceData['%month%'] = date('m', time());
                        $replaceData['%year%'] = date('Y', time());
                        $replaceData['%hour%'] = date('H', time());
                        $replaceData['%minute%'] = date('i', time());
                        $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
                        xwContentTemplateWrapper::parameter_email(8, $replaceData, $user->email, CFG_WEBMASTER_EMAIL);
                            
                        message::good(__('Twoje zgłoszenie na szkolenie zostało przyjęte i zostanie rozpatrzone w ciągu 24 godzin'), 'courses', 'frontend');
                    }
                }
                else
                {
                     message::error(__('To szkolenie nie jest dla ciebie dostępne'), 'courses', 'frontend');
                }
            }
        }
        else
        {
            message::error(__('Takie szkolenie nie istnieje'), 'courses', 'frontend');
        }
    }
    
    public function action_program()
    {
        $course = Jelly::select('course', $this->request->param('id'));
        $items = Jelly::select('category')->filter($course->category->id, 0)->execute();

        echo View::factory('site/courses/program.tpl')
            ->bind('course', $course)
            ->bind('items', $items)
            ->render();
        exit;
    }
}