<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Error_Handler extends Relio_Controller_Error {
    public function before() {
        parent::before();
        
        $this->template->page = URL::site(rawurldecode(Request::$instance->uri));
        
        // Internal request only!
        if (Request::$instance !== Request::$current) {
            if ($message = rawurldecode($this->request->param('message'))) {
                $this->template->message = $message;
            }
        }
        else {
            $this->request->action = 404;
        }
        
        $this->request->status = (int)$this->request->action;
    }
    
    public function action_404() {
        $this->template->title = '404 Not Found';
        $this->template->type = '404';
        
        // Here we check to see if a 404 came from our website. This allows the
        // webmaster to find broken links and update them in a shorter amount of time.
        if (isset ($_SERVER['HTTP_REFERER']) AND strstr($_SERVER['HTTP_REFERER'], $_SERVER['SERVER_NAME']) !== FALSE)
        {
            // Set a local flag so we can display different messages in our template.
            $this->template->local = TRUE;
        }
     
        // HTTP Status code.
        $this->request->status = 404;
     }
     
     public function action_503() {
        $this->template->title = 'Maintenance Mode';
        $this->template->type = '503';
     }
     
     public function action_500() {
        $this->template->title = 'Internal Server Error';
        $this->template->type = '500';
     }        
}