<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Index extends Relio_Controller_Website {    
    public function action_index()
    {
        if (input::get('list'))
        {
            Session::instance()->set('product_list_type', input::get('list'));
        }
        else
        {
            Session::instance()->set('product_list_type', 'matrix');
        }           

        $this->template->content = View::factory('site/home.tpl')
            ->bind('message', $message)
            ->bind('groups', $groups)
            ->bind('categories', $categories)
            ->bind('items', $items_array)
            ->bind('pagination', $pagination)
            ->set('listing', Session::instance()->get('product_list_type', 'matrix'));

        $message = message::get_once('frontend');

        $groups = Jelly::select('course_group')
            ->filter(1)
            ->execute();

        $categories = Jelly::factory('course_category')->root(1)->descendants(false, 'ASC');

        $children_categories = Jelly::select('course_category', input::get('category'))->children(true);
        
        $in_categories = array();
        foreach($children_categories as $cat) {
            $in_categories[] = $cat->id;
        }

        $items_array = array();

        $builder = Jelly::select('course')
            ->is_active(1)
            ->where('promoted', '=', '1');

        if (input::get('group'))
        {  
            $builder->join('course_group_courses', 'LEFT')
                ->on('course_group_courses.course_id', '=', DB::expr('courses.id'))
                ->in_group(array(input::get('group')));
        }

        if (input::get('category'))
        {
            $builder->join('course_category_courses', 'LEFT')
                ->on('course_category_courses.course_id', '=', DB::expr('courses.id'))
                ->in_category($in_categories);
        }
        
        $builder->distinct(true);

        $limit = 12;
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
            
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();

        foreach($items as $it) {
            $items_array[] = array(
                'id'            => $it->id,
                'name'          => $it->name,
                'content_short' => $it->content_short,
                'icon'          => $it->icon,
                'hours'         => $it->hours,
                'price'         => $it->price,
                'total_users'   => $it->users->count(),
                'publish_on'    => $it->publish_on,
                'archive_on'    => $it->archive_on,
                'type'          => $it->type
            );
        }
    }
    
    public function action_style()
    {
        if (in_array($this->request->param('id'), array('gfx', 'wcag')))
        {
            Session::instance()->set('css_style', $this->request->param('id'));
            
            $this->request->redirect('/');
        }
        else
        {
            $this->request->redirect('/');
        }
    }
}
