<?php defined('SYSPATH') or die('No direct script access.');

require_once Kohana::find_file('vendor', 'excel');

class Controller_Locale extends Controller {
    public function action_index() {
        if ($this->request->param('id'))
        {
            $lang = $this->request->param('id');
        }
        else
        {
            $lang = I18n::$lang;
        }
        
        header('Content-type: application/x-javascript');
        echo 'var xjsI18n = '.json_encode(I18n::load($lang)).';';
        exit;
	}
    
    public function action_export_empty()
    {
        $items = I18n::load('en-us');
        
        ob_clean();
        ob_start();
        
        set_time_limit(0);
        $workbook = new Spreadsheet_Excel_Writer();
        $workbook->setVersion(8);
        
        $worksheet =& $workbook->addWorksheet('Locale');
        $worksheet->setInputEncoding('UTF-8');
        
        $format = $workbook->addFormat(array('Bold' => 1));
        
        $worksheet->write(0, 0, "PL", $format);
        $worksheet->write(0, 1, "EN", $format);
        
        $worksheet->setColumn(0, 6, 20);
        
        $i = 1;
        foreach($items as $key => $val) {
            if (empty($val))            
            {
                $worksheet->write($i, 0, $key);
                $worksheet->write($i, 1, '');
                
                $i++;
            }
        }
        
        $workbook->close();
        $workbook->send('locale.xls');
        ob_end_flush();
    }
}