<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Mycourses extends Relio_Controller_Website {
    public function action_index()
    {
        if (!$this->auth->logged_in())
        {
            message::error(__('Musisz być zalogowany aby uzyskać dostęp do tego miejsca'), 'user/login', 'frontend');
        }
        
        View::set_global('in_page', 'mycourses');
        
        $this->template->content =  View::factory('smarty:site/mycourses/list')
            ->bind('breadcrumbs', $breadcrumbs)
            ->bind('message', $message)
            ->bind('items', $items_active)
            ->bind('items_finished', $items_finished)
            ->bind('items_wait', $item_wait);
        
        $message = message::get_once('frontend');
        
        $items_active = Jelly::select('course_user')
            ->with('course')
            ->where('user_id', '=', Auth::instance()->get_user()->id)
            ->where('active', '=', 1)
            ->where_open()
            ->where('percent', '<', '100')
            ->where_close()
            ->where('_course:course.archive_on', '>=', date('Y-m-d'))
            ->execute();
        
        $items_finished = Jelly::select('course_user')
            ->with('course')
            ->where('user_id', '=', Auth::instance()->get_user()->id)
            ->where('active', '=', 1)
            ->where_open()
            ->where('percent', '=', '100')
            ->where_close()
            ->execute();
        
        $item_wait = Jelly::select('course_user')
            ->with('course')
            ->where('user_id', '=', Auth::instance()->get_user()->id)
            ->where('active', '=', 2)
            ->execute();
        
        $breadcrumbs = Breadcrumbs::getInstance()
            ->addItem(__('Strona główna'), URL::site('/'))
            ->addItem(__('Twoje szkolenia'), URL::site('mycourses'), true)
            ->render();
    }
	
	public function action_stats()
    {
        if (!$this->auth->logged_in())
        {
            message::error(__('Musisz być zalogowany aby uzyskać dostęp do tego miejsca'), 'user/login', 'frontend');
        }
        
        $item = Jelly::select('course_user', $this->request->param('id'));
        if ($item->loaded())
        {
            $this->template->content = View::factory('smarty:site/mycourses/stats')
                ->bind('item', $item)
                ->bind('items', $items)
                ->bind('items_stats', $items_stats)
                ->bind('chapter_stats', $chapter_stats);
            
            $chapter_stats = array();
            
            
            $items = Jelly::select('category')->filter($item->course->category->id, 0)->execute();
            foreach($items as $it) {
                //policz zaliczone materialy dla tej kategorii\
                $materials = ',0';
                foreach($it->material as $itm) {
                    $materials .= ','.$itm->id;
                }
                $materials = substr($materials, 1);
                
                $count_passed = Jelly::select('material_stat')->where('material_id','IN', array(DB::expr($materials)))->where('status','=','2')->where('user_id','=',$item->user->id)->where('course_id','=',$item->course->id)->count();
                
                $chapter_stats[$it->id] = array(
                    'percent' => ceil(($count_passed*100) / $it->material->count()),
                    'passed' => $count_passed,
                    'tm' => $it->material->count(),
                    'materials' => $materials
                );
                
                //unset($materials);
            }
           
            $items_stats = array();
            
            $stats = Jelly::select('material_stat')->where('user_id','=',$item->user->id)->where('course_id','=',$item->course->id)->execute();
            foreach($stats as $s) {
                if ($s->status == '2')
                {
                    $items_stats[$s->material_id] = array(
                        'status' => __('Zaliczone'),
                        'color'  => 'green'
                    );
                }
                
                if ($s->status == '1')
                {
                    $items_stats[$s->material_id] = array(
                        'status' => __('Niezaliczone'),
                        'color'  => 'red'
                    );
                }
            }
        }
        else
        {
            $this->request->redirect('/');
        }
    }
    
    public function action_stats_test()
    {
        if (!$this->auth->logged_in())
        {
            message::error(__('Musisz być zalogowany aby uzyskać dostęp do tego miejsca'), 'user/login', 'frontend');
        }
        
        $item = Jelly::select('material_stat')
            ->where('material_id', '=', $this->request->param('id'))
            ->where('user_id', '=', Auth::instance()->get_user()->id)
            ->limit(1)
            ->execute();
        
        if ($item->loaded())
        {
            $this->template->content = View::factory('smarty:site/mycourses/stats_test')
                ->bind('questions', $questions)
                ->bind('answers', $answers)
                ->bind('is_correct', $is_correct)
                ->bind('item', $item)
                ->bind('trials', $trials)
                ->bind('test', $test)
                ->bind('percent', $percent);
            
            $test = Jelly::select('material_test')
                ->by_material($this->request->param('id'))
                ->limit(1)
                ->execute();
            
            $questions = Jelly::select('question')
                ->filter($test->id)
                ->execute();
            
            $trials = Jelly::select('material_stat')
                ->where('test_id', '=', $test->id)
                ->where('material_id', '=', $this->request->param('id'))
                ->where('user_id', '=', Auth::instance()->get_user()->id)
                ->limit(1)
                ->execute();
            
            $is_correct = array();
            $answers = array();
            
            $good_questions = 0;
            
            foreach($questions as $q) {
                $correct = Jelly::select('material_test_stat')
                    ->where('question_id', '=', $q->id)
                    ->where('user_id', '=', Auth::instance()->get_user()->id)
                    ->limit(1)
                    ->execute();
                
                switch ($q->type) {
                    case '1':
                        $answers[$q->id] = Jelly::select('question_choice')
                            ->where('question_id', '=', $q->id)
                            ->limit(1)
                            ->execute();
                    
                        $is_correct[$q->id] = array(
                            'answer' => unserialize($correct->answer),
                            'status' => $correct->is_good
                        );
                        
                        if ($correct->is_good)
                        {
                            $good_questions++;
                        }
                    break;
                    case '2':
                        $answers[$q->id] = Jelly::select('question_choice')
                            ->where('question_id', '=', $q->id)
                            ->limit(1)
                            ->execute();
                    
                        $is_correct[$q->id] = array(
                            'answer' => unserialize($correct->answer),
                            'status' => $correct->is_good
                        );
                        
                        if ($correct->is_good)
                        {
                            $good_questions++;
                        }
                    break;
                    case '3':
                        $answers[$q->id] = Jelly::select('question_matching')
                            ->where('question_id', '=', $q->id)
                            ->execute()
                            ->as_array();
                    
                        $is_correct[$q->id] = array(
                            'answer' => unserialize($correct->answer),
                            'status' => $correct->is_good
                        );
                        
                        if ($correct->is_good)
                        {
                            $good_questions++;
                        }
                    break;
                    case '4':
                        $answers[$q->id] = Jelly::select('question_hotspot')
                            ->where('question_id', '=', $q->id)
                            ->limit(1)
                            ->execute();
                
                        $is_correct[$q->id] = array(
                            'answer' => unserialize($correct->answer),
                            'status' => $correct->is_good
                        );
                        
                        if ($correct->is_good)
                        {
                            $good_questions++;
                        }
                    break;
                    case '5':
                        $answers[$q->id] = Jelly::select('question_boolean')
                            ->where('question_id', '=', $q->id)
                            ->limit(1)
                            ->execute();
                    
                        $is_correct[$q->id] = array(
                            'answer' => unserialize($correct->answer),
                            'status' => $correct->is_good
                        );
                        
                        if ($correct->is_good)
                        {
                            $good_questions++;
                        }
                    break;
                    case '6':
                        $answers[$q->id] = null;
                    
                        $is_correct[$q->id] = array(
                            'answer' => unserialize($correct->answer),
                            'status' => $correct->is_good
                        );
                    
                        if ($correct->is_good)
                        {
                            $good_questions++;
                        }
                    break;
                    case '7':
                        $answers[$q->id] = Jelly::select('question_list')
                            ->where('question_id', '=', $q->id)
                            ->limit(1)
                            ->execute();
                
                        $is_correct[$q->id] = array(
                            'answer' => explode('```', unserialize($correct->answer)),
                            'status' => $correct->is_good
                        );
                        
                        if ($correct->is_good)
                        {
                            $good_questions++;
                        }
                    break;
                }
            }
            
            if ($good_questions < 1)
            {
                $percent = 0;
            }
            else
            {
                $percent = floor((($good_questions/$test->questions)*100));
            }
        }
        else
        {
            message::error(__('Nie możesz oglądać tych statystyk'), 'mycourses', 'frontend');
        }
    }
}