<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Search extends Relio_Controller_Website {
    public function action_index()
    {
        if ($_POST) {
			$searchArray = array(
                'q' => Security::xss_clean(input::post('q'))
            );
			$searchArray = serialize($searchArray);
			
			$rawHash    = Text::random('alnum', 10);
			$encodeHash = strtoupper(md5($rawHash));
            
            Jelly::factory('search')->set(array(
                'hash'          => $encodeHash,
                'search_query'  => Security::xss_clean(input::post('q')),
                'search_string' => $searchArray,
            ))->save();
            
            $this->request->redirect('search/results/'.$encodeHash);
        }
        else 
        {
            $this->request->redirect('/');
        }
    }

    public function action_results()
    {
        $search = Jelly::select('search')->where('hash','=',$this->request->param('id'))->limit(1)->execute();
        
        if ($search->loaded())
        {
            $this->template = View::factory('smarty:layout_default');
            $this->template->content = View::factory('smarty:site/results')
                ->bind('items', $items)
                ->bind('pagination', $pagination)
                ->bind('search_query', $searchArray);
                
                
            $root = Jelly::factory('page')->root(Kohana::config('devilcms.defaults.languages.pl.id'));
            $descendants = $root->descendants(FALSE, 'ASC');
            
            $this->title = 'Wyszukiwarka';
                        
            $in_category = ',0';
            
            foreach($descendants as $d) {
                $in_category .= ','.$d->id;
            }
            $in_category = substr($in_category, 1);
            
            $searchArray = unserialize($search->search_string);
            
			$searchArray['q'] = str_replace(array('_', '%'), array('\\_', '\\%', $searchArray['q']));
			
            //szkolenia
            $searchCourses = array();
            $courses = Jelly::select('course')->filter(null, 1)
                ->and_where_open()
                ->where('name','LIKE','%'.$searchArray['q'].'%')
                ->or_where('content_short','LIKE','%'.$searchArray['q'].'%')
                ->or_where('content','LIKE', '%'.$searchArray['q'].'%')
                ->and_where_close()
                ->execute();
                            
            foreach($courses as $row) {
                $searchCourses[$row->id] = array(
                    'id'            => $row->id,
                    'name'          => $row->name,
                    'content_short' => $row->content_short,
                    'content'       => $row->content,
                    'icon'          => $row->icon,
                );
            }
            
            $searchCoursesTags = array();
            $tag = Jelly::select('tag')
                ->where('tag', '=', $searchArray['q'])
                ->limit(1)
                ->execute();
                
            if ($tag->loaded())
            {
                $courseTags = Jelly::select('course')->filter(null, 1)
                    ->join('course_tags', 'LEFT')
                    ->on('course_tags.course_id','=','courses.id')
                    ->where('course_tags.tag_id','=',DB::expr($tag->id))
                    ->execute();
                
                foreach($courseTags as $row) {
                    $searchCoursesTags[$row->id] = array(
                        'id'            => $row->id,
                        'name'          => $row->name,
                        'content_short' => $row->content_short,
                        'content'       => $row->content,
                        'icon'          => $row->icon
                    );
                }
            }
            
            $preItems = array_merge($searchCourses, $searchCoursesTags);
            
            $groupedItems = array();
            $grouped = array();
            foreach($preItems as $it) {
                if (!in_array($it['id'], $grouped))
                {
                    $groupedItems[] = array(
                        'id'            => $it['id'],
                        'name'          => $it['name'],
                        'content_short' => $it['content_short'],
                        'content'       => $it['content'],
                        'icon'          => $it['icon']
                    );
                    
                    $grouped[] = $it['id'];
                }
            }
            
            $items = $groupedItems;
            
            View::set_global('paths', array());
        }
        else
        {
            $this->request->redirect('/');
        }
    }
}
