<?php defined('SYSPATH') or die('No direct script access.');

class File extends Kohana_File {
    /**
     * Get extension of the original name of the file on the client machine.
     * 
     * @param string $name (optional) If set return extension of this string
     * @return string|null i.e. '.gif' or NULL
     * @access public
     */
    public static function getExt($name = null) {
        $s = isset($name) ? $name : '';
        
        $ext = null;
        if (($pos = strrpos($s, '.')) !== false) {
            $len = strlen($s) - ($pos + 1); //+1 jezeli ma byc bez kropki, usunac jak z kropka
            $ext = substr($s, -$len);
        }
        
        return $ext;
    }
    
    /**
     * Return natural size of data in bytes.
     * 
     * @param int $bytes
     * @return string
     * @access public
     */
    public static function filesize2bytes($bytes) {
        $base = 1024;
        $suffixes = array(' B', ' KB', ' MB', ' GB', ' TB', ' PB', ' EB');
        
        $usesuf = 0;
        $n = (float)$bytes;
        while ($n >= $base) {
            $n /= (float)$base;
            ++$usesuf;
        }
        
        $places = 2 - floor(log10($n));
        $places = max($places, 0);
        $retval = number_format($n, $places, '.', '') . $suffixes[$usesuf];
        
        return $retval;
    }
    
    /**
     * Usuwa rekurencyjnie zawartosc wybranego katalogu
     *  
     * @param string
     */
    public static function removeDir() {
        
    }
    
    public static function file_icon($file) {
        $mime_type = File::mime($file);
        $ext = File::getExt($file);
        $start = substr($mime_type, 0, strpos($mime_type, '/'));
        switch($start) {
            case 'application':
                switch($mime_type) {
                    case 'application/x-diskcopy':
                        return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/disk-image.png';
                    case 'application/pdf':
                        return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/document-pdf.png';
                    default:
                        if($ext) {
                            switch($ext) {
                                case 'psd':
                                    return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/document-psd.png';
                                case 'ai':
                                    return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/document-ai.png';
                                case 'fla':
                                case 'flv':
                                case 'swf':
                                    return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/document-fla.png';
                                case 'doc':
                                case 'docx':
                                    return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/document-doc.png';
                                case 'xls':
                                case 'xlsx':
                                    return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/document-xls.png';
                                case 'ppt':
                                case 'pptx':
                                    return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/document-ppt.png';
                                case 'zip':
                                case 'gz':
                                case 'tar':
                                case 'rar':
                                case 'ace':
                                case '7z':
                                case 'sit':
                                    return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/archive.png';
                            }
                        }
                        return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/blank.png';
                }
            case 'audio':
                return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/audio.png';
            case 'image':
                return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/image.png';
            case 'text':
                return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/text.png';
            case 'video':
                return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/video.png';
            default:
                return Url::base(FALSE, TRUE).'public/design/backend/images/icons/types/blank.png';
        }
    }
    
    public static function directoryToArray($directory, $recursive) {
        $array_items = array();
        if ($handle = opendir($directory)) {
            while (false !== ($file = readdir($handle))) {
                if ($file != "." && $file != "..") {
                    if (is_dir($directory. "/" . $file)) {
                        if ($recursive) {
                            $array_items = array_merge($array_items, file::directoryToArray($directory. "/" . $file, $recursive));
                        }
                    }
                    else {
                        $file = basename($file);
                        $file = preg_replace("/\/\//si", "/", $file);
                        $array_items[$file]['path'] = $directory.'/';
                        $array_items[$file]['file'] = $file;
                    }
                }
            }
            
            closedir($handle);
        }
        
        return $array_items;
    }
    
    public static function deleteAll($folder, $exclude = array()) {
		if (!@is_dir($folder)) {
			return false;
		}

		if ($handle = @opendir($folder)) {
			while (($file = readdir($handle)) !== false) {
				if ($file == "." || $file == "..") {
					continue;
				}

				if (is_dir($folder.'/'.$file) && !in_array($folder.'/'.$file,$exclude)) {
					// call self for this directory
					File::deleteAll($folder.'/'.$file.'/');

					//chmod($folder.$file, 0777);
					rmdir($folder.'/'.$file); //remove this directory
				}
				else {
					if (!in_array($folder.'/'.$file,$exclude)) {
						//chmod($folder.$file,0777);
						unlink($folder.'/'.$file); // remove this file
					}
				}
			}
		}

		@closedir($handle);
	}
    
    public static function download_remote($file = null, $local = null) {
        $cp = curl_init($file);
		$fp = fopen($local, "w");
		
		curl_setopt($cp, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($cp, CURLOPT_FILE, $fp);
		curl_setopt($cp, CURLOPT_HEADER, 0);
        curl_setopt($cp, CURLOPT_SSL_VERIFYPEER, false);
		
		curl_exec($cp);
		curl_close($cp);
		fclose($fp);
     
    }
}