<?php

class Kohana extends Kohana_Core {
 
    public static function exception_handler(Exception $e) {
        if (Kohana::DEVELOPMENT === Kohana::$environment) {
            parent::exception_handler($e);
        }
        else {
            try {
                Kohana::$log->add(Kohana::ERROR, parent::exception_text($e));
                Kohana::$log->write();
                
                $attributes = array(
                    'action'  => 500,
                    'message' => rawurlencode($e->getMessage())
                );
 
                if ($e instanceof HTTP_Response_Exception) {
                    $attributes['action'] = $e->getCode();
                }
                                            
                // Error sub-request.
                echo Request::factory(Route::url('error', $attributes))
                    ->execute()
                    ->send_headers()
                    ->response;
            }
            catch (Exception $e) {
                // Clean the output buffer if one exists
                ob_get_level() and ob_clean();
 
                // Display the exception text
                echo parent::exception_text($e);
 
                // Exit with an error status
                exit(1);
            }
        }
    }
}