<?php defined('SYSPATH') or die('No direct script access.');

/**
 * Raporty wysyłane do użytkowników
 *
 * @author Michal Mlodzinski <mm@etendard.pl>
 */
class Minion_Task_Report_Daily extends Minion_Task {
    /**
     * An array of config options that this task can accept
     */
    protected $_config = array();
    
    /**
     * Execute
     */
    public function execute(array $config) {
        $items = Jelly::select('course_user')
            ->with('course')
            ->where('active', '=', '1')
            ->where('_course:course.publish_on', '<=', date('Y-m-d'))
 			->where('_course:course.archive_on', '>=', date('Y-m-d'))
            ->execute();
    
        foreach($items as $it) {
            $item = Jelly::select('report_daily')
                ->where('course_id', '=', $it->course->id)
                ->where('user_id', '=', $it->user->id)
                ->where('created_on', '=', date('Y-m-d'))
                ->limit(1)
                ->execute();
            
            if (! $item->loaded())
            {
                $item = Jelly::factory('report_daily');
                $item->user = $it->user->id;
                $item->course = $it->course->id;
                $item->done_content = $it->done_content;
                $item->time_on = $it->time_on;
                $item->last_on = $it->last_on;
                $item->complete_on = $it->complete_on;
                $item->login_on = $it->login_on;
                $item->percent = $it->percent;
                $item->updated_on = date('Y-m-d H:i:s');
                $item->created_on = date('Y-m-d');
                $item->save();
            }
            else
            {
                $item->done_content = $it->done_content;
                $item->time_on = $it->time_on;
                $item->last_on = $it->last_on;
                $item->complete_on = $it->complete_on;
                $item->login_on = $it->login_on;
                $item->percent = $it->percent;
                $item->updated_on = date('Y-m-d H:i:s');
                $item->save();
            }
        }
    }
}