<?php
class Model_Builder_User extends Jelly_Builder {
    public function by_role($role = null)
    {
        $query = $this;
        
        if (!is_null($role) && !empty($role))
        {
            $query->where('roles_users.role_id', '=', DB::expr($role));
        }
        
    	return $query;  	
    }
    
    public function by_roles($role = null)
    {
        $query = $this;
        
        if (!is_null($role) && !empty($role))
        {
            $query->where('roles_users.role_id', 'IN', $role);
        }
        
    	return $query;  	
    }
    
    public function by_group($id = null)
    {
        $query = $this;
        
        if (! is_null($id) && ! empty($id))
        {
            $query->where('user_groups_users.user_group_id', '=', $id);
        }
        
    	return $query;  
    }
    
    public function filter($term = null)
    {
        $query = $this;
        
        if (!is_null($term) && is_array($term))
        {
            if (isset($term['firstname']))
            {
                if (!is_null($term['firstname']) && !empty($term['firstname']))
                {
                    $query->where('users.firstname', 'LIKE', '%'.$search.'%');
                }
            }
            
            if (isset($term['lastname']))
            {
                if (!is_null($term['lastname']) && !empty($term['lastname']))
                {
                    $query->where('users.lastname', 'LIKE', '%'.$search.'%');
                }
            }
            
            if (isset($term['email']))
            {
                if (!is_null($term['email']) && !empty($term['email']))
                {
                    $query->where('users.email', 'LIKE', '%'.$term['email'].'%');
                }
            }
            
            if (isset($term['group']))
            {
                if (!is_null($term['group']) && !empty($term['group']))
                {
                    $query->where('user_groups_users.user_group_id', '=', $term['group']);
                }
            }
            
            if (isset($term['course']))
            {
                if (!is_null($term['course']) && !empty($term['course']))
                {
                    $query->where('courses_users.course_id', '=', $term['course']);
                }
            }
            
            
            
            if (isset($term['status']))
            {
                if (!is_null($term['status']) && !empty($term['status']))
                {
                    $query->where('users.active', '=', $status);
                }
            }            
        }
                
        return $query;
    }
}