<?php

class Model_Category extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->sorting(array('posy' => 'ASC'))
            ->fields(array(
    		'id' => Jelly::field('primary'),
            'first_parent_id' => Jelly::field('integer'),
            'second_parent_id' => Jelly::field('integer'),
    		'name' => Jelly::field('string'),
            'posy' => Jelly::field('integer', array(
                'default' => 1
            )),
            'active' => Jelly::field('integer', array(
                'default' => 1
            )),
    		'course' => Jelly::field('hasmany'),
            'material' => Jelly::field('hasmany')
        ));
    }

    /**
    * @author Michal Mlodzinski - mm@etendard.pl
    * Pobieranie informacji na temat tego ile jest modulow
    */
    public function total_modules() {
        $max_posy = DB::select(DB::expr('MAX(posy) AS max_posy'))
            ->from('categories')
            ->where('first_parent_id', '=', $this->first_parent_id)
            ->cached(3600)
            ->execute()
            ->get('max_posy');
        
        return $max_posy;
    }

    /**
    * @author Michal Mlodzinski - mm@etendard.pl
    * Pobierz pierwszy material z aktualnego modulu
    */
    public function first_material() {
        $material = Jelly::select('material')
            ->where('category_id', '=', $this->id)
            ->limit(1)
            ->cached(3600)
            ->execute();
        
        return $material;
    }

    /**
    * @author Michal Mlodzinski - mm@etendard.pl
    * Pobierz ostatni material z aktualnego modulu
    */
    public function last_material() {
        $material = Jelly::select('material')
            ->where('category_id', '=', $this->id)
            ->order_by('posy', 'DESC')
            ->limit(1)
            ->cached(3600)
            ->execute();
        
        return $material;
    }
    
    public function preparePosyLast($category) {
        $max_posy = DB::select(DB::expr('MAX(posy) AS max_posy'))
            ->from('categories')
            ->where('first_parent_id', '=', $category)
            ->execute()
            ->get('max_posy');
        
        return $max_posy;
    }

    public function preparePosy($category) {
        DB::update('categories')
            ->set(array(
                'posy' => DB::expr('posy+1')
            ))
            ->where('first_parent_id', '=', $category)
            ->where('id', '>', 0)->execute();
    }

    public function rePosy($category) {
        $i = 1;

        $items = Jelly::select('category')->filter($category, 0)->execute();
        foreach($items as $it) {
            $it->posy = $i;
            $it->save();

            $i++;
        }
    }
    
    public function positionUp($column, $op, $value) {
        $row2 = DB::select()->from('categories')
            ->where('posy', '<', $this->posy)
            ->where($column, $op, $value)
            ->order_by('posy', 'DESC')
            ->limit(1)
            ->offset(0)
            ->execute()->as_array();
               
        if ($row2[0]['id']) {
            DB::update('categories')->set(array('posy'=>$row2[0]['posy']))->where('id','=',$this->id)->execute();
            DB::update('categories')->set(array('posy'=>$this->posy))->where('id','=',$row2[0]['id'])->execute();
        }
    }
    
    public function positionDown($column, $op, $value) {
        $row2 = DB::select()->from('categories')
            ->where('posy', '>', $this->posy)
            ->where($column, $op, $value)
            ->order_by('posy', 'ASC')
            ->limit(1)
            ->offset(0)
            ->execute()->as_array();
                
        if ($row2[0]['id']) {
            DB::update('categories')->set(array('posy'=>$row2[0]['posy']))->where('id','=',$this->id)->execute();
            DB::update('categories')->set(array('posy'=>$this->posy))->where('id','=',$row2[0]['id'])->execute();
        }
    }
}