<?php

class Model_Certificate_History extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->fields(array(
    		'id' => Jelly::field('primary'),
            'firstname' => Jelly::field('string'),
            'lastname' => Jelly::field('string'),
    		'downloads' => Jelly::field('integer', array(
                'default' => 0
            )),
            'publish_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => FALSE,
                'auto_now_update' => FALSE
            )),
            'archive_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => FALSE,
                'auto_now_update' => FALSE
            )),
            'signed_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => FALSE,
                'auto_now_update' => FALSE
            )),
            'complete_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => FALSE,
                'auto_now_update' => FALSE
            )),
            'time_on' => Jelly::field('integer'),
            'downloaded_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => FALSE,
                'auto_now_update' => FALSE
            )),
            'created_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => TRUE,
                'auto_now_update' => FALSE
            )),
            'active' => Jelly::field('integer', array(
                'default' => 1
            )),
            'user' => Jelly::field('belongsto'),
            'course' => Jelly::field('belongsto'),
            'subscribe' => Jelly::field('belongsto', array(
                'foreign' => 'course_user',
                'column' => 'subscribe_id'
            ))
        ));
    }
}