<?php defined('SYSPATH') or die('No direct script access.');

class Model_Content extends Jelly_Model {
    
	public static function initialize(Jelly_Meta $meta) {
	   $meta->fields(array(
			'id' => new Field_Primary,
			'title' => new Field_String(array(
				'label' => __('Title')
			)),
            'content_short' => new Field_Text(array(
				'label' => __('Content'),
                'empty' => TRUE
			)),
			'data' => new Field_Text(array(
				'label' => __('Content'),
                'empty' => TRUE
			)),
            'icon' => new Field_String(array(
                'empty' => TRUE
            )),
			'language' => new Field_String(array( // TODO: Sprig_Field_Language
				'default' => 'de-de'
			)),
			'slug' => new Field_String,
			'type' => new Field_String, // TODO: Sprig_Field_Type
            'template' => new Field_String(array(
                'empty' => TRUE
            )),
			'page' => new Field_BelongsTo,
			'created_on' => new Field_String(array(
				'default' => date('Y-m-d H:i:s', time()),
				'empty'   => TRUE
			)),
			'updated_on' => new Field_String(array(
				'default' => TRUE,
				'empty'   => TRUE
			)),
			'created_by' => new Field_Integer,
			'updated_by' => new Field_Integer,
			'hide_menu' => new Field_Boolean,
			'keywords' => new Field_String(array(
				'label' => __('Keywords'),
				'empty' => TRUE,
				'null' => TRUE
			)),
            'description' => new Field_Text(array(
                'empty' => TRUE,
                'null'  => TRUE
            )),
            'menu' => new Field_Integer(array(
                'default' => 0
            )),
            'system' => new Field_Integer(array(
                'default' => 0
            ))
		));
	}
    
    public function mod_url($slug) {
        $original_slug = $slug;
        
        $iCounter = 0;
        
        while ( true ) {
            $check_page = Jelly::select('content')->where('slug','=',$slug)->execute();
            if ($check_page->count()) {
                $iCounter++ ;
                
                $slug = $original_slug.'-'.$iCounter;
            }
            else {
                break;
            }
        }
        
        return $slug;
    }

}