<?php

class Model_Course extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->sorting(array('id' => 'DESC'))
        ->fields(array(
    		'id' => new Field_Primary,
    		'name' => new Field_String,
            'content_short' => new Field_Text,
    		'content' => new Field_Text,
            'options' => new Field_Text,
    		'publish_on' => new Field_String,
    		'archive_on' => new Field_String,
            'hours' => new Field_String,
            'icon' => new Field_String,
            'icon_entry' => new Field_String,
            'movie' => new Field_String,
            'movie_duration' => new Field_String,
            'notify_notstart' => Jelly::field('integer', array(
                'default' => 1
            )),
            'notify_progress' => Jelly::field('integer', array(
                'default' => 1
            )),
            'notify_finish' => Jelly::field('integer', array(
                'default' => 1
            )),
            'accept' => new Field_Integer,
            'dependence' => Jelly::field('text'),
            'subscribers' => new Field_Integer(array(
                'default' => 0
            )),
            'type' => Jelly::field('integer', array(
                'default' => 1
            )),
            'promoted' => Jelly::field('integer', array(
                'default' => 0
            )),
    		'active' => Jelly::field('integer', array(
                'default' => 1
            )),
            'category' => new Field_BelongsTo(array(
                'foreign' => 'category',
                'column' => 'category_id'
            )),
    		'certificate' => Jelly::field('belongsto', array(
                'null' => TRUE
            )),
            'forum' => Jelly::field('belongsto', array(
                'allow_null' => TRUE,
                'foreign' => 'forum_forum',
                'column' => 'forum_id'
            )),
            'chat' => Jelly::field('belongsto', array(
                'allow_null' => TRUE,
                'foreign' => 'chat'
            )),
			'subject' => Jelly::field('belongsto', array(
                'allow_null' => TRUE,
                'foreign' => 'subject'
            )),
            'course_category' => new Field_ManyToMany(array(
                'foreign' => 'course_category',
                'through' => array(
                    'model' => 'course_category_courses',
                    'columns' => array('course_id', 'course_category_id')
                )
            )),
            'course_group' => new Field_ManyToMany(array(
                'foreign' => 'course_group',
                'through' => array(
                    'model'   => 'course_group_courses',
                    'columns' => array('course_id', 'course_group_id')
                )
            )),
    		'moderators' => new Field_ManyToMany(array(
                'foreign' => 'user',
                'through' => array(
                    'model'   => 'course_moderators',
                    'columns' => array('course_id', 'user_id'),
                )
            )),
            'user_group' => new Field_ManyToMany(array(
                'foreign' => 'user_group',
                'through' => array(
                    'model' => 'course_user_groups',
                    'columns' => array('course_id', 'group_id')
                )
            )),
            'users' => new Field_HasMany(array(
                'foreign' => 'course_user',
                'column' => 'course_id'
            ))
        ));
    }
    
    public function has_library()
    {
        $check = Jelly::select('course_page')
            ->where('scope', '=', $this->id)
            ->count();
        
        if ($check > 0)
        {
            return TRUE;
        }
        
        return FALSE;
    }
    
    public function count_materials() {
        $materials = array();
        
        $cache = Cache::instance('file');
        
        $count_materials = $cache->get('count_material_'.$this->id);
        
        if (!$count_materials) {
            $chapters = Jelly::select('category')->filter($this->category->id, 0)->execute();
            foreach($chapters as $ch) {
                foreach($ch->material as $m) {
					if ($m->type == 'test') {
					   $test = Jelly::select('material_test')->by_material($m->id)->limit(1)->cached(3600)->execute();
					   if ($test->question->count()) {
						   $materials[] = $m->id;
					   }
					}
					else {
						$materials[] = $m->id;
					}
				}
            }
            
            $count_materials = count($materials);
            
            $cache->set('count_material_'.$this->id, $count_materials, 3600);
        }
                    
        return $count_materials;
    }

    public function next_module($current) {
        if (!is_null($current) && !empty($current)) {
            $item = Jelly::select('category')
                ->filter($this->category->id, 0)
                ->where('posy', '>', $current->posy)
                ->order_by('posy', 'ASC')
                ->limit(1)
                ->cached(3600)
                ->execute();
        
            return $item;
        }
        else {
            return '0';
        }
    }

    public function prev_module($current) {
        if (!is_null($current) && !empty($current)) {
            $item = Jelly::select('category')
                ->filter($this->category->id, 0)
                ->where('posy', '<', $current->posy)
                ->order_by('posy', 'DESC')
                ->limit(1)
                ->cached(3600)
                ->execute();
        
            return $item;
        }
        else {
            return '0';
        }
    }
    
    public function updateSubscribers() {
        DB::update('courses')->set(array('subscribers'=>DB::expr('subscribers+1')))->where('id','=',$this->id)->execute();
    }
    
    public function certificate() {
        if (Session::instance()->get('auth_user')->id) {
            $subscribe = Jelly::select('course_user')
                ->filter(Session::instance()->get('auth_user')->id, $this->id)
                ->limit(1)
                ->execute();

            $certificate = Jelly::select('certificate_history')
                ->where('user_id', '=', Session::instance()->get('auth_user')->id)
                ->where('course_id', '=', $this->id)
                ->where('subscribe_id', '=', $subscribe->id)
                ->limit(1)
                ->execute();
            
            return $certificate->id;
        }
        else {
            return false;
        }
    }
}