<?php

class Model_Course_User extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->table('courses_users')
        ->fields(array(
            'id' => Jelly::field('primary'),
            'done_content' => Jelly::field('text'),
            'signed_on' => Jelly::field('string', array(
                'default' => date('Y-m-d H:i:s', time())
            )),
            'login_on' => Jelly::field('string'),
            'complete_on' => Jelly::field('string'),
            'updated_on' => Jelly::field('string'),
            'time_on' => Jelly::field('integer'),
            'last_on' => Jelly::field('string'),
            'percent' => Jelly::field('integer', array(
                'default' => 0
            )),
            'notified' => Jelly::field('integer', array(
                'default' => 0
            )),
            'active' => Jelly::field('integer'),
            'course' => Jelly::field('belongsto'),
            'user' => Jelly::field('belongsto'),
            'material' => Jelly::field('belongsto', array(
                'null' => TRUE
            ))
        ));
    }
    
    public function done($material_id)
    {
        $array = unserialize($this->done_content);
        $array[$material_id] = $material_id;
        
        $this->done_content = serialize($array);
        $this->save();
    }
    
    public function undone($material_id)
    {
        //
    }
    
    public function last_seen($material_id)
    {
        $this->material = $material_id;
        $this->save();
    }
    
    public function passed_materials()
    {
        $array = unserialize($this->done_content);
        
        return count($array);
    }
    
    public function update_progress()
    {
        if ($this->percent < 100)
        {
            $passed = unserialize($this->done_content);
                 
            /**
             * Ilosc rozdzialow zaliczonych / ilosc rozdzialow w szkoleniu
             */
            $progress_percent = ceil((count($passed)*100) / $this->course->count_materials());
            if ($progress_percent > 100)
            {
                $progress_percent = '100';
            }
            
            $this->percent = $progress_percent;
            if ($progress_percent == 100)
            {
                $this->complete_on = date('Y-m-d H:i:s', time());
            }
            $this->save();
        }
    }
    
    public function required_complete_until()
    {
        $datediff = Date::datediff(time(), strtotime($this->required_complete_on));
        
        $timer = $datediff['days'].' '.Text::odmiana($datediff['days'], 'dzień', 'dni', 'dni').' ';
        $timer .= $datediff['hours'].' '.Text::odmiana($datediff['hours'], 'godzina', 'godziny', 'godzin').' ';
        $timer .= $datediff['minutes'].' '.Text::odmiana($datediff['minutes'], 'minuta', 'minuty', 'minut').' ';
        
        return $timer;
    }
}