<?php

class Model_Forum_Category extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta)
    {
    	$meta->sorting(array('posy' => 'ASC'))
        ->fields(array(
    		'id' => Jelly::field('primary'),
    		'name' => Jelly::field('string'),
            'content' => Jelly::field('text'),
            'posy' => Jelly::field('integer', array(
                'default' => 0
            )),
            'active' => Jelly::field('integer', array(
                'default' => 0
            )),
            'forums' => Jelly::field('hasmany', array(
                'foreign' => 'forum_forum.category_id'
            ))
        ));
    }
    
    public function preparePosy()
    {
        DB::update('forum_categories')
            ->set(array(
                'posy' => DB::expr('posy+1')
            ))
            ->execute();
    }
    
    public function positionUp()
    {
        $row2 = DB::select()
            ->from('forum_categories')
            ->where('posy', '<', $this->posy)
            ->order_by('posy', 'DESC')
            ->limit(1)
            ->offset(0)
            ->execute()
            ->as_array();
               
        if ($row2[0]['id'])
        {
            DB::update('forum_categories')
                ->set(array(
                    'posy' => $row2[0]['posy']
                ))
                ->where('id', '=', $this->id)
                ->execute();
                
            DB::update('forum_categories')
                ->set(array(
                    'posy' => $this->posy
                ))
                ->where('id', '=', $row2[0]['id'])
                ->execute();
        }
    }
    
    public function positionDown()
    {
        $row2 = DB::select()
            ->from('forum_categories')
            ->where('posy', '>', $this->posy)
            ->order_by('posy', 'ASC')
            ->limit(1)
            ->offset(0)
            ->execute()
            ->as_array();
                
        if ($row2[0]['id'])
        {
            DB::update('forum_categories')
                ->set(array(
                    'posy' => $row2[0]['posy']
                ))
                ->where('id', '=', $this->id)
                ->execute();
                
            DB::update('forum_categories')
                ->set(array(
                    'posy' => $this->posy
                ))
                ->where('id', '=', $row2[0]['id'])
                ->execute();
        }
    }
    
    public function get_forums()
    {
        $forums = Jelly::select('forum_forum')
            ->where('category_id', '=', $this->id)
            ->where('active', '=', '1')
            ->order_by('posy', 'ASC')
            ->execute();
        
        return $forums;
    }
}