<?php

class Model_Forum_Post extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->sorting(array('id' => 'DESC'))
        ->fields(array(
    		'id' => Jelly::field('primary'),
    		'name' => Jelly::field('string'),
            'content' => Jelly::field('string'),
            'use_bbcode' => Jelly::field('integer', array(
                'default' => 0
            )),
            'use_smilies' => Jelly::field('integer', array(
                'default' => 0
            )),
            'use_links' => Jelly::field('integer', array(
                'default' => 0
            )),
            'created_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => TRUE,
                'auto_now_update' => FALSE
            )), 
            'opened' => Jelly::field('integer', array(
                'default' => 0
            )),
            'user' => Jelly::field('belongsto'),
            'topic' => Jelly::field('belongsto', array(
                'foreign' => 'forum_topic',
                'column' => 'topic_id'
            )),
        ));
    }
}