<?php

class Model_Material extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->sorting(array('posy' => 'ASC'))
        ->fields(array(
    		'id' => Jelly::field('primary'),
    		'name' => Jelly::field('string'),
            'type' => Jelly::field('string'),
            'posy' => Jelly::field('integer', array(
                'default' => 1
            )),
            'active' => Jelly::field('integer', array(
                'default' => 1
            )),
    		'category' => Jelly::field('belongsto', array(
                'foreign' => 'category',
                'column' => 'category_id'
            )),
            'material_lesson' => Jelly::field('hasone'),
            'material_test' => Jelly::field('hasone')
        ));
    }
    
    public function admin_type_uri() {
        switch($this->type) {
            case 'lesson':
                return URL::site('admin/material_lesson/index/'.$this->id);
            break;
            case 'test':
                return URL::site('admin/material_test/index/'.$this->id);
            break;
            case 'exercise':
                return URL::site('admin/material_exercise/index/'.$this->id);
            break;
            case 'scorm':
                return URL::site('admin/material_scorm/index/'.$this->id);
            break;
            case 'videosync':
                return URL::site('admin/material_videosync/index/'.$this->id);
            break;
        }
    }

    public function is_module_last() {
        $item = Jelly::select('material')
            ->where('posy', '>', $this->posy)
            ->where('category_id', '=', $this->category->id)
            ->limit(1)
            ->execute();
        
        if ($item->loaded()) {
            return false;
        }
        
        return true;
    }
    
    public function prev_material() {
        $item = Jelly::select('material')
            ->where('posy', '<', $this->posy)
            ->where('category_id', '=', $this->category->id)
            ->order_by('posy', 'DESC')
            ->limit(1)
            ->execute();
        
        return $item;
    }
    
    public function next_material() {
        $item = Jelly::select('material')
            ->where('posy', '>', $this->posy)
            ->where('category_id', '=', $this->category->id)
            ->order_by('posy', 'ASC')
            ->limit(1)
            ->execute();
        
        return $item;
    }
    
    public function is_passed($course, $user) {
        $counter = Jelly::query('material_stat')
            ->where('user_id', '=', $user)
            ->where('course_id', '=', $course)
            ->where('material_id', '=', $this->id)
            ->where('status', '=', 1)
            ->select();
        
        if ($counter->count()) {
            return true;
        }
        else {
            return false;
        }
    }

    public function preparePosyLast($category) {
        $max_posy = DB::select(DB::expr('MAX(posy) AS max_posy'))
            ->from('materials')
            ->where('category_id', '=', $category)
            ->execute()
            ->get('max_posy');
        
        return $max_posy;
    }
    
    public function preparePosy($category) {
        DB::update('materials')
            ->set(array(
                'posy' => DB::expr('posy+1')
            ))
            ->where('category_id', '=', $category)
            ->where('id', '>', '0')
            ->execute();
    }

    public function rePosy($category) {
        $i = 1;

        $items = Jelly::select('material')
            ->where('category_id', '=', $category)
            ->where('id', '!=', $this->id)
            ->execute();
            
        foreach($items as $it) {
            $it->posy = $i;
            $it->save();

            $i++;
        }
    }
    
    public function positionUp($column, $op, $value) {
        $row2 = DB::select()->from('materials')
            ->where('posy', '<', $this->posy)
            ->where($column, $op, $value)
            ->order_by('posy', 'DESC')
            ->limit(1)
            ->offset(0)
            ->execute()->as_array();
               
        if ($row2[0]['id']) {
            DB::update('materials')->set(array('posy'=>$row2[0]['posy']))->where('id','=',$this->id)->execute();
            DB::update('materials')->set(array('posy'=>$this->posy))->where('id','=',$row2[0]['id'])->execute();
        }
    }
    
    public function positionDown($column, $op, $value) {
        $row2 = DB::select()->from('materials')
            ->where('posy', '>', $this->posy)
            ->where($column, $op, $value)
            ->order_by('posy', 'ASC')
            ->limit(1)
            ->offset(0)
            ->execute()->as_array();
                
        if ($row2[0]['id']) {
            DB::update('materials')->set(array('posy'=>$row2[0]['posy']))->where('id','=',$this->id)->execute();
            DB::update('materials')->set(array('posy'=>$this->posy))->where('id','=',$row2[0]['id'])->execute();
        }
    }
}