<?php

class Model_Material_Lesson extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->fields(array(
    		'id' => Jelly::field('primary'),
            'content' => Jelly::field('text'),
            'help' => Jelly::field('text'),
            'icon' => Jelly::field('string'),
            'movie' => Jelly::field('string'),
            'movie_duration' => Jelly::field('string'),
            'presentation' => Jelly::field('string'),
    		'material' => Jelly::field('belongsto', array(
                'foreign' => 'material'
            ))
        ));
    }
    
    public function is_audio()
    {       
        $file = $this->movie;
        
        if (file_exists($file))
        {
            $ext = File::getExt($file);
            $mime_type = File::mime($file);
            
            $start = substr($mime_type, 0, strpos($mime_type, '/'));
            
            switch($start) {
                case 'audio':
                    return TRUE;
                break;
                default:
                    return FALSE;
                break;
            }
        }           
    }
}