<?php

class Model_Material_Stat extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->fields(array(
    		'id' => Jelly::field('primary'),
            'pass_percent' => Jelly::field('float'),
            'pass_question' => Jelly::field('integer'),
            'score' => Jelly::field('float'),
    		'trials' => Jelly::field('integer'),
            'last_trial' => Jelly::field('string', array(
                'default' => date('Y-m-d H:i:s', time())
            )),
            'start_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => FALSE,
                'auto_now_update' => FALSE
            )), 
            'end_on' => Jelly::field('timestamp', array(
                'format' => 'Y-m-d H:i:s',
                'auto_now_create' => FALSE,
                'auto_now_update' => FALSE
            )), 
            'status' => Jelly::field('integer'),
    		'user' => Jelly::field('belongsto'),
            'course' => Jelly::field('belongsto'),
            'test' => Jelly::field('belongsto'),
            'material' => Jelly::field('belongsto')
        ));
    }
}