<?php

class Model_Slider extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->sorting(array('posy' => 'ASC'))
        ->fields(array(
    		'id' => Jelly::field('primary'),
    		'name' => Jelly::field('string'),
            'content' => Jelly::field('text'),
            'redirect' => Jelly::field('string'),
            'icon' => Jelly::field('string'),
            'created_on' => Jelly::field('string', array(
                'default' => date('Y-m-d H:i:s', time())
            )),
            'posy' => Jelly::field('integer', array(
                'default' => 1
            )),
            'active' => Jelly::field('integer', array(
                'default' => 1
            ))
        ));
    }
    
    public function preparePosy() {
        DB::update('sliders')
            ->set(array(
                'posy' => DB::expr('posy+1')
            ))
            ->where('id', '>', '0')
            ->execute();
    }
    
    public function positionUp($column, $op, $value) {
        $row2 = DB::select()->from('materials')
            ->where('posy', '<', $this->posy)
            ->where($column, $op, $value)
            ->order_by('posy', 'DESC')
            ->limit(1)
            ->offset(0)
            ->execute()->as_array();
               
        if ($row2[0]['id']) {
            DB::update('materials')->set(array('posy'=>$row2[0]['posy']))->where('id','=',$this->id)->execute();
            DB::update('materials')->set(array('posy'=>$this->posy))->where('id','=',$row2[0]['id'])->execute();
        }
    }
    
    public function positionDown($column, $op, $value) {
        $row2 = DB::select()->from('materials')
            ->where('posy', '>', $this->posy)
            ->where($column, $op, $value)
            ->order_by('posy', 'ASC')
            ->limit(1)
            ->offset(0)
            ->execute()->as_array();
                
        if ($row2[0]['id']) {
            DB::update('materials')->set(array('posy'=>$row2[0]['posy']))->where('id','=',$this->id)->execute();
            DB::update('materials')->set(array('posy'=>$this->posy))->where('id','=',$row2[0]['id'])->execute();
        }
    }
}