<?php defined('SYSPATH') or die('No direct script access.');

abstract class Relio_Auth extends Kohana_Auth {

	public function impersonate($user) {
		if ( ! $user->loaded()) {
			throw new Exception;
        }

		Session::instance()->set('impersonator', $this->get_user());

		$this->logout();
		$this->force_login($user);
	}

	public function abdicate() {
		if ( ! $this->is_impersonating()) {
			return FALSE;
        }

		$impersonator = $this->get_impersonator();

		Session::instance()->delete('impersonator');

		if (!$impersonator->loaded()) {
			throw new Exception;
        }

		$this->logout();
		$this->force_login($impersonator);
	}

	public function is_impersonating() {
		return (bool)Session::instance()->get('impersonator');
	}

	public function get_impersonator() {
		return Session::instance()->get('impersonator');
	}

}