<?php defined('SYSPATH') or die('No direct script access.');

require_once Kohana::find_file('vendor/mpdf', 'mpdf');

class Relio_Certificate {
    public static function create($course, $subscribe, $notify = false)
    {
        $ch = Jelly::factory('certificate_history');
        $ch->user = $subscribe->user->id;
        $ch->course = $course->id;
        $ch->subscribe = $subscribe->id;
        $ch->firstname = $subscribe->user->firstname;
        $ch->lastname = $subscribe->user->lastname;
        $ch->publish_on = $course->publish_on;
        $ch->archive_on = $course->archive_on;
        $ch->signed_on = $subscribe->signed_on;
        $ch->complete_on = $subscribe->complete_on;
        $ch->time_on = $subscribe->time_on;
        $ch->save();
                                
        if ($notify)
        {
            $replaceData = array();
            $replaceData['%firstname%'] = $ch->user->firstname;
            $replaceData['%lastname%'] = $ch->user->lastname;
            $replaceData['%course%'] = $ch->course->name;
            $replaceData['%certificate_link%'] = URL::site('course/certificate/'.$ch->id, 'http');
            $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
            xwContentTemplateWrapper::parameter_email(12, $replaceData, $ch->user->email, CFG_WEBMASTER_EMAIL);
        }
    }
    
    public static function download($item)
    {
        $replaceData = array();
        $replaceData['[course_name]'] = $item->course->name;
        $replaceData['[course_description]'] = $item->course->content_short;
        $replaceData['[date_begin]'] = $item->publish_on;
        $replaceData['[date_end]'] = $item->archive_on;
        $replaceData['[display_name]'] = $item->firstname.' '.$item->lastname;
        $replaceData['[date_enroll]'] = date('Y-m-d', strtotime($item->signed_on));
        $replaceData['[date_complete]'] = date('Y-m-d', strtotime($item->complete_on));
        $replaceData['[total_time]'] = Lms::time_on($item->time_on);
        $replaceData['[today]'] = date('d/m', strtotime($item->created_on));
        $replaceData['[year]'] = date('Y', strtotime($item->created_on));
                        
        $content = str_replace(array_keys($replaceData), array_values($replaceData), $item->course->certificate->content);
        
        $content = View::factory('smarty:site/certificate/schema')
            ->bind('content', $content)
            ->bind('set', $item->course->certificate->icon)
            ->render();
            
        $mpdf=new mPDF('UTF-8', 'A4', 10, 'arial'); 
                        
        $mpdf->mirrorMargins = 1;	// Use different Odd/Even headers and footers and mirror margins
        $mpdf->defaultheaderfontsize = 10;	/* in pts */
        $mpdf->defaultheaderfontstyle = B;	/* blank, B, I, or BI */
        $mpdf->defaultheaderline = 0; 	/* 1 to include line below header/above footer */
                        
        $mpdf->defaultfooterfontsize = 12;	/* in pts */
        $mpdf->defaultfooterfontstyle = B;	/* blank, B, I, or BI */
        $mpdf->defaultfooterline = 0; 	/* 1 to include line below header/above footer */
                        
        $mpdf->WriteHTML($content);
        $mpdf->Output('certyfikat.pdf', 'D');
                        
        exit;
    }
}