<?php

defined('SYSPATH') or die('No direct script access.');
/**
 * EPM - E-ProjectManager
 * Copyright (c) 2010, Michal Mlodzinski <m at relio.pl>
 * All rights reserved.
 *
 */

class Relio_Message
{
      public static function get_once($type = 'backend')
      {
            if ($type == 'backend') {
                $message = Session::instance()->get_once('message');
                $message_type_raw = Session::instance()->get_once('message_type_raw');
                $message_type = Session::instance()->get_once('message_type');
            
                $return = array('message' => $message, 'message_type' => $message_type, 'message_type_raw' => $message_type_raw);

            }
            else {
                $message = Session::instance()->get_once($type.'_message');
                $message_type_raw = Session::instance()->get_once($type.'_message_type_raw');
                $message_type = Session::instance()->get_once($type.'_message_type');
            
                $return = array($type.'_message' => $message, $type.'_message_type' => $message_type, $type.'_message_type_raw' => $message_type_raw);

            }
            
            return $return;
      }
      
      public static function good($message = null, $uri = null, $type = 'backend', $force_redirect = false)
      {
            if ($message !== null)
            {
                  if ($type == 'backend') {
                       Session::instance()->set('message', $message);
                       Session::instance()->set('message_type_raw', 'Sukces');
                       Session::instance()->set('message_type', 'success'); 
                  }
                  else {
                       Session::instance()->set($type.'_message', $message);
                       Session::instance()->set($type.'_message_type_raw', 'Sukces');
                       Session::instance()->set($type.'_message_type', 'success'); 
                  }
            }

            if ($uri !== null)
            {
				if (Request::$is_ajax && !$force_redirect) {
					Request::instance()->headers['REDIRECT'] = '1';
					
					echo $uri;
				}
				else {
					Request::instance()->redirect($uri);
				}
			}
      }
      
      public static function error($message = null, $uri = null, $type = 'backend', $force_redirect = false)
      {
            if ($message !== null)
            {
                  if ($type == 'backend') {
                       Session::instance()->set('message', $message);
                       Session::instance()->set('message_type_raw', 'Błąd');
                       Session::instance()->set('message_type', 'error'); 
                  }
                  else {
                       Session::instance()->set($type.'_message', $message);
                       Session::instance()->set($type.'_message_type_raw', 'Błąd');
                       Session::instance()->set($type.'_message_type', 'error'); 
                  }
            }

            if ($uri !== null)
            {
                if (Request::$is_ajax && !$force_redirect) {
					Request::instance()->headers['REDIRECT'] = '1';
					
					echo $uri;
				}
				else {
					Request::instance()->redirect($uri);
				}
            }
      }
}
