<?php defined('SYSPATH') or die('No direct script access.');

class Relio_Quiz {
    public $test_id;
    public $course_id;
    public $material_id;
    public $user_unique_id;
    
    public $test_questions;
    public $questions;
    public $question_list;
    
    public function __construct($test_id = 0, $course_id = 0, $material_id = 0) {
        $this->test_id = $test_id;
        $this->course_id = $course_id;
        $this->material_id = $material_id;
        
        $session_test = Session::instance()->get('test');
        
  	}
    
    public function quiz_gen_uid() {
		$this->user_unique_id = md5(uniqid(rand(), true));
	}
    
    function quiz_new_start() {
        $session_test = Session::instance()->get('test');
        
        $builder = Jelly::select('question')
            ->where('test_id', '=', $this->test_id)
            ->where('active', '=', '1')
            ->limit($session_test['limit']);
            
        if ($session_test['test']->random_questions) {
            $builder->order_by(DB::expr('RAND()'), null);
        }
        $items = $builder->execute();
		
        if ($session_test['limit'] == '1') {
            $quiz_quests[] = $items->id;
        }
        else {
            foreach ($items as $row) {
                $quiz_quests[] = $row->id;
            }
        }
                
        if ($session_test['test']->random_questions) {
            srand((float)microtime() * 1000000);
            shuffle($quiz_quests);
        }
              
        $this->questions = $quiz_quests;
        
        $stat = Jelly::select('material_stat')
            ->where('test_id', '=', $this->test_id)
            ->where('user_id', '=', Session::instance()->get('auth_user')->id)
            ->where('course_id', '=', $this->course_id)
            ->limit(1)
            ->execute();
            
        if (!$stat->loaded()) {
            $stat = Jelly::factory('material_stat');
            $stat->set(array(
                'user'          => Session::instance()->get('auth_user')->id,
                'course'        => $this->course_id,
                'test'          => $this->test_id,
                'material'      => $this->material_id,
                'pass_question' => $session_test['test']->questions_to_pass,
                'trials'        => 1,
                'status'        => 0,
                'start_on'      => date('Y-m-d H:i:s')
            ));
            $stat->save();
        }
        else
        {
            $stat->pass_question = $session_test['test']->questions_to_pass;
            $stat->start_on = date('Y-m-d H:i:s');
            $stat->trials = ($stat->trials+1);
            $stat->updated_on = date('Y-m-d H:i:s', time());
            $stat->save();
        }
        
        $report = Jelly::factory('report_test');
        $report->user = Session::instance()->get('auth_user')->id;
        $report->material = $this->material_id;
        $report->start_on = date('Y-m-d H:i:s');
        $report->status = 0;
        $report->save();
        
        Session::instance()->set('test_report', $report->id);
        
        Session::instance()->set('test_trials_'.$this->test_id, $stat->trials);
	}
    
	public function quiz_get_questionlist() {
	    
        if (!empty($this->questions)) {
            Session::instance()->set('test_questions_'.$this->test_id, $this->questions);
            $test_questions = $this->questions;
        }
        else {
            $test_questions = Session::instance()->get('test_questions_'.$this->test_id);
        }
        
		return $test_questions;
	}
    
    public function lotto_question($question_number) {
        /**
         * 1 - jednokrotnego wyboru
         * 2 - wielokrotnego wyboru
         * 3 - Dopasuj pary
         * 4 - Zaznacz obszar
         * 5 - Prawda / falsz
         * 6 - Pytanie otwarte
         * 7 - Wypisz...
         */
        $question =  Jelly::select('question', $question_number);
        switch ($question->type) {
            case 1:
                $answers = Jelly::select('question_choice')->where('question_id','=',$question->id)->limit(1)->cached(3600)->execute()->as_array();
                Arr::kshuffle($answers);
                
                foreach($answers as $var => $val) {
                    $$var= $val;
                }
                
                $aWzor = array(1,2,3,4,5,6,7,8,9,10);
                
                shuffle($aWzor);
                $i = 1;
                
                foreach($aWzor as $val) {
                    $aWzorRandom[$i] = $val;
                    $i++;
                }
                
                Arr::kshuffle($aWzorRandom);
                
                $aShowAnswers = array();
                foreach($aWzorRandom as $key =>  $val) {
                    if(!empty($answers['answer'.$key])) { 
                        $aShowAnswers[$key]['id'] = $key;
                        $aShowAnswers[$key]['answer'] = $answers['answer'.$key];				  
                    }
                }
                
                $answers = $aShowAnswers;
                
                $template = 'type1';
            break;
            case 2:
                $answers = Jelly::select('question_choice')->where('question_id','=',$question->id)->limit(1)->cached(3600)->execute()->as_array();
                Arr::kshuffle($answers);
                
                $aWzor = array(1,2,3,4,5,6,7,8,9,10);
                
                shuffle($aWzor);
                $i = 1;
                
                foreach($aWzor as $val) {
                    $aWzorRandom[$i] = $val;
                    $i++;
                }
                
                Arr::kshuffle($aWzorRandom);
                
                $aShowAnswers = array();
                foreach($aWzorRandom as $key =>  $val) {
                    if(!empty($answers['answer'.$key])) { 
                        $aShowAnswers[$key]['id'] = $key;
                        $aShowAnswers[$key]['answer'] = $answers['answer'.$key];				  
                    }
                }
                
                $answers = $aShowAnswers;
                
                $template = 'type2';
            break;
            case 3:
                $answers = Jelly::select('question_matching')->where('question_id','=',$question->id)->cached(3600)->execute()->as_array();
                
    			$shuffle_match = $answers;
				shuffle($shuffle_match);
                
                for ($i=0, $n = count( $answers ); $i < $n; $i++ ) {
                    $answers[$i]['option_right'] = $shuffle_match[$i]['option_right'];
				}
                
                $template = 'type3';
            break;
            case 4:
                $answers = Jelly::select('question_hotspot')->where('question_id','=',$question->id)->limit(1)->cached(3600)->execute();
                $template = 'type4';
    		break;
    		case 5:
                $answers = Jelly::select('question_boolean')->where('question_id','=',$question->id)->limit(1)->cached(3600)->execute();
                $template = 'type5';
    		break;
            case 6:
                $answers = null;
                $template = 'type6';
            break;
            case 7:
                $answers = Jelly::select('question_list')->where('question_id','=',$question->id)->limit(1)->cached(3600)->execute();
                
                $aShowAnswers = array();
                for($i = 0; $i < $answers->answers; $i++) {
                    $aShowAnswers[] = $i;
                }
                
                $answers = $aShowAnswers;
                
                $template = 'type7';
            break;
            case 9:
                $answers = Jelly::select('question_memory')->where('question_id','=',$question->id)->limit(1)->cached(3600)->execute();
                
                $aShowAnswers = array();
                for($i = 0; $i < $answers->answers; $i++) {
                    $aShowAnswers[] = $i;
                }
                
                $answers = $aShowAnswers;
                
                $template = 'type9';
            break;
            case 10:
                $answers = Jelly::select('question_sort')->where('question_id','=',$question->id)->limit(1)->cached(3600)->execute();
                
                $options = unserialize($answers->good);
                
                $i = 0;
                
                $answer_options = array();
                foreach($options as $option) {
                    $answer_options[] = array(
                        'i'      => $i,
                        'answer' => $option
                    );
                    
                    $i++;
                }
                
                shuffle($answer_options);
                
                $answers = $answer_options;
                
                $template = 'type10';
            break;
        }
        
        return array($answers, $template, $question);
    }
    
    public function stats_question($question, $answer, $is_good, $type, $info = '') {
        $trial = Session::instance()->get('test_trials_'.$this->test_id);
        
        $item = Jelly::select('material_test_stat')
            ->where('course_id', '=', $this->course_id)
            ->where('user_id', '=', Session::instance()->get('auth_user')->id)
            ->where('question_id', '=', $question)
            ->where('trial', '=', $trial)
            ->limit(1)
            ->execute();
  
        if (! $item->loaded())
        {    
            $item = Jelly::factory('material_test_stat');
            $item->set(array(
                'course'          => $this->course_id,
                'user'            => Session::instance()->get('auth_user')->id,
                'question'        => $question,
                'answer'          => serialize($answer),
                'additional_info' => $info,
                'is_good'         => $is_good,
                'type'            => $type,
                'trial'           => $trial
            ));
            $item->save();
        }
        else
        {
            $item->set(array(
                'course'          => $this->course_id,
                'user'            => Session::instance()->get('auth_user')->id,
                'question'        => $question,
                'answer'          => serialize($answer),
                'additional_info' => $info,
                'is_good'         => $is_good,
                'type'            => $type,
                'trial'           => $trial
            ));
            $item->save();
        }
    }
    
    public function finish_test($subscribe) {
        $session_test = Session::instance()->get('test');
        
        $percent = ceil(($session_test['good']*100) / $session_test['test']->questions);
        if ($percent > 100)
        {
            $percent = '100';
        }
            
        $report = Jelly::select('report_test', Session::instance()->get('test_report'));
        $report->score_percent = $percent;
        $report->good = $session_test['good'];
        $report->bad = $session_test['bad'];
        $report->end_on = date('Y-m-d H:i:s');
        $report->save();
        
        $report->duration = $report->end_on - $report->start_on;
        $report->save();
        
        $stat = Jelly::select('material_stat')
            ->where('test_id', '=', $this->test_id)
            ->where('user_id', '=', Session::instance()->get('auth_user')->id)
            ->where('course_id', '=', $this->course_id)
            ->limit(1)
            ->execute();
        
        $stat->score = $percent;
        $stat->end_on = date('Y-m-d H:i:s');       
        
        if($session_test['good'] >= $session_test['test']->questions_to_pass)
        {   
            $report->status = 1;
            $report->save();
            
            $stat->status = 1;
            
            $subscribe->done($material->id);
            $subscribe->update_progress();
        }
        
        $stat->save();
    }
    
    public function finish_exercise($subscribe) {
        $session_test = Session::instance()->get('test');
        
        $stat = Jelly::select('material_stat')
            ->where('test_id', '=', $this->test_id)
            ->where('user_id', '=', Session::instance()->get('auth_user')->id)
            ->where('course_id', '=', $this->course_id)
            ->limit(1)
            ->execute();
        
        $stat->end_on = date('Y-m-d H:i:s');
        $stat->status = 1;
        $stat->save();
        
        $subscribe->done($material->id);
        $subscribe->update_progress();
    }
}