<?php defined('SYSPATH') or die('No direct script access.');

class Relio_Timecode {
	public static function parseInput($input) {
		// timecode should look something like hh:mm:ss;ff
		// allowed separators are : ; . ,
		// values may be single or double digits
		// hours are least-significant -- 5.4 == 00:00:05;04
		$tc = array(
			//'frames'  => '00',
			'seconds' => '00',
			'minutes' => '00', 
			'hours'   => '00'
		);

		$punct = array(
			':',
			';',
			'.',
			','
		);

		// too big? too small?
		$input = trim($input);
		if (strlen($input)>11 || $input=="") {
			// invalid input, too long -- bzzt
			return $tc;
		}

		// normalize punctuation
		$input = str_replace( $punct, ":", $input);
	
		// blow it up and reverse it so frames come first
		$array = explode(":", $input);
		$array = array_reverse($array);
	
		// feed it into the tc array
		$i=0;
		foreach ($tc as $key => $value) {
			if ( is_numeric($array["$i"]) ) {
				$tc["$key"]= $array["$i"];
				if ( $tc["$key"] < 10 && $tc["$key"] > 0 && strlen($tc['key'])==1 ) $tc["$key"]= "0".$tc["$key"];
			}
			$i++;
		}
		
		return $tc;
	}
	
	// array $tc
	// returns a float number of seconds
	//
	public static function tcToSec($tc) {
		$wholeseconds= ($tc['hours']*3600) + ($tc['minutes'] * 60) + ($tc['seconds']);
		$partseconds= ( $tc['frames']  / FRAMESEC );
		$seconds= $wholeseconds + $partseconds;
		return $seconds;
	}
	
	// float $seconds
	// bool $subtract
	// returns a timecode array
	//
	public static function secToTc ($seconds=0, $subtract=0) {
		$tc= array(
			'frames'  => '00', 
			'seconds' => '00',
			'minutes' => '00',
			'hours'   => '00'
		);
	
		$partseconds= fmod($seconds, 1);
		$wholeseconds= $seconds - $partseconds;
	
		// frames
		if ($subtract==1) $tc['frames']= floor( $partseconds * FRAMESEC );
		else $tc['frames']= floor( $partseconds * FRAMESEC );
	
		// hours
		$tc['hours']= floor( $wholeseconds / 3600 );
		$minsec= ($wholeseconds - ($tc['hours'] * 3600));
	
		// minutes
		$tc['minutes']= floor( $minsec / 60 );
	
		// seconds
		$tc['seconds']= ( $minsec - ($tc['minutes'] * 60) );

		// padding
		foreach ( $tc AS $key=>$value ) {
			if ($value > 0 && $value < 10) $tc["$key"]= "0".$value;
			if ($value=="0") $tc["$key"]= "00";
		}

		return $tc;
	}

	// array $tc
	// returns string of well-formed timecode
	//
	public static function tcToString (&$tc) {
		return $tc['hours'].":".$tc['minutes'].":".$tc['seconds'].";".$tc['frames'];
	}
}