<?php

function smarty_function_percentcolor($params, &$smarty) {
    if (!is_numeric($params['percent'])) {
        $smarty->trigger_error("assign: missing 'percent' parameter");
        return;
    }

    $kolory = array();
    /* Generowanie koloru paska (jeżeli nie istnieje w tablicy kolorów) */
    if (empty($kolory[$params['percent']])) {
        if ($params['percent'] < 50) {
            $kolory[$params['percent']] = array(
                'r' => 255,
                'g' => ($params['percent'] * 5),
                'b' => 0
            );
        }
        elseif ($params['percent'] == 50) {
            $kolory[$params['percent']] = array(
                'r' => 255,
                'g' => 255,
                'b' => 0
            );
        }
        else {
            $kolory[$params['percent']] = array(
                'r' => (250 - ($params['percent'] * 5)),
                'g' => 255,
                'b' => 0
            );
        } 
    }

    return $kolory[$params['percent']]['r'].', '.$kolory[$params['percent']]['g'].', '.$kolory[$params['percent']]['b'];
}