<?php

  function scorm_eval_prerequisites ($prerequisites, $usertracks)
  {
    $element = '';
    $stack = array ();
    $statuses = array ('passed' => 'passed', 'completed' => 'completed', 'failed' => 'failed', 'incomplete' => 'incomplete', 'browsed' => 'browsed', 'not attempted' => 'notattempted', 'p' => 'passed', 'c' => 'completed', 'f' => 'failed', 'i' => 'incomplete', 'b' => 'browsed', 'n' => 'notattempted');
    $i = 0;
    while ($i < strlen ($prerequisites))
    {
      $symbol = $prerequisites[$i];
      switch ($symbol)
      {
        case '&':
        {
        }

        case '|':
        {
          $symbol .= $symbol;
        }

        case '~':
        {
        }

        case '(':
        {
        }

        case ')':
        {
        }

        case '*':
        {
          $element = trim ($element);
          if (!empty ($element))
          {
            $element = trim ($element);
            if (isset ($usertracks[$element]))
            {
              $element = '((\'' . $usertracks[$element]->status . '\' == \'completed\') || ' . '(\'' . $usertracks[$element]->status . '\' == \'passed\'))';
            }
            else
            {
              if ($operator = strpos ($element, '=') !== false)
              {
                $item = trim (substr ($element, 0, $operator));
                if (!isset ($usertracks[$item]))
                {
                  return false;
                }

                $value = trim (trim (substr ($element, $operator + 1)), '"');
                if (isset ($statuses[$value]))
                {
                  $status = $statuses[$value];
                }
                else
                {
                  return false;
                }

                $element = '(\'' . $usertracks[$item]->status . '\' == \'' . $status . '\')';
              }
              else
              {
                if ($operator = strpos ($element, '<>') !== false)
                {
                  $item = trim (substr ($element, 0, $operator));
                  if (!isset ($usertracks[$item]))
                  {
                    return false;
                  }

                  $value = trim (trim (substr ($element, $operator + 2)), '"');
                  if (isset ($statuses[$value]))
                  {
                    $status = $statuses[$value];
                  }
                  else
                  {
                    return false;
                  }

                  $element = '(\'' . $usertracks[$item]->status . '\' != \'' . $status . '\')';
                }
                else
                {
                  if (is_numeric ($element))
                  {
                    if ($symbol == '*')
                    {
                      $symbol = '';
                      $open = strpos ($prerequisites, '{', $i);
                      $opened = 1;
                      $closed = 0;
                      $close = $open + 1;
                      while (($closed < $opened AND $close < strlen ($prerequisites)))
                      {
                        if ($prerequisites[$close] == '}')
                        {
                          ++$closed;
                        }
                        else
                        {
                          if ($prerequisites[$close] == '{')
                          {
                            ++$opened;
                          }
                        }

                        ++$close;
                      }

                      $i = $close;
                      $setelements = explode (',', substr ($prerequisites, $open + 1, $close - ($open + 1) - 1));
                      $settrue = 0;
                      foreach ($setelements as $setelement)
                      {
                        if (scorm_eval_prerequisites ($setelement, $usertracks))
                        {
                          ++$settrue;
                          continue;
                        }
                      }

                      if ($element <= $settrue)
                      {
                        $element = 'true';
                      }
                      else
                      {
                        $element = 'false';
                      }
                    }
                  }
                  else
                  {
                    return false;
                  }
                }
              }
            }

            array_push ($stack, $element);
            $element = '';
          }

          if ($symbol == '~')
          {
            $symbol = '!';
          }

          if (!empty ($symbol))
          {
            array_push ($stack, $symbol);
          }

          break;
        }

        default:
        {
          $element .= $symbol;
          break;
        }
      }

      ++$i;
    }

    if (!empty ($element))
    {
      $element = trim ($element);
      if (isset ($usertracks[$element]))
      {
        $element = '((\'' . $usertracks[$element]->status . '\' == \'completed\') || ' . '(\'' . $usertracks[$element]->status . '\' == \'passed\'))';
      }
      else
      {
        if ($operator = strpos ($element, '=') !== false)
        {
          $item = trim (substr ($element, 0, $operator));
          if (!isset ($usertracks[$item]))
          {
            return false;
          }

          $value = trim (trim (substr ($element, $operator + 1)), '"');
          if (isset ($statuses[$value]))
          {
            $status = $statuses[$value];
          }
          else
          {
            return false;
          }

          $element = '(\'' . $usertracks[$item]->status . '\' == \'' . $status . '\')';
        }
        else
        {
          if ($operator = strpos ($element, '<>') !== false)
          {
            $item = trim (substr ($element, 0, $operator));
            if (!isset ($usertracks[$item]))
            {
              return false;
            }

            $value = trim (trim (substr ($element, $operator + 1)), '"');
            if (isset ($statuses[$value]))
            {
              $status = $statuses[$value];
            }
            else
            {
              return false;
            }

            $element = '(\'' . $usertracks[$item]->status . '\' != \'' . trim ($status) . '\')';
          }
          else
          {
            return false;
          }
        }
      }

      array_push ($stack, $element);
    }

    return eval ('return ' . implode ($stack) . ';');
}

function scorm_get_toc ($user, $scorm, $liststyle, $currentorg = '', $scoid = '', $mode = 'normal', $attempt = '', $play = false) {
	$strexpand = 'expcoll';
    $modestr = '';
    if ($mode == 'browse') {
    	$modestr = '&amp;mode=' . $mode;
    }

    $scormpixdir = 'public/design/frontend/scorm/';
    
    $result = new stdClass ();
    $result->toc = '' . '<ul id=\'0\' class=\'' . $liststyle . '\'>';
    $tocmenus = array();
    $result->prerequisites = true;
    $incomplete = false;
    
    $joomla_toc = new stdClass ();
    $joomla_toc->organizationtitle = '';
    $joomla_toc->items = array();
    $organizationsql = '';
    
    if (!empty ($currentorg)) {
        
    	$organizationtitle = Jelly::select('scorm_scoe')
            ->where('scorm', '=', $scorm->id)
            ->where('identifier', '=', $currentorg)
            ->limit(1)
            ->execute();
        
    	if ($organizationtitle->loaded()) {
    		$result->toc .= '' . '	<li>'.$organizationtitle->title. '</li>';
    		$joomla_toc->organizationtitle = $organizationtitle->title;
    		$tocmenus[] = $organizationtitle->title;
		}
	}

    if (empty ($attempt)) {
    	$attempt = scorm_get_last_attempt ($scorm->id, $user);
    }
    
    $result->attemptleft = $scorm->maxattempt - $attempt;
    $builder = Jelly::select('scorm_scoe')->where('scorm', '=', $scorm->id);
    if (!empty ($currentorg)) {
        $builder->where('organization', '=', $currentorg);
    }
    $builder->order_by('id', 'ASC');
    
    $scoes = $builder->execute();
    $statusicon = '';
    $statusicon_txt = '';
    if (!empty ($scoes)) {
    	$usertracks = array();
    	foreach ($scoes as $sco) {
    		if (!empty ($sco->launch)) {
    			if ($usertrack = scorm_get_tracks ($sco->id, $user, $attempt)) {
    				if ($usertrack->status == '') {
    					$usertrack->status = 'notattempted';
					}
					
					$usertracks[$sco->identifier] = $usertrack;
					continue;
				}
				
				continue;
			}
		}
		
		$level = 0;
		$sublist = 1;
		$previd = 0;
		$nextid = 0;
		$findnext = false;
		$parents[$level] = '/';
		
		foreach ($scoes as $sco) {
			$isvisible = false;
			if ($optionaldatas = scorm_get_sco ($sco->id, SCO_DATA)) {
				if ((!isset ($optionaldatas->isvisible) OR (isset ($optionaldatas->isvisible) AND $optionaldatas->isvisible == 'true'))) {
					$isvisible = true;
				}
			}
			
			if ($parents[$level] != $sco->parent) {
				if ($newlevel = array_search ($sco->parent, $parents)) {
					$i = 0;
					while ($i < $level - $newlevel) {
						$result->toc .= '		</ul></li>';
						++$i;
					}
					
					$level = $newlevel;
				}
				else {
					$i = $level;
					$closelist = '';
					while ((0 < $i AND $parents[$level] != $sco->parent)) {
						$closelist .= '		</ul></li>';
						--$i;
					}
					
					if (($i == 0 AND $sco->parent != $currentorg)) {
						$style = '';
						if (isset ($_COOKIE['hide:SCORMitem' . $sco->id])) {
							$style = ' style="display: none;"';
						}
						
						$result->toc .= ('' . '	') . '	<li><ul id=\'' . $sublist . '\' class=\'' . $liststyle . '\'' . $style . '>';
						++$level;
					}
					else {
						$result->toc .= $closelist;
						$level = $i;
					}
					
					$parents[$level] = $sco->parent;
				}
			}
			
			if ($isvisible) {
				$result->toc .= '		<li>';
			}
			
			$nextsco = next($scoes);
            //$nextsco = $scoes->next();
			$nextisvisible = false;
			
			if (($nextsco !== false AND $optionaldatas = scorm_get_sco ($nextsco->id, SCO_DATA))) {
				if ((!isset ($optionaldatas->isvisible) OR (isset ($optionaldatas->isvisible) AND $optionaldatas->isvisible == 'true'))) {
					$nextisvisible = true;
				}
			}
			
			if (((($nextisvisible AND $nextsco !== false) AND $sco->parent != $nextsco->parent) AND ($level == 0 OR (0 < $level AND $nextsco->parent == $sco->identifier)))) {
				++$sublist;
				$icon = 'minus';
				
				if (isset ($_COOKIE['hide:SCORMitem' . $nextsco->id])) {
					$icon = 'plus';
				}
				
				$result->toc .= '<a href="javascript:expandCollide(\'img' . $sublist . '\',' . $sublist . ',' . $nextsco->id . ');"><img id="img' . $sublist . '" src="' . $scormpixdir . '/' . $icon . '.gif" alt="' . $strexpand . '" title="' . $strexpand . '" border="0"/></a>';
			}
			else {
				if ($isvisible) {
					$result->toc .= '<img src="' . $scormpixdir . '/spacer.gif" />';
				}
			}
			
			if (empty ($sco->title)) {
				$sco->title = $sco->identifier;
			}
			
			if (!empty ($sco->launch)) {
				if ($isvisible) {
					$startbold = '';
					$endbold = '';
					$score = '';
					if ((empty ($scoid) AND $mode != 'normal')) {
						$scoid = $sco->id;
					}
					
					if (isset ($usertracks[$sco->identifier])) {
						$usertrack = $usertracks[$sco->identifier];
						$strstatus = $usertrack->status;
						if ($sco->scormtype == 'sco') {
							$statusicon = '<img src="' . $scormpixdir . '/' . $usertrack->status . '.gif" alt="' . $strstatus . '" title="' . $strstatus . '" />';
							$statusicon_txt = $usertrack->status;
						}
						else {
							$tmp_alt = 'assetlaunched';
							$statusicon = '<img src="' . $scormpixdir . '/assetc.gif" alt="' . $tmp_alt . '" title="' . $tmp_alt . '" />';
							$statusicon_txt = 'assetc';
						}
						
						if ((($usertrack->status == 'notattempted' OR $usertrack->status == 'incomplete') OR $usertrack->status == 'browsed')) {
							$incomplete = true;
							if (($play AND empty ($scoid))) {
								$scoid = $sco->id;
							}
						}
						
						if ($usertrack->score_raw != '') {
							$tmp_score_str = 'score';
							$score = '(' . $tmp_score_str . ':&nbsp;' . $usertrack->score_raw . ')';
						}
						
						$strsuspended = 'suspended';
						if ((isset ($usertrack->{'cmi.core.exit'}) AND $usertrack->{'cmi.core.exit'} == 'suspend')) {
							$statusicon = '<img src="' . $scormpixdir . '/suspend.gif" alt="' . $strstatus . ' - ' . $strsuspended . '" title="' . $strstatus . ' - ' . $strsuspended . '" />';
							$statusicon_txt = 'suspend';
						}
					}
					else {
						if (($play AND empty ($scoid))) {
							$scoid = $sco->id;
						}
						
						if ($sco->scormtype == 'sco') {
							$tmp_alt = 'notattempted';
							$statusicon = '<img src="' . $scormpixdir . '/notattempted.gif" alt="' . $tmp_alt . '" title="' . $tmp_alt . '" />';
							$statusicon_txt = 'notattempted';
							$incomplete = true;
						}
						else {
							$tmp_alt = 'asset';
							$statusicon = '<img src="' . $scormpixdir . '/asset.gif" alt="' . $tmp_alt . '" title="' . $tmp_alt . '" />';
							$statusicon_txt = 'asset';
						}
					}
					
					if ($sco->id == $scoid) {
						$scodata = scorm_get_sco ($sco->id, SCO_DATA);
						$startbold = '<b>';
						$endbold = '</b>';
						$findnext = true;
						$shownext = (isset ($scodata->next) ? $scodata->next : 0);
						$showprev = (isset ($scodata->previous) ? $scodata->previous : 0);
					}
					
					if (((($nextid == 0 AND 1 < scorm_count_launchable ($scorm->id, $currentorg)) AND $nextsco !== false) AND !$findnext)) {
						if (!empty ($sco->launch)) {
							$previd = $sco->id;
						}
					}
					
					if ((empty ($sco->prerequisites) OR scorm_eval_prerequisites ($sco->prerequisites, $usertracks))) {
						if ($sco->id == $scoid) {
							$result->prerequisites = true;
						}
						
						//$url = sefreltoabs ('' . 'index.php?option=' . $option . '&amp;Itemid=' . $Itemid . '&amp;task=player_scorm&amp;id=' . $scorm->id . '&amp;scoid=' . $sco->id . $modestr . '&amp;currentorg=' . $currentorg);
						$result->toc .= $statusicon . '&nbsp;' . $startbold . '<a href="' . $url . '">' . $sco->title . '</a>' . $score . $endbold . '</li>';
						$is_bold = ($startbold ? true : false);
						
						$joomla_toc->items[] = array(
							'name'       => $sco->title,
							'img'        => $statusicon,
							'img_src'    => $statusicon_txt,
							'href'       => true,
							'bold'       => $is_bold,
							'level'      => $level,
							'scoid'      => $sco->id,
							'currentorg' => $currentorg
						);
						
						$tocmenus[$sco->id] = scorm_repeater ('&minus;', $level) . '&gt;' . $sco->title;
					}
					else {
						if ($sco->id == $scoid) {
							$result->prerequisites = false;
						}
						
						$result->toc .= $statusicon . '&nbsp;' . $sco->title . '</li>';
						
						$joomla_toc->items[] = array(
							'name'       => $sco->title,
							'img'        => $statusicon,
							'img_src'    => $statusicon_txt,
							'href'       => false,
							'bold'       => false,
							'level'      => $level,
							'scoid'      => '',
							'currentorg' => ''
						);
					}
				}
			}
			else {
				$result->toc .= '&nbsp;' . $sco->title . '</li>';
				$joomla_toc->items[] = array(
					'name'       => $sco->title,
					'img'        => '',
					'img_src'    => '',
					'href'       => false,
					'bold'       => true,
					'level'      => $level,
					'scoid'      => '',
					'currentorg' => ''
				);
			}
			
			if ((($nextsco !== false AND $nextid == 0) AND $findnext)) {
				if (!empty ($nextsco->launch)) {
					$nextid = $nextsco->id;
					continue;
				}
				
				continue;
			}
		}
		
		$i = 0;
		while ($i < $level) {
			$result->toc .= '		</ul></li>';
			++$i;
		}
		
		if ($play) {
			$sco = scorm_get_sco ($scoid);
			$sco->previd = $previd;
			$sco->nextid = $nextid;
			$result->sco = $sco;
			$result->incomplete = $incomplete;
		}
		else {
			$result->incomplete = $incomplete;
		}
	}
	
	$result->toc .= '	</ul>';
	if ($scorm->hidetoc == 0) {
		$result->toc .= '
		<script type="text/javascript">
		//<![CDATA[
		function expandCollide(which,list,item) {
			var nn=document.ids?true:false
			var w3c=document.getElementById?true:false
			var beg=nn?"document.ids.":w3c?"document.getElementById(":"document.all.";
			var mid=w3c?").style":".style";
			
			if (eval(beg+list+mid+".display") != "none") {
				which.src = "' . $scormpixdir . '/plus.gif";
				eval(beg+list+mid+".display=\'none\';");
				new cookie("hide:SCORMitem" + item, 1, 356, "/").set();
			} else {
				which.src = "' . $scormpixdir . '/minus.gif";
				eval(beg+list+mid+".display=\'block\';");
				new cookie("hide:SCORMitem" + item, 1, -1, "/").set();
			}
		}
		//]]>
		</script>' . '';
	}
	
	$result->tocmenu = '';
    $result->joomla_toc = $joomla_toc;
    
    return $result;
}

?>