<?php
function scorm_seq_evaluate ($scoid, $usertracks) {
	return true;
}

function scorm_seq_overall ($scoid, $userid, $request,$attempt) {
	$seq = scorm_seq_navigation ($scoid, $userid, $request,$attempt);
	if ($seq->navigation) {
		if ($seq->termination != null) {
			$seq = scorm_seq_termination ($scoid, $userid, $seq);
		}
		
		if ($seq->sequencing != null) {
			//$seq = scorm_seq_sequencing($scoid,$userid,$seq);
			if($seq->sequencing == 'exit'){//return the control to the LTS
				return 'true';
			}
		}
        if ($seq->delivery != null) {
            //$seq = scorm_sequencing_delivery($scoid,$userid,$seq);
			//$seq = scorm_content_delivery_environment ($seq,$userid);
        }
	}

    if ($seq->exception != null) {
    }

    return 'true';
}

function scorm_seq_navigation ($scoid, $userid, $request, $attempt=0) {
	$seq = new stdClass ();
	$seq->currentactivity = scorm_get_sco($scoid);
	$seq->traversaldir = null;
	$seq->nextactivity = null;
	$seq->deliveryvalid = null;
	$seq->attempt = $attempt;
	
    $seq->identifiedactivity = null;
	$seq->delivery = null;
	$seq->deliverable = false;
    $seq->active = scorm_seq_is('active',$scoid,$userid);
    $seq->suspended = scorm_seq_is('suspended',$scoid,$userid);
    $seq->navigation = null;
    $seq->termination = null;
    $seq->sequencing = null;
    $seq->target = null;
	$seq->endsession = null;
    $seq->exception = null;
	$seq->reachable = true;
	$seq->prevact = true;
	
	switch ($request) {
	   case 'start_':
			if (empty ($seq->currentactivity)) {
				$seq->navigation = true;
				$seq->sequencing = 'start';
			}
	        else {
	        	$seq->exception = 'NB.2.1-1';
	        }
       break;
       case 'resumeall_':
            if (empty ($seq->currentactivity)) {
                $track = Jelly::select('scorm_scoe_track')
                    ->where('scoid', '=', $scoid)
                    ->where('userid', '=', $userid)
                    ->where('name', '=', 'suspendedactivity')
                    ->limit(1)
                    ->execute();

	        	if ($track->loaded()) {
	        		$seq->navigation = true;
	        		$seq->sequencing = 'resumeall';
	    		}
	    		else {
	    			$seq->exception = 'NB.2.1-3';
				}
			}
	        else {
	        	$seq->exception = 'NB.2.1-1';
	    	}
    	break;
    	case 'continue_':
    	case 'previous_':
	    	if (!empty ($seq->currentactivity)) {
	    		$sco = $seq->currentactivity;
	    		if ($sco->parent != '/') {
	    			if ($parentsco = scorm_get_parent ($sco)) {
	    				if ((isset ($parentsco->flow) AND $parent->flow == true)) {
	    					if ($request == 'continue_') {
	    						$seq->navigation = true;
	    						$seq->termination = 'exit';
	    						$seq->sequencing = 'continue';
							}
							else {
								if ((isset ($parentsco->forwardonly) AND $parent->forwardolny == false)) {
									$seq->navigation = true;
									$seq->termination = 'exit';
									$seq->sequencing = 'previous';
								}
								else {
									$seq->exception = 'NB.2.1-5';
								}
							}
						}
					}
				}
			}
	        else {
	        	$seq->exception = 'NB.2.1-2';
	        }
        break;
        case 'forward_':
        case 'backward_':
        	$seq->exception = 'NB.2.1-7';
        break;
        case 'exit_':
        case 'abandon_':
	        if (!empty ($seq->currentactivity)) {
	        	$seq->navigation = true;
	        	$seq->termination = substr($request,0,-1);
	        	$seq->sequencing = 'exit';
	    	}
	        else {
	        	$seq->exception = 'NB.2.1-2';
	        }
	    case 'exitall_':
	    case 'abandonall_':
	    case 'suspendall_':
		    if (!empty ($seq->currentactivity)) {
		    	$seq->navigation = true;
		    	$seq->termination = substr($request,0,-1);
		    	$seq->sequencing = 'exit';
	    	}
	        else {
	        	$seq->exception = 'NB.2.1-2';
	    	}
    	break;
    	default:
            $targetsco = Jelly::select('scorm_scoe')
                ->where('scorm', '=', $sco->scorm)
                ->where('identifier', '=', $request)
                ->limit(1)
                ->execute();
                
            if ($targetsco->loaded()) {
            	if ($targetsco->parent != '/') {
            		$seq->target = $request;
        		}
        		else {
        			if ($parentsco = scorm_get_parent ($targetsco)) {
        				if (!isset($parentsco->choice) || ($parent->choice == true)) {
        					$seq->target = $request;
    					}
    				}
    			}
    			
    			if ($seq->target != null) {
    				if (empty ($seq->currentactivity)) {
    					$seq->navigation = true;
    					$seq->sequencing = 'choice';
    				}
    				else {
    					if (!$sco = scorm_get_sco ($scoid)) {
    						return $seq;
    					}
    					
    					if ($sco->parent != $target->parent) {
    						$ancestors = scorm_get_ancestors ($sco);
    						$commonpos = scorm_find_common_ancestor ($ancestors, $targetsco);
    						if ($commonpos !== false) {
    							if ($activitypath = array_slice ($ancestors, 0, $commonpos)) {
    								foreach ($activitypath as $activity) {
    									if ((scorm_seq_is ('active', $activity->id, $userid) AND (isset ($activity->choiceexit) AND $activity->choiceexit == false))) {
    										$seq->navigation = false;
    										$seq->termination = null;
    										$seq->sequencing = null;
    										$seq->target = null;
    										$seq->exception = 'NB.2.1-8';
    										return $seq;
    									}
    								}
    							}
    							else {
    								$seq->navigation = false;
    								$seq->termination = null;
    								$seq->sequencing = null;
    								$seq->target = null;
    								$seq->exception = 'NB.2.1-9';
    							}
    						}
    					}
    					
    					$seq->navigation = true;
    					$seq->sequencing = 'choice';
    				}
    			}
    			else {
    				$seq->exception = 'NB.2.1-10';
    			}
    		}
            else {
            	$seq->exception = 'NB.2.1-11';
            }
        
        break;
    }
    
    return $seq;
}

function scorm_seq_termination ($seq, $userid) {
	if (empty ($seq->currentactivity)) {
		$seq->termination = false;
		$seq->exception = 'TB.2.3-1';
		
		return $seq;
	}
	
	$sco = $seq->currentactivity;
    if ((($seq->termination == 'exit' OR $seq->termination == 'abandon') AND !$seq->active)) {
    	$seq->termination = false;
    	$seq->exception = 'TB.2.3-2';
    	
    	return $seq;
    }
    
    switch ($seq->termination) {
    	case 'exit':
    		scorm_seq_end_attempt ($sco, $userid);
    		$seq = scorm_seq_exit_action_rules ($seq, $userid);
    		do {
    			$exit = false;// I think this is false. Originally this was true
    			$seq = scorm_seq_post_cond_rules ($seq, $userid);
    			if ($seq->termination == 'exitparent') {
    				if ($sco->parent != '/') {
    					$sco = scorm_get_parent ($sco);
    					$seq->currentactivity = $sco;
    					$seq->active = scorm_seq_is ('active', $sco->id, $userid);
    					scorm_seq_end_attempt ($sco, $userid);
    					$exit = true;//I think it's true. Originally this was false
    					continue;
					}
					else {
						$seq->termination = false;
						$seq->exception = 'TB.2.3-4';
						return $seq;
					}
				}
			} while (!(($exit == false AND $seq->termination == 'exit')));
			if ($seq->termination == 'exit') {
				$seq->termination = true;
				return $seq;
			}
		case 'exitall':
			if ($seq->active) {
				scorm_seq_end_attempt ($sco, $userid);
			}
			
			if ($ancestors = scorm_get_ancestors ($sco)) {
				foreach ($ancestors as $ancestor) {
					scorm_seq_end_attempt ($ancestor, $userid);
					$seq->currentactivity = $ancestor;
				}
			}
			
			$seq->active = scorm_seq_is ('active', $seq->currentactivity->id, $userid);
			$seq->termination = true;
			$seq->sequencing = exit;
        break;
        case 'suspendall':
        	if (($seq->active OR $seq->suspended)) {
        		scorm_seq_set ('suspended', $sco->id, $userid);
    		}
    		else {
    			if ($sco->parent != '/') {
    				$parentsco = scorm_get_parent ($sco);
    				scorm_seq_set ('suspended', $parentsco->id, $userid);
				}
				else {
					$seq->termination = false;
					$seq->exception = 'TB.2.3-3';
				}
			}
			
			if ($ancestors = scorm_get_ancestors ($sco)) {
				foreach ($ancestors as $ancestor) {
					scorm_seq_set ('active', $ancestor->id, $userid, 0, false);
					scorm_seq_set ('suspended', $ancestor->id, $userid);
					$seq->currentactivity = $ancestor;
				}
				
				$seq->termination = true;
				$seq->sequencing = 'exit';
			}
			else {
				$seq->termination = false;
				$seq->exception = 'TB.2.3-5';
			}
		break;
		case 'abandon':
			scorm_seq_set ('active', $sco->id, $userid, 0, false);
        	$seq->active = null;
        	$seq->termination = true;
        break;
        case 'abandonall':
        	if ($ancestors = scorm_get_ancestors ($sco)) {
        		foreach ($ancestors as $ancestor) {
        			scorm_seq_set ('active', $ancestor->id, $userid, 0, false);
        			$seq->currentactivity = $ancestor;
    			}
    			
    			$seq->termination = true;
    			$seq->sequencing = 'exit';
			}
			else {
				$seq->termination = false;
				$seq->exception = 'TB.2.3-6';
			}
		break;
		default:
			$seq->termination = false;
	        $seq->exception = 'TB.2.3-7';
        break;
    }
    
    return $seq;
}

function scorm_seq_end_attempt ($sco, $userid) {
	if (scorm_is_leaf ($sco)) {
		if ((!isset ($sco->tracked) OR $sco->tracked == 1)) {
			if (!scorm_seq_is ('suspended', $sco->id, $userid)) {
				if ((!isset ($sco->completionsetbycontent) OR $sco->completionsetbycontent == 0)) {
					if (!scorm_seq_is ('attemptprogressstatus', $sco->id, $userid, $attempt)) {
						scorm_seq_set ('attemptprogressstatus', $sco->id, $userid, $attempt);
						scorm_seq_set ('attemptcompletionstatus', $sco->id, $userid, $attempt);
					}
				}
				
				if ((!isset ($sco->objectivesetbycontent) OR $sco->objectivesetbycontent == 0)) {
					if ($sco->objectives) {
						foreach ($objectives as $objective) {
							if ($objective->primary) {
								if (!scorm_seq_objective_progress_status ($sco, $userid, $objective)) {
									scorm_seq_set ('objectiveprogressstatus', $sco->id, $userid, $attempt);
									scorm_seq_set ('objectivesatisfiedstatus', $sco->id, $userid, $attempt);
									continue;
								}
								
								continue;
							}
						}
					}
				}
			}
		}
	}
    else {
    	if ($children = scorm_get_children ($sco)) {
    		$suspended = false;
    		foreach ($children as $child) {
    			if (scorm_seq_is ('suspended', $child, $userid)) {
    				$suspended = true;
    				break;
				}
			}
			
			if ($suspended) {
				scorm_seq_set ('suspended', $sco, $userid);
			}
			else {
				scorm_seq_set ('suspended', $sco, $userid, 0, false);
			}
		}
	}
	
	scorm_seq_set ('active', $sco, $userid, 0, false);
    scorm_seq_overall_rollup ($sco, $userid);
}
  
function scorm_seq_is ($what, $scoid, $userid, $attempt = 0) {
	$active = false;
    
	$track = Jelly::select('scorm_scoe_track')
        ->where('scoid', '=', $scoid)
        ->where('userid', $userid)
        ->where('element', '=', $what)
        ->limit(1)
        ->execute();
        
	if ($track->loaded()) {
		$active = true;
	}
	
	return $active;
}

function scorm_seq_set($what, $scoid, $userid, $attempt = 0, $value = 'true') {
    $sco = scorm_get_sco ($scoid);
    if ($value == false) {
        DB::delete('jos_lms_n_scorm_scoes_track')
            ->where('scoid', '=', $scoid)
            ->where('userid', '=', $userid)
            ->where('element', '=', $what)
            ->execute();
            
		return null;
    }
    else {
    	scorm_insert_track ($userid, $sco->scorm, $sco->id, 0, $what, $value);
    }
    
    // update grades in gradebook
    //$scorm = get_record('scorm', 'id', $sco->scorm);
    //scorm_update_grades($scorm, $userid, true);
}

function scorm_seq_exit_action_rules ($seq, $userid) {
	$sco = $seq->currentactivity;
    $ancestors = scorm_get_ancestors ($sco);
    $exittarget = null;
    foreach (array_reverse ($ancestors) as $ancestor) {
    	if (scorm_seq_rules_check ($ancestor, 'exit') != null) {
    		$exittarget = $ancestor;
    		break;
    	}
	}
	
	if ($exittarget != null) {
		$commons = array_slice ($ancestors, 0, scorm_find_common_ancestor ($ancestors, $exittarget));
		if ($commons) {
			foreach ($commons as $ancestor) {
				scorm_seq_end_attempt ($ancestor, $userid);
				$seq->currentactivity = $ancestor;
			}
		}
	}
	
	return $seq;
}

function scorm_seq_post_cond_rules ($seq, $userid) {
	$sco = $seq->currentactivity;
	if (!$seq->suspended) {
		if ($action = scorm_seq_rules_check ($sco, 'post') != null) {
			switch ($action) {
				case 'retry':
				case 'continue':
				case 'previous':
					$seq->sequencing = $action;
				break;
				case 'exitparent':
				case 'exitall':
					$seq->termination = $action;
				break;
				case 'retryall':
					$seq->termination = 'exitall';
					$seq->sequencing = 'retry';
				break;
			}
		}
	}
	
	return $seq;
}