<?php
define('GRADESCOES', '0');
define('GRADEHIGHEST', '1');
define('GRADEAVERAGE', '2');
define('GRADESUM', '3');
define('GRADEPERCENT', '4');

define('HIGHESTATTEMPT', '0');
define('AVERAGEATTEMPT', '1');
define('FIRSTATTEMPT', '2');
define('LASTATTEMPT', '3');

function scorm_grade_user($scorm, $userid, $time=false) {
    // this treatment is necessary as the whatgrade field was not in the DB
    // and so whatgrade and grademethod are combined in grademethod 10s are whatgrade
    // and 1s are grademethod
    $whatgrade = intval($scorm->grademethod / 10);

    // insure we dont grade user beyond $scorm->maxattempt settings
    $lastattempt = scorm_get_last_attempt($scorm->id, $userid);
    if($scorm->maxattempt != 0 && $lastattempt >= $scorm->maxattempt){
        $lastattempt = $scorm->maxattempt;
    }

    switch ($whatgrade) {
        case FIRSTATTEMPT:
            return scorm_grade_user_attempt($scorm, $userid, 1, $time);
        break;
        case LASTATTEMPT:
            return scorm_grade_user_attempt($scorm, $userid, scorm_get_last_attempt($scorm->id, $userid), $time);
        break;
        case HIGHESTATTEMPT:
            $maxscore = 0;
            $attempttime = 0;
            for ($attempt = 1; $attempt <= $lastattempt; $attempt++) {
                $attemptscore = scorm_grade_user_attempt($scorm, $userid, $attempt, $time);
                if ($time) {
                    if ($attemptscore->score > $maxscore) {
                        $maxscore = $attemptscore->score;
                        $attempttime = $attemptscore->time;
                    }
                } else {
                    $maxscore = $attemptscore > $maxscore ? $attemptscore: $maxscore;
                }
            }
            if ($time) {
                $result = new stdClass();
                $result->score = $maxscore;
                $result->time = $attempttime;
                return $result;
            } else {
               return $maxscore;
            }
        break;
        case AVERAGEATTEMPT:
            $lastattempt = scorm_get_last_attempt($scorm->id, $userid);
            $sumscore = 0;
            for ($attempt = 1; $attempt <= $lastattempt; $attempt++) {
                $attemptscore = scorm_grade_user_attempt($scorm, $userid, $attempt, $time);
                if ($time) {
                    $sumscore += $attemptscore->score;
                } else {
                    $sumscore += $attemptscore;
                }
            }

            if ($lastattempt > 0) {
                $score = $sumscore / $lastattempt;
            } else {
                $score = 0;
            }

            if ($time) {
                $result = new stdClass();
                $result->score = $score;
                $result->time = $attemptscore->time;
                return $result;
            } else {
               return $score;
            }
        break;
    }
}

 /**
* Build up the JavaScript representation of an array element
*
* @param string $sversion SCORM API version
* @param array $userdata User track data
* @param string $element_name Name of array element to get values for
* @param array $children list of sub elements of this array element that also need instantiating
* @return None
*/
function scorm_reconstitute_array_element($sversion, $userdata, $element_name, $children) {
    // reconstitute comments_from_learner and comments_from_lms
    $current = '';
    $current_subelement = '';
    $current_sub = '';
    $count = 0;
    $count_sub = 0;

    // filter out the ones we want
    $element_list = array();
    foreach($userdata as $element => $value){
        if (substr($element,0,strlen($element_name)) == $element_name) {
            $element_list[$element] = $value;
        }
    }

    // sort elements in .n array order
    uksort($element_list, "scorm_element_cmp");

    // generate JavaScript
    foreach($element_list as $element => $value){
        if ($sversion == 'scorm_13') {
            $element = preg_replace('/\.(\d+)\./', ".N\$1.", $element);
            preg_match('/\.(N\d+)\./', $element, $matches);
        } else {
            $element = preg_replace('/\.(\d+)\./', "_\$1.", $element);
            preg_match('/\_(\d+)\./', $element, $matches);
        }
        if (count($matches) > 0 && $current != $matches[1]) {
            if ($count_sub > 0) {
                echo '    '.$element_name.'_'.$current.'.'.$current_subelement.'._count = '.$count_sub.";\n";
            }
            $current = $matches[1];
            $count++;
            $current_subelement = '';
            $current_sub = '';
            $count_sub = 0;
            $end = strpos($element,$matches[1])+strlen($matches[1]);
            $subelement = substr($element,0,$end);
            echo '    '.$subelement." = new Object();\n";
            // now add the children
            foreach ($children as $child) {
                echo '    '.$subelement.".".$child." = new Object();\n";
                echo '    '.$subelement.".".$child."._children = ".$child."_children;\n";
            }
        }

        // now - flesh out the second level elements if there are any
        if ($sversion == 'scorm_13') {
            $element = preg_replace('/(.*?\.N\d+\..*?)\.(\d+)\./', "\$1.N\$2.", $element);
            preg_match('/.*?\.N\d+\.(.*?)\.(N\d+)\./', $element, $matches);
        } else {
            $element = preg_replace('/(.*?\_\d+\..*?)\.(\d+)\./', "\$1_\$2.", $element);
            preg_match('/.*?\_\d+\.(.*?)\_(\d+)\./', $element, $matches);
        }

        // check the sub element type
        if (count($matches) > 0 && $current_subelement != $matches[1]) {
            if ($count_sub > 0) {
                echo '    '.$element_name.'_'.$current.'.'.$current_subelement.'._count = '.$count_sub.";\n";
            }
            $current_subelement = $matches[1];
            $current_sub = '';
            $count_sub = 0;
            $end = strpos($element,$matches[1])+strlen($matches[1]);
            $subelement = substr($element,0,$end);
            echo '    '.$subelement." = new Object();\n";
        }

        // now check the subelement subscript
        if (count($matches) > 0 && $current_sub != $matches[2]) {
            $current_sub = $matches[2];
            $count_sub++;
            $end = strrpos($element,$matches[2])+strlen($matches[2]);
            $subelement = substr($element,0,$end);
            echo '    '.$subelement." = new Object();\n";
        }

        echo '    '.$element.' = \''.$value."';\n";
    }
    if ($count_sub > 0) {
        echo '    '.$element_name.'_'.$current.'.'.$current_subelement.'._count = '.$count_sub.";\n";
    }
    if ($count > 0) {
        echo '    '.$element_name.'._count = '.$count.";\n";
    }
}

/**
* Build up the JavaScript representation of an array element
*
* @param string $a left array element
* @param string $b right array element
* @return comparator - 0,1,-1
*/
function scorm_element_cmp($a, $b) {
    preg_match('/.*?(\d+)\./', $a, $matches);
    $left = intval($matches[1]);
    preg_match('/.?(\d+)\./', $b, $matches);
    $right = intval($matches[1]);
    if ($left < $right) {
        return -1; // smaller
    } elseif ($left > $right) {
        return 1;  // bigger
    } else {
        // look for a second level qualifier eg cmi.interactions_0.correct_responses_0.pattern
        if (preg_match('/.*?(\d+)\.(.*?)\.(\d+)\./', $a, $matches)) {
            $leftterm = intval($matches[2]);
            $left = intval($matches[3]);
            if (preg_match('/.*?(\d+)\.(.*?)\.(\d+)\./', $b, $matches)) {
                $rightterm = intval($matches[2]);
                $right = intval($matches[3]);
                if ($leftterm < $rightterm) {
                    return -1; // smaller
                } elseif ($leftterm > $rightterm) {
                    return 1;  // bigger
                } else {
                    if ($left < $right) {
                        return -1; // smaller
                    } elseif ($left > $right) {
                        return 1;  // bigger
                    }
                }
            }
        }
        // fall back for no second level matches or second level matches are equal
        return 0;  // equal to
    }
}

function scorm_get_sco ($id, $what = SCO_ALL) {
    $sco = Jelly::select('scorm_scoe', $id);
    if ($sco->loaded()) {
        $sco = ($what == SCO_DATA ? new stdClass () : $sco);
		$sco->scodata = new stdClass();
		
        if ($what != SCO_ONLY) {
            $scodatas = Jelly::select('scorm_scoe_data')
                ->where('scoid', '=', $id)
                ->execute();
                
    		foreach ($scodatas as $scodata) {
    			$sco->scodata->name = $scodata->value;
			}
		}
		
		return $sco;
	}
	
	return false;
}


function scorm_insert_track ($userid, $scormid, $scoid, $attempt, $element, $value) {
    $id = null;
    
    $track = Jelly::select('scorm_scoe_track')
        ->where('userid', '=', $userid)
        ->where('scormid', '=', $scormid)
        ->where('scoid', '=', $scoid)
        ->where('attempt', '=', $attempt)
        ->where('element', '=', $element)
        ->limit(1)
        ->execute();

    if ($track->loaded()) {
    	$track->value = $value;
    	$track->timemodified = time ();
        $track->save();
        
    	$id = $track->id;
	}
    else {
        $track = Jelly::factory('scorm_scoe_track');
        $track->userid = $userid;
    	$track->scormid = $scormid;
    	$track->scoid = $scoid;
    	$track->attempt = $attempt;
    	$track->element = $element;
    	$track->value = addslashes ($value);
    	$track->timemodified = time ();
        $track->save();
        
        $id = $track->id;
	}
    
    if (strstr($element, '.score.raw') || (($element == 'cmi.core.lesson_status' || $element == 'cmi.completion_status') && ($track->value == 'completed' || $track->value == 'passed'))) {
        $track = Jelly::select('scorm', $scormid);
        
        //$scorm = get_record('scorm', 'id', $scormid);
        //$grademethod = $scorm->grademethod % 10;
        //include_once('lib.php');
        //scorm_update_grades($scorm, $userid);
    }

    return $id;
}

function scorm_simple_play ($scorm, $user) {
	global $JLMS_DB;
    
	$result = false;
    $query = '' . 'SELECT * FROM #__lms_n_scorm_scoes WHERE scorm = ' . $scorm->id . ' AND launch<>\'\'';
    $JLMS_DB->SetQuery ($query);
    $scoes = $JLMS_DB->LoadObjectList ();
    if (!empty ($scoes))
    {
      if (count ($scoes) == 1)
      {
        if (1 <= $scorm->skipview)
        {
          $sco = current ($scoes);
          global $option;
          global $Itemid;
          if (scorm_get_tracks ($sco->id, $user->id) === false)
          {
            jlmsredirect (sefreltoabs ('' . 'index.php?option=' . $option . '&Itemid=' . $Itemid . '&task=player_scorm&id=' . $scorm->id . '&scoid=' . $sco->id));
            $result = true;
          }
          else
          {
            if ($scorm->skipview == 2)
            {
              jlmsredirect (sefreltoabs ('' . 'index.php?option=' . $option . '&Itemid=' . $Itemid . '&task=player_scorm&id=' . $scorm->id . '&scoid=' . $sco->id));
              $result = true;
            }
          }
        }
      }
    }

    return $result;
}

function scorm_repeater ($what, $times) {
	if ($times <= 0) {
		return null;
	}

    $return = '';
    $i = 0;
    while ($i < $times) {
    	$return .= $what;
    	++$i;
	}
	
	return $return;
}

function scorm_get_last_attempt ($scormid, $userid) {
	$lastattempt = DB::select(DB::expr('MAX(attempt) AS a'))
        ->from('jos_lms_n_scorm_scoes_track')
        ->where('userid', '=', $userid)
        ->where('scormid', '=', $scormid)
        ->execute()
        ->get('a');
        
    if (!$lastattempt) {
    	return '1';
    }
    
    return $lastattempt;
}

function scorm_count_launchable ($scormid, $organization = '') {
    $builder = DB::select(DB::expr('COUNT(*) AS mycount'))
        ->from('jos_lms_n_scorm_scoes')
        ->where('scorm', '=', $scormid)
        ->where('launch', '<>', '');
        
    if (!empty ($organization)) {
        $builder->where('organization', '=', $organization);
	}
    
    $record_count = $builder->execute()
        ->get('mycount');
    
    if (!$record_count) {
    	$record_count = 0;
    }
    
    return $record_count;
}

function scorm_get_tracks($scoid, $userid, $attempt = '') {
	if (empty ($attempt)) {
        $scoe = Jelly::select('scorm_scoe', $scoid);
        $scormid = $scoe->scorm;
        
		if ($scormid) {
			$attempt = scorm_get_last_attempt ($scormid, $userid);
		}
		else {
			$attempt = 1;
		}
	}
	
    $tracks = Jelly::select('scorm_scoe_track')
        ->where('userid', '=', $userid)
        ->where('scoid', '=', $scoid)
        ->where('attempt', '=', $attempt)
        ->order_by('element', 'ASC')
        ->execute();
       
    if ($tracks->count()) {
		$usertrack = new stdClass();
    	$usertrack->userid = $userid;
    	$usertrack->scoid = $scoid;
    	$usertrack->score_raw = '';
    	$usertrack->user_score = '';
    	$usertrack->status = '';
    	$usertrack->total_time = '00:00:00';
    	$usertrack->session_time = '00:00:00';
    	$usertrack->timemodified = 0;
    	foreach ($tracks as $track) {
    		$element = $track->element;
    		$usertrack->{$element} = $track->value;
    		switch ($element) {
    			case 'x.start.time':
    				$usertrack->x_start_time = $track->value;
                break;
	        	case 'cmi.core.lesson_status':
	        	case 'cmi.completion_status':
	        		if ($track->value == 'not attempted') {
	        			$track->value = 'notattempted';
        			}
        			
        			$usertrack->status = $track->value;
        		break;
    			case 'cmi.core.score.raw':
    			case 'cmi.score.raw': 
    				$usertrack->score_raw = $track->value;
    			break;
    			case 'cmi.core.score.raw':
    				$usertrack->user_score = $track->value;
    			break;
    			case 'cmi.core.session_time':
    			case 'cmi.session_time':
    				$usertrack->session_time = $track->value;
    			break;
    			case 'cmi.core.total_time':
    			case 'cmi.total_time':
    				$usertrack->total_time = $track->value;
    			break;
			}
			
			if ((isset ($track->timemodified) AND $usertrack->timemodified < $track->timemodified)) {
				$usertrack->timemodified = $track->timemodified;
				continue;
			}
		}
		
		if (is_array($usertrack)) {
            ksort($usertrack);
        }
        
		return $usertrack;
	}
	
	return false;
}

function scorm_array_search($item, $needle, $haystacks, $strict = false) {
	if (!empty ($haystacks)) {
		foreach ($haystacks as $key => $element) {
			if ($strict) {
				if ($element->$item === $needle) {
					return $key;
				}
				
				continue;
			}
		}
	}
	
	return false;
}

function scorm_parse($scorm) {
	$reference = $scorm->reference_folder;
    if ($scorm->pkgtype == 'AICC') {
    	require_once dirname (__FILE__) .'/datamodels/aicclib.php';
    	$scorm->launch = scorm_parse_aicc ($reference, $scorm->id);
    }
    else {
    	require_once dirname (__FILE__) .'/datamodels/scormlib.php';
    	$scorm->launch = scorm_parse_scorm ($reference, $scorm->id);
	}
	
	return $scorm->launch;
}

function scorm_validate_manifest ($manifest) {
	$validation = new stdClass ();
	if (is_file ($manifest)) {
		$validation->result = true;
    }
    else {
    	$validation->result = false;
    	$validation->errors['reference'] = 'nomanifest';
    }

    return $validation;
}

function scorm_validate_aicc ($packagedir) {
	$validation = new stdClass ();
    $validation->result = false;
    if (is_dir ($packagedir)) {
    	if ($handle = opendir ($packagedir)) {
    		while ($file = readdir ($handle) !== false) {
    			$ext = substr ($file, strrpos ($file, '.'));
    			if (strtolower ($ext) == '.cst') {
    				$validation->result = true;
    				break;
				}
			}
			
			closedir ($handle);
		}
    }

    if ($validation->result == false) {
    	$validation->errors['reference'] = 'nomanifest';
    }
    
    return $validation;
}

function scorm_check_package ($data) {
    $validation = new stdClass ();
    if ((!empty ($data->material_id) AND !empty ($data->scorm_package))) {
    	$validation->launch = 0;
    	if (empty ($data->scorm_package)) {
    		$validation = null;
		}
		
		$reference = $data->reference;
		$reference_folder = $data->reference_folder;
		$externalpackage = false;
		if (!empty ($data->id)) {
			if ((!empty ($validation) AND (is_file ($reference) OR $externalpackage))) {
				if (!$externalpackage) {
					$mdcheck = md5_file ($reference);
				}
				else {
					if ($externalpackage) {
					}
				}
				
                //$scorm = Jelly::select
				//$objDB->select("SELECT a.*, b.package_srv_name, b.folder_srv_name FROM jos_lms_n_scorm a, jos_lms_scorm_packages WHERE a.id = '".$data->id."' AND a.scorm_package = b.id");
				$scorm = Jelly::selecy('scorm')
                    ->join('scorm_package', 'LEFT')
                    ->on('jos_lms_n_scorm.scorm_package', '=', DB::expr('jos_lms_scorm_packages.id'))
                    ->where('jos_lms_n_scorm.id', '=', $data->id)
                    ->limit(1)
                    ->execute();
                    
                if ($scorm->loaded()) {
					$oldreference = DOCROOT.'upload/materials/scorm/'.$scorm->package_srv_name;
					$validation->launch = $scorm->launch;
					if ((($oldreference == $reference AND $mdcheck != $scorm->md5hash) OR $oldreference != $reference)) {
						$validation->launch = 0;
					}
					else {
						if (strpos ($scorm->version, 'AICC') !== false) {
							$validation->pkgtype = 'AICC';
						}
						else {
							$validation->pkgtype = 'SCORM';
						}
					}
				}
				else {
					$validation = null;
				}
			}
			else {
				$validation = null;
			}
		}
		
		if (($validation != null AND $validation->launch == 0)) {
			$ext = strtolower (substr (basename ($reference), strrpos (basename ($reference), '.')));
			$tempdir = '';
			
			switch ($ext) {
				case '.pif':
				case '.zip':
					if (is_file ($reference_folder . '/imsmanifest.xml')) {
						$validation = scorm_validate_manifest ($reference_folder . '/imsmanifest.xml');
						$validation->pkgtype = 'SCORM';
					}
					else {
						$validation = scorm_validate_aicc ($reference_folder);
						$validation->pkgtype = 'AICC';
					}
                    
				break;
				case '.xml':
					if (basename ($reference) == 'imsmanifest.xml') {
						if ($externalpackage){
						}
						else {
							$validation = scorm_validate_manifest ($reference);
						}
						$validation->pkgtype = 'SCORM';
					}
					else {
						$validation = null;
					}
				break;
				default:
					$validation = null;
				break;
			}
		

	        if ($validation == null) {
	        	if (is_dir ($tempdir)) {
	        	}
	        }
	        else {
	        	if (($ext == '.xml' AND !$externalpackage)) {
	        	}
	        	$validation->launch = 0;
	    	}
    	}
    }
    else {
    	$validation = null;
    }
   
    return $validation;
}

  function scorm_view_display ($user, $scorm, $action, $cm, $boxwidth = '')
  {
    global $JLMS_DB;
    if ($scorm->updatefreq == UPDATE_EVERYTIME)
    {
      $scorm->instance = $scorm->id;
      scorm_update_instance ($scorm);
    }

    $organization = intval (mosgetparam ($_REQUEST, 'organization', 0));
    echo '        <div class="structurehead">';
    echo 'coursestruct';
    echo '</div>
';
    if (!$organization)
    {
      $organization = $scorm->launch;
    }

    $query = '' . 'SELECT id, title FROM #__lms_n_scorm_scoes WHERE scorm=\'' . $scorm->id . '\' AND organization=\'\' AND launch=\'\' ORDER BY id';
    $JLMS_DB->SetQuery ($query);
    $orgs = $JLMS_DB->LoadObjectList ();
    if (1 < count ($orgs))
    {
      echo '            <div class=\'center\'>
                ';
      echo 'organizations';
      echo '                <form id=\'changeorg\' method=\'post\' action=\'';
      echo $action;
      echo '\'>
                    ';
      choose_from_menu ($orgs, 'organization', '' . $organization, '', 'submit()');
      echo '                </form>
            </div>
';
    }

    $orgidentifier = '';
    if ($sco = scorm_get_sco ($organization, SCO_ONLY))
    {
      if (($sco->organization == '' AND $sco->launch == ''))
      {
        $orgidentifier = $sco->identifier;
      }
      else
      {
        $orgidentifier = $sco->organization;
      }
    }

    $scorm->version = strtolower (eregi_replace ('[^a-zA-Z0-9_-]', '', $scorm->version));
    if (!file_exists (dirname (__FILE__) . '/datamodels/' . $scorm->version . 'lib.php'))
    {
      $scorm->version = 'scorm_12';
    }

    require_once dirname (__FILE__) . '/datamodels/' . $scorm->version . 'lib.php';
    $result = scorm_get_toc ($user, $scorm, 'structlist', $orgidentifier);
    $incomplete = $result->incomplete;
    echo $result->toc;
    echo '            <div class="center">
                <form id="theform" method="post" action="';
    echo $CFG->wwwroot;
    echo '/mod/scorm/player.php?id=';
    echo $cm->id;
    echo '"';
    echo ($scorm->popup == 1 ? ' target="newwin"' : '');
    echo '>
              ';
    if ($scorm->hidebrowse == 0)
    {
      echo 'mode';
      echo ': <input type="radio" id="b" name="mode" value="browse" /><label for="b">' . 'browse' . '</label>' . '
';
      echo '<input type="radio" id="n" name="mode" value="normal" checked="checked" /><label for="n">' . 'normal' . '</label>
';
    }
    else
    {
      echo '<input type="hidden" name="mode" value="normal" />' . '
';
    }

    if (($incomplete === false AND (0 < $result->attemptleft OR $scorm->maxattempt == 0)))
    {
      echo '                  <br />
                  <input type="checkbox" id="a" name="newattempt" />
                  <label for="a">';
      echo 'newattempt';
      echo '</label>
';
    }

    echo '              <br />
              <input type="hidden" name="scoid" />
              <input type="hidden" name="currentorg" value="';
    echo $orgidentifier;
    echo '" />
              <input type="submit" value="';
    echo 'entercourse';
    echo '" />
              </form>
          </div>
';
  }
  
/* Find the start and finsh time for a a given SCO attempt
 *
 * @param int $scormid SCORM Id
 * @param int $scoid SCO Id
 * @param int $userid User Id
 * @param int $attemt Attempt Id
 *
 * @return object start and finsh time EPOC secods
 *
 */
function scorm_get_sco_runtime($scormid, $scoid, $userid, $attempt=1) {
	global $objDB;

    $timedata = new stdClass();
    
    $sql = !empty($scoid) ? "" : "userid=$userid AND scormid=$scormid AND attempt=$attempt";
    
    $builder = Jelly::select('scorm_scoe_track');
    if (!empty($scoid)) {
        $builder->where('userid', '=', $userid)
            ->where('scormid', '=', $scormid)
            ->where('scoid', '=', $scoid)
            ->where('attempt', '=', $attempt);
    }
    else {
        $builder->where('userid', '=', $userid)
            ->where('scormid', '=', $scormid)
            ->where('attempt', '=', $attempt);
    }
    $tracks = $builder->order_by('timemodified', 'ASC')->execute()->as_array();
    if ($tracks) {
        $tracks = @array_values($tracks);
    }
    
    $builder = Jelly::select('scorm_scoe_track');
    if (!empty($scoid)) {
        $builder->where('userid', '=', $userid)
            ->where('scormid', '=', $scormid)
            ->where('scoid', '=', $scoid)
            ->where('attempt', '=', $attempt);
    }
    else {
        $builder->where('userid', '=', $userid)
            ->where('scormid', '=', $scormid)
            ->where('attempt', '=', $attempt);
    }
    $builder->where('element', '=', 'x.start.time');
    
    $start_track = $builder->order_by('scoid', 'ASC')->execute()->as_array();
    
    if ($start_track) {
        $start_track = array_values($start_track);
        $timedata->start = $start_track[0]['value'];
    }
    else if ($tracks) {
        $timedata->start = $tracks[0]['timemodified'];
    }
    else {
        $timedata->start = false;
    }
    if ($tracks && $track = array_pop($tracks)) {
        $timedata->finish = $track['timemodified'];
    }
    else {
        $timedata->finish = $timedata->start;
    }
    return $timedata;
}

function scorm_get_user_data($userid) {
    $user = Jelly::select('user', $userid);
    
    return $user;
}

function scorm_grade_user_attempt($scorm, $userid, $attempt=1, $time=false) {
    $attemptscore = NULL;
    $attemptscore->scoes = 0;
    $attemptscore->values = 0;
    $attemptscore->max = 0;
    $attemptscore->sum = 0;
    $attemptscore->lastmodify = 0;
    
    $scoes = Jelly::select('scorm_scoe')->where('scorm', '=', $scorm->id)->execute();
    $only_scoes = Jelly::select('scorm_scoe')->where('scorm', '=', $scorm->id)->where('scormtype', '=', 'sco')->execute();
    
    if (!$scoes) {
        return NULL;
    }

    // this treatment is necessary as the whatgrade field was not in the DB
    // and so whatgrade and grademethod are combined in grademethod 10s are whatgrade
    // and 1s are grademethod
    $grademethod = $scorm->grademethod % 10;
    
    
    foreach ($scoes as $sco) {
        if ($userdata=scorm_get_tracks($sco->id, $userid, $attempt)) {
            if (($userdata->status == 'completed') || ($userdata->status == 'passed')) {
                $attemptscore->scoes++;
            }
            if (!empty($userdata->score_raw)) {
                $attemptscore->values++;
                $attemptscore->sum += $userdata->score_raw;
                $attemptscore->max = ($userdata->score_raw > $attemptscore->max)?$userdata->score_raw:$attemptscore->max;
                if (isset($userdata->timemodified) && ($userdata->timemodified > $attemptscore->lastmodify)) {
                    $attemptscore->lastmodify = $userdata->timemodified;
                } else {
                    $attemptscore->lastmodify = 0;
                }
            }
        }
    }
    switch ($grademethod) {
        case GRADEHIGHEST:
            $score = $attemptscore->max;
        break;
        case GRADEAVERAGE:
            if ($attemptscore->values > 0) {
                $score = $attemptscore->sum/$attemptscore->values;
            } else {
                $score = 0;
            }
        break;
        case GRADESUM:
            $score = $attemptscore->sum;
        break;
        case GRADESCOES:
            $score = $attemptscore->scoes;
        break;
        case GRADEPERCENT:
        	if ($attemptscore->scoes > 0 && count($only_scoes) > 0) {
        		$score = ceil(($attemptscore->scoes/count($only_scoes)) * 100);
    		}
        	//$score = count($only_scoes);
        break;
        default:
            $score = $attemptscore->max;   // Remote Learner GRADEHIGHEST is default
    }

    if ($time) {
        $result = new stdClass();
        $result->score = $score;
        $result->time = $attemptscore->lastmodify;
    } else {
        $result = $score;
    }

    return $result;
}


  if (!defined ('SCO_ALL'))
  {
    define ('SCO_ALL', 0);
  }

  if (!defined ('SCO_DATA'))
  {
    define ('SCO_DATA', 1);
  }

  if (!defined ('SCO_ONLY'))
  {
    define ('SCO_ONLY', 2);
  }

  if (!defined ('_JOOMLMS_SCORM_API'))
  {
    define ('_JOOMLMS_SCORM_API', '/includes/n_scorm');
  }


  if (!defined ('_JOOMLMS_SCORM_PICS'))
  {
    define ('_JOOMLMS_SCORM_PICS', '/_images/scorm');
  }

  define ('UPDATE_NEVER', '0');
  define ('UPDATE_ONCHANGE', '1');
  define ('UPDATE_EVERYDAY', '2');
  define ('UPDATE_EVERYTIME', '3');
?>