<div id="page-layout">
    <div id="page-content">
        <div id="page-content-wrapper">
            <div class="inner-page-title">
                <h2>{lang}Materiały{/lang}</h2>
                <span>{lang}Edycja{/lang}</span>
            </div>
            <div class="column-content-box">
                <div class="content-box content-box-header ui-corner-all">
                    {if $errors|default:""}
                    <div class="ui-state-default ui-corner-top ui-box-header">
                        <span class="ui-icon float-left ui-icon-notice"></span>
						{lang}Formularz zawiera błędy{/lang}
					</div>
                    <script type="text/javascript">
                        {foreach $errors as $e}
                        $.jnotify('{$e}', "error");
                        {/foreach}
                    </script>
                    {/if}
					<div class="content-box-wrapper">
                        <form action="" method="post" enctype="multipart/form-data" class="forms" id="signupForm" name="form">
                            <fieldset>
                                <ul>
                                    <li>
                                        <label class="desc {if $errors.name|default:""}error{/if}">
                                            {lang}Moduł{/lang}
                                        </label>
                                        <div>
                                            <select name="module" class="select">
                                                {foreach $modules as $m}
                                                <option value="{$m->id}" {if $smarty.post.module|default:$item->category->id == $m->id}selected="selected"{/if}>{$m->name}</option>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </li>
                                    <li>
                                        <label class="desc {if $errors.name|default:""}error{/if}">
                                            {lang}Nazwa{/lang}
                                        </label>
                                        <div>
                                            <input type="text" tabindex="1" value="{$smarty.post.name|default:$item->name|htmlspecialchars}" class="field text medium" name="name" />
                                        </div>
                                    </li>
                                    <li>
                                        <label class="desc {if $errors.type|default:""}error{/if}">
                                            {lang}Typ materiału{/lang}
                                        </label>
                                        <div>
                                            <select name="type" class="select">
                                                <option value="">-- {lang}wybierz{/lang} --</option>
                                                <option value="test" {if $smarty.post.type|default:$item->type == 'test'}selected="selected"{/if}>{lang}Test{/lang}</option>
                                                <option value="exercise" {if $smarty.post.type|default:$item->type == 'exercise'}selected="selected"{/if}>{lang}Ćwiczenie{/lang}</option>
                                                <option value="lesson" {if $smarty.post.type|default:$item->type == 'lesson'}selected="selected"{/if}>{lang}Lekcja{/lang}</option>
                                                <option value="scorm" {if $smarty.post.type|default:$item->type == 'scorm'}selected="selected"{/if}>{lang}SCORM{/lang}</option>
                                                <option value="videosync" {if $smarty.post.type|default:$item->type == 'videosync'}selected="selected"{/if}>{lang}Film + slajdy (synchronizacja){/lang}</option>
                                            </select>
                                        </div>
                                    </li>
                                    <li class="buttons">
                                        <input class="submit" type="submit" value="{lang}Zapisz{/lang}" />
                                    </li>
                                </ul>
                            </fieldset>
                        </form>
                    </div>
                </div>
            </div>
            
            <div class="clear"></div>
            <div id="sidebar">
                <div class="sidebar-content">
                    <a id="close_sidebar" class="btn ui-state-default full-link ui-corner-all" href="#drill">
                        <span class="ui-icon ui-icon-circle-arrow-e"></span>
                        {lang}Zamknij{/lang}
                    </a>
                    <a id="open_sidebar" class="btn tooltip ui-state-default full-link icon-only ui-corner-all" title="{lang}Otwórz{/lang}" href="#">
                        <span class="ui-icon ui-icon-circle-arrow-w"></span>
                    </a>
                    <div class="hide_sidebar">
                        <div class="portlet ui-widget ui-widget-content ui-helper-clearfix ui-corner-all">
                            <div class="portlet-header ui-widget-header">{lang}Baza szkoleń{/lang}</div>
                            <div class="portlet-content">
                                <ul class="side-menu layout-options">
                                    <li>
                                        <a href="{helper function="url::site" param1="admin/base/index/`$parent_id`"}">{lang}Lista materiałów{/lang}</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="clear"></div>
        </div>
        <div class="clear"></div>
    </div>
</div>