<!--course-->
<div class="top-mov">
    <div class="main">
        {$breadcrumbs}

        {if $message.frontend_message|default:""}
        <div class="alert alert-block alert-{$message.frontend_message_type}">
            <h4 class="alert-heading">{$message.frontend_message_type_raw}!</h4>
            {$message.frontend_message}
        </div>
        {/if}

        <div class="course-box clearfix">
            <div class="mov">
                {if $item->movie}
                <div id="videoPlayer"></div>
                <script type="text/javascript">
                    jwplayer("videoPlayer").setup({
                        flashplayer: "public/flash/player.swf",
                        skin:"public/flash/modieus.zip",
                        controlbar:"over",
                        autostart:"false",
                        backcolor:"0x000000",
                        frontcolor:"0x007448",
                        lightcolor:"0xE0E1D3",
                        file: '{helper function="url::base" param1="false" param2="http"}{$item->movie}',
                        height: 279,
                        width: 498,
                        wmode:"transparent",
                        'plugins': {
                            '{helper function="url::base" param1="false" param2="http"}public/flash/backstroke-1.swf': {}
                        }
                    });
                </script>
                {elseif $item->icon_entry}
                <img src="/imagefly/w498-h279-c/{$item->icon_entry}" />
                {else}
                <img src="public/design/frontend/images/default_movie.jpg" />
                {/if}
            </div>
            <div class="desc">
                <h2>{$item->name}</h2>
                {if $moderators->count()}
                <p class="blue">Prowadzący:</p><br>
                {foreach $moderators as $moderator}
                {if $moderator->user->logo}
                <img src="{$moderator->user->logo}" />
                {/if}
                <p style="font-size:12px; font-weight: bold;">
                    {$moderator->user->firstname} {$moderator->user->lastname}
                </p>
                <p style=" width: 150px;" class="blue">
                    {$moderator->user->position}
                </p>
                <div class="clearfix"></div>
               
                {/foreach}
                {/if}
                <hr>
                <a class="ajax_iframe_custom btn btn-gray" href="{helper function="url::site" param1="courses/program/`$item->id`"}" data-title="PROGRAM TEMATU" data-width="700px" data-height="640px">
                    Program tematu
                </a>
                {if $is_logged}
                    {if $is_subscribed}
                        {if $course_status->active == '1'}
                        <a class="btn btn-orange" href="{helper function="url::site" param1="course/continue/`$item->id`"}">
                            Kontynuuj temat
                        </a>
                        {/if}
                    {/if}
                {/if}
            </div>
            <div class="clearfix"></div>
            <h3>Opis tematu</h3>
            <div class="bl-desc">
                {$item->content}
            </div>
        </div>
        <div class="course-commnet">
            <h3>Komentarze</h3>
            {foreach $comments as $comment}
            <p class="user-data">~{$comment->username}, {$comment->created_on|date_format:"%d-%m-%Y"}</p>
            <p>{$comment->content}</p>
            {foreachelse}
            <div class="alert alert-info">
                Jeszcze nikt nie dodał komentarza. Bądź pierwszy i napisz komentarz
            </div>
            {/foreach}
        </div>
        <div class="course-commnet">
            <h3>Dodaj komentarz</h3>
            {if Auth::instance()->logged_in()}
            {if Auth::instance()->get_user()->has_role('student')}
            <div class="alert alert-info">
                Nie posiadasz możliwości komentowania
            </div>
            {else}
            <form action="" method="post" >
                <fieldset>
                    <div class="control-group {if $errors.name|default:""}error{/if}">
                        <label for="textarea" class="control-label">Imię</label>
                        <div class="controls">
                            <input name="name" type="text" class="input-xxlarge" />
                            {if $errors.name|default:""}<span class="help-inline">{$errors.name|default:""}</span>{/if}
                        </div>
                    </div>
                    <div class="control-group {if $errors.content|default:""}error{/if}">
                        <label for="textarea" class="control-label">Treść</label>
                        <div class="controls">
                            <textarea name="content" rows="3" class="input-xxlarge"></textarea>
                            {if $errors.content|default:""}<span class="help-inline">{$errors.content|default:""}</span>{/if}
                        </div>
                    </div>
                    <div class="form-actions">
                        <button class="btn" type="submit">Wyślij</button>
                    </div>
                </fieldset>
            </form>
            {/if}
            {else}
            <div class="alert alert-info">
                Aby dodać komentarz musisz być zalogowany
            </div>
            {/if}
        </div>
    </div>
</div>
<!--end course-->
<div class="main">
    <!--search-->
    <div class="category-sel list-sel">
        <h3><span></span>Podobne tematy</h3>
    </div>
    <!--end search-->
    <div class="clearfix"></div>
    <br />
    {section name=tr loop=$items step=4}
    <!--course intro first line-->
    <ul class="course-intro {if $smarty.section.tr.iteration > '1'}nth{/if}">
        {section name=td start=$smarty.section.tr.index loop=$smarty.section.tr.index+4}
        {if $items[td].id|default:""}
        <li>
            <dl>
                <div class="vignette">
                    <a href="{helper function="url::site" param1="courses/detail/`$items[td].id`"}">
                        {if $items[td].icon}
                        <img src="/imagefly/w214-h94-c/{$items[td].icon}" />
                        {else}
                        <img src="public/design/frontend/images/default_img.jpg" />
                        {/if}
                    </a>
                </div>
                <dd class="coursoe-title">
                    <a href="{helper function="url::site" param1="courses/detail/`$items[td].id`"}">
                        {$items[td].name}
                    </a>
                </dd>
                <dd class="course-description">
    				{$items[td].content_short}				
    			</dd>
                {*
                <dd class="course-users">
                    <p>Uczestniczyło już: <span>{$items[td].total_users} osób</span><p>
                </dd>
                *}
            </dl>
            <a class="course-link" href="{helper function="url::site" param1="courses/detail/`$items[td].id`"}"></a>
        </li>
        {/if}
        {/section}
    </ul>
    <!--end course intro first line-->
    {sectionelse}
    <div class="clearfix"></div>
    <div class="alert alert-info">
        Nie znaleziono żadnych tematów do wyświetlenia
    </div>
    <div class="clearfix"></div>
    {/section}

    <!--end course intro second line-->
    <div class="clearfix"></div>
    <br />
</div>
<!--bottom navigation-->
<div id="codeDialog_{$item->id}" title="Podaj kod" style="display: none;">
    <p>
        Aby zapisać się na ten temat wymagane jest podanie kodu<br /><br />
        <input type="hidden" id="code_course_id_{$item->id}" name="code_course_id" value="{$item->id}" />
        <input type="text" value="" id="code_one_{$item->id}" name="code_one" size="4" maxlength="4" style="display: inline; width: 60px; height: 25px;" /> - <input type="text" value="" id="code_two_{$item->id}" name="code_two" size="12" maxlength="12" style="display: inline; width: 200px; height: 25px;" />
    </p>
</div>