<div class="main register">
    {$breadcrumbs}
</div>
<div class="main">
    {if $message.frontend_message|default:""}
    <div class="alert alert-block alert-{$message.frontend_message_type}">
        <h4 class="alert-heading">{$message.frontend_message_type_raw}!</h4>
        {$message.frontend_message}
    </div>
    {/if}
    <form id="addTopic" action="" method="post" name="addItem" enctype="multipart/form-data">
        <fieldset>
            <div class="control-group {if $errors.name|default:""}error{/if}">
                <label for="name" class="control-label">{lang}Tytuł{/lang}:</label>
                <div class="controls">
                    <input name="name" value="{$smarty.post.name|default:""}" type="text" class="input-xxlarge" />
                    {if $errors.name|default:""}<p class="help-block">{$errors.name|default:""}</p>{/if}
                </div>
            </div>
            <div class="control-group">
                <p>
                    Ikona tematu:
                </p>
                {foreach $posticons as $posticon}
                <label class="radio inline">
                    <input type="radio" name="icon" id="icon_{$posticon->id}" value="{$posticon->id}" {if $smarty.post.icon|default:"" == $posticon->id}checked="checked"{/if}> <img src="{$posticon->icon}" style="display: inline;" />
                </label>
                {/foreach}
            </div>
            <div class="control-group {if $errors.message|default:""}error{/if}">
                <label for="content">Treść:</label>
                <div style="float: left;">
                    <textarea name="content" id="content" rows="25" cols="25" style="width: 600px; height: 220px;">{$smarty.post.content|default:"&nbsp;"}</textarea>
                    {if $errors.content|default:""}<p class="help-block">{$errors.content|default:""}</p>{/if}
                </div>
                <div style="float: right;">
                    <div style="background-color: #F3F3F3; color: #000; padding: 5px 5px 5px 5px; width: 220px; height: 15px;">
                        Emotikony
                    </div>
                    <table>
                        {section name=tr loop=$emoticons step=8} 
                        <tr> 
                            {section name=td start=$smarty.section.tr.index loop=$smarty.section.tr.index+8}
                            {if isset($emoticons[td].icon)}
                            <td>
                                <a href="javascript:void(0);" onclick="javascript:insertEmoticon('{$emoticons[td].icon}');">
                                    <img src="{$emoticons[td].icon}" />
                                </a>
                            </td>
                            {/if}    
                            {/section} 
                        </tr> 
                        {/section}
                    </table>
                </div>
                <div class="clearfix"></div>
            </div>
            <div class="control-group">
                <label>Załączniki:</label>
                <input type="file" name="file_upload" id="file_upload" class="fileInput" />
                <p class="help-block">Maksymalna ilość załączników możliwych do dodania wynosi 4</p>
                <p class="help-block">Maksymalny rozmiar pliku wynosi 1 Mb</p>
                <p class="help-block">Możliwe rozszerzenia jpg, gif, png, zip, rar, tar, 7z, gz, exe, pdf, ppt, doc, txt</p>
            </div>
            <div class="control-group">
                <p>
                    Opcje:
                </p>
                <label class="checkbox">
                    <input type="checkbox" name="parseurl" id="parseurl" value="1" {if $smarty.post.parseurl|default:"1" == '1'}checked="checked"{/if} />
                    Automatyczne wykrywanie linków
                </label>
                <label class="checkbox">
                    <input type="checkbox" id="notification" name="notification" value="1" {if $smarty.post.notification|default:"" == '1'}checked="checked"{/if} />
                    Chcę otrzymywać powiadomienia o odpowiedziach w wątku
                </label>
                <label class="checkbox">
                    <input type="checkbox" name="disablebb" id="disablebb"  value="1" {if $smarty.post.disablebb|default:"" == '1'}checked="checked"{/if} />
                    Wyłącz formatowanie w wiadomości
                </label>
                <label class="checkbox">
                    <input type="checkbox" name="disablesmileys" id="disablesmileys" value="1" {if $smarty.post.disablesmileys|default:"" == '1'}checked="checked"{/if} />
                    Wyłącz uśmieszki w wiadomości
                </label>
            </div>
            {if $is_mod}
            <div class="control-group">
                <p>
                    Opcje moderatora:
                </p>
                <label class="radio">
                    <input type="radio" name="subaction" id="subaction_0" value="none" {if $smarty.post.subaction|default:"none" == 'none'}checked="checked"{/if}>
                    Nie rób nic
                </label>
                <label class="radio">
                    <input type="radio" name="subaction" id="subaction_1" value="close" {if $smarty.post.subaction|default:"" == 'close'}checked="checked"{/if}>
                    Zamknij po dodaniu
                </label>
                <label class="radio">
                    <input type="radio" name="subaction" id="subaction_2" value="announce" {if $smarty.post.subaction|default:"" == 'announce'}checked="checked"{/if}>
                    Ustaw jako ogłoszenie
                </label>
                <label class="radio">
                    <input type="radio" name="subaction" id="subaction_3" value="attention" {if $smarty.post.subaction|default:"" == 'attention'}checked="checked"{/if}>
                    Ustaw jako przyklejony
                </label>
            </div>
            {/if}
        </fieldset>
        <div class="form-actions">
            <button class="btn" type="submit">{lang}Zapisz{/lang}</button>
        </div>
    </form>
    
    <script type="text/javascript">
        jQuery(document).ready(function() {
            jQuery('#file_upload').uploadify({
                'swf'      : '{helper function="url::site" param1="public/flash/uploadify.swf"}',
                'uploader' : '{helper function="url::site" param1="ajax/forum_upload"}',
                'auto' : true,
                'fileSizeLimit' : '1MB',
                'fileTypeDesc' : 'Pliki możliwe do wgrania',
                'fileTypeExts' : '*.jpg;*.gif;*.png;*.zip;*.rar;*.tar;*.7z;*.gz;*.exe;*.pdf;*.ppt;*.doc;*.txt',
                'multi'    : true,
                'uploadLimit' : 4,
                'removeCompleted' : false,
                'buttonText' : 'WYBIERZ PLIKI',
                'simUploadLimit' : 2,
                'queueSizeLimit' : 4,
                'onComplete' : function(event, ID, fileObj, response, data) {
                    jQuery('#addTopic').append('<input type="hidden" name="attachments[]" value="'+response+'" />');
                },
                'onOpen' : function(event,ID,fileObj) {
                    if (count_uploaded_files > 4) {
                        jAlert('Wgrałeś już maksymalną dozwoloną ilość załączników', 'UWAGA');
                        
                        jQuery('#file_upload').uploadifyClearQueue();
                    }
                }
            });
      
            jQuery("#content").cleditor({
                width: '640',
                height: '280',
                controls: "bold italic underline strikethrough subscript superscript " +
                "| color removeformat | bullets numbering | outdent " +
                "indent | alignleft center alignright justify | undo redo | " +
                "image link unlink",
            });
        });
        
        function insertEmoticon(val) {
            var editor = jQuery("#content").cleditor()[0];
            
            editor.execCommand('insertimage', val);
        }
    </script>
</div>