$.datepicker.regional['pl'] = {
	closeText: 'Zamknij',
    prevText: '&#x3c;Poprzedni',
    nextText: 'Następny&#x3e;',
    currentText: 'Dziś',
    monthNames: ['Styczeń','Luty','Marzec','Kwiecień','Maj','Czerwiec','Lipiec','Sierpień','Wrzesień','Październik','Listopad','Grudzień'],
    monthNamesShort: ['Sty','Lut','Mar','Kwi','Maj','Cze','Lip','Sie','Wrz','Paź','Lis','Gru'],
    dayNames: ['Niedziela','Poniedziałek','Wtorek','Środa','Czwartek','Piątek','Sobota'],
    dayNamesShort: ['Nd','Pn','Wt','Śr','Czw','Pt','So'],
    dayNamesMin: ['Nd','Pn','Wt','Śr','Cz','Pt','So'],
    weekHeader: 'Tydz',
    dateFormat: 'yy-mm-dd',
    firstDay: 1,
    isRTL: false,
    showMonthAfterYear: false,
    yearSuffix: ''
};
$.datepicker.setDefaults($.datepicker.regional['pl']);

(function($){
    $.fn.extend({ 
        elFinderFtp: function(options) {
            var defaults = {}
                 
            var options =  $.extend(defaults, options);
            
            return this.each(function() {
                var o = options;
                var obj = $(this);
                var holder = obj.data('file-holder');
                
                obj.find('.upload').click(function(e) {
                    $.fn.colorbox({
                    	iframe:true,
                    	width:'800',
                    	height:'600',
                    	href:'/elfinderplugin.html?holder='+holder
                    });
                    
                    return false;
                });
                    
                obj.find('.delete').click(function(e) {
                    jConfirm('Czy na pewno chcesz usunąć plik?', 'UWAGA', function(r) {
                        if (r == true) {
                            obj.find('#'+holder).val('');
                            obj.find('.file-info').attr('src', '');
                            obj.find('.ftp-browser-preview').hide();
                        }
                    });
                    
                    return false;
                });
            });
        }
    });
     
})(jQuery);

function confirm_action(redirect_uri) {
    jConfirm('Czy na pewno chesz wykonać wybraną akcje?', 'UWAGA', function(r) {
        if (r == true) {
            window.location.href = redirect_uri;
        }
    });
}

function confirm_action_custom(message, redirect_uri) {
    jConfirm(message, 'UWAGA', function(r) {
        if (r == true) {
            window.location.href = redirect_uri;
        }
    });
}

function display_alert(message, title) {
    jAlert(message, title);
}

function delete_setting_upload(id) {
    $('#file_upload_hidden_'+id).val('');
    $('#file_upload_preview_'+id).remove();
}

function f(x) {
	if (document.getElementById(x).style.display == 'none') {
		document.getElementById(x).style.display = "block";
	}
	else {
		document.getElementById(x).style.display = "none";
	}
}

function finline(x) {
	if (document.getElementById(x).style.display == 'none') { document.getElementById(x).style.display = ""; } else { document.getElementById(x).style.display = "none"; }
}

function z1(x,w) {
    if (document.getElementById(x)) { document.getElementById(x).style.display='block'; }
    if (document.getElementById(w)) { document.getElementById(w).style.display='none'; }
}

function z2(x,w,e) {
    if (document.getElementById(x)) { document.getElementById(x).style.display='block'; }
    if (document.getElementById(w)) { document.getElementById(w).style.display='none'; }
    if (document.getElementById(e)) { document.getElementById(e).style.display='none'; }
}

function z3(x,w,e,b) {
    if (document.getElementById(x)) { document.getElementById(x).style.display='block'; }
    if (document.getElementById(w)) { document.getElementById(w).style.display='none'; }
    if (document.getElementById(e)) { document.getElementById(e).style.display='none'; }
    if (document.getElementById(b)) { document.getElementById(b).style.display='none'; }
}

function openColorboxIframe(uri) {
	jQuery.colorbox({
    	iframe: true,
    	width: '800',
    	height: '600',
    	href: uri
    });
}

$(document).ready(function() {
	$('.colorbox').colorbox({
		maxWidth: '100%',
		maxHeight: '100%'
	});
	
    $('.resource_icon').each(function() {
        var holder = $(this).attr('data-file-holder');
        
        $(this).colorbox({
        	iframe:true,
        	width:'1024',
 	        height:'768',
        	href:'/icon.html?holder='+holder
        });
    });
    
    jQuery('.ftp-browser').elFinderFtp();
    
    $('.resource_gallery').colorbox({
    	iframe:true,
    	width:'1024',
    	height:'768',
    	href:'gallery.html'
    });
    
    if (isdefined('resource_type')) {
        $('.resource_attachments').colorbox({
        	iframe:true,
        	width:'1024',
    	    height:'768',
        	href:'attachments.html?resource_type='+resource_type+'&resource_id='+resource_id
        });
    }
    
    $('.select_resource').colorbox({
    	iframe:true,
    	width:'1024',
    	height:'768',
    	href:'/admin/resources/ajax-select'
    });

    jQuery(document).on('click', 'a.ajaxStatus', function(e) {
        var href = $(this);
        var img = jQuery(this).find('img');

        jQuery.ajax({
			url: href.attr('href'),
			cache: false,
			dataType: 'json',
			success: function(data) {
				if (data.status == 'success') {
					img.attr('src', '/assets/backend/img/'+data.img);
					href.attr('href', data.uri);
                    
                    jQuery().toastmessage('showToast', {
                        text     : 'Zapisano poprawnie',
                        position : 'middle-center',
                        sticky   : true,
                        type     : 'success'
                    });
				}
				else {
					jQuery().toastmessage('showToast', {
                        text     : 'Błąd',
                        position : 'middle-center',
                        sticky   : true,
                        type     : 'error'
                    });
				}
			}
		});
		
        e.preventDefault();
    });
    
    jQuery(document).on('click', 'a.ajaxStatusUi', function(e) {
        var href = $(this);

        jQuery.ajax({
			url: href.attr('href'),
			cache: false,
			dataType: 'json',
			success: function(data) {
				if (data.status == 'success') {
				    if (href.hasClass('ui-icon-close')) {
				        href.removeClass('ui-icon-close').addClass('ui-icon-check');
				    }
                    else if (href.hasClass('ui-icon-check')) {
				        href.removeClass('ui-icon-check').addClass('ui-icon-close');
				    }
                    				
					href.attr('href', data.uri);
                    
                    jQuery().toastmessage('showToast', {
                        text     : 'Zapisano poprawnie',
                        position : 'middle-center',
                        sticky   : true,
                        type     : 'success'
                    });
				}
				else {
					jQuery().toastmessage('showToast', {
                        text     : 'Błąd',
                        position : 'middle-center',
                        sticky   : true,
                        type     : 'error'
                    });
				}
			}
		});
		
        e.preventDefault();
    });
    
    $('.preview_icon').colorbox({
    	maxWidth:'800',
    	maxHeight:'600'
    });

    $('.nyro').nyroModal({
    	zIndexStart: '100',
    	callbacks: {
	    	beforeShowCont: function() {
	    		$('#nyroModalFull').css('zIndex', 9999);
	    	}
	    }
    });
    
    jQuery('select[name="country"]').change(function(){
        if (jQuery(this).val() != 1) {
            jQuery('select[name="province"]').val(33);
        }
        else {
            jQuery('select[name="province"]').val(24);
        }
    })

    // Navigation menu
	$('ul#navigation').supersubs({ 
        minWidth:    18,
        maxWidth:    80,
        extraWidth:  1 
    }).superfish({ 
		delay:       1000,
		animation:   {opacity:'show',height:'show'},
		speed:       'fast',
		autoArrows:  true,
		dropShadows: false
	});
    
    $('.navigation-right').supersubs({ 
        minWidth:    18,
        maxWidth:    80,
        extraWidth:  1 
    }).superfish({ 
		delay:       1000,
		animation:   {opacity:'show',height:'show'},
		speed:       'fast',
		autoArrows:  true,
		dropShadows: false
	});
	
	$('ul#navigation li').hover(
        function() {
            $(this).addClass('sfHover2');
        },
        function(){
            $(this).removeClass('sfHover2');
        }
    );
    
    $('.ui-state-default').hover(
        function() {
            $(this).addClass('ui-state-hover');
        }, 
		function() {
		    $(this).removeClass('ui-state-hover');
        }
	);
    
	//Sortable portlets
	$('.sortable .column').sortable({
		cursor: "move",
		connectWith: '.sortable .column',
		dropOnEmpty: false
	});

	$(".column").disableSelection();

	//Sidebar only sortable boxes
	$(".side_sort").sortable({
		axis: 'y',
		cursor: "move",
		connectWith: '.side_sort'
	});
    
    
    //Close/Open portlets
	$(".portlet-header").hover(function() {
		$(this).addClass("ui-portlet-hover");
	},
	function(){
		$(this).removeClass("ui-portlet-hover");
	});

	//$(".portlet-header .ui-icon").click(function() {
	//	$(this).toggleClass("ui-icon-circle-arrow-n");
	//	$(this).parents(".portlet:first").find(".portlet-content").toggle();
	//});
    
    // Sidebar close/open (with cookies)

	function close_sidebar() {
	   $("#sidebar").addClass('closed-sidebar');
       $("#page_wrapper #page-content #page-content-wrapper").addClass("no-bg-image wrapper-full");
       $("#open_sidebar").show();
       $("#close_sidebar, .hide_sidebar").hide();
       
       return false;
	}
     
     function open_sidebar() {
		$("#sidebar").removeClass('closed-sidebar');
		$("#page_wrapper #page-content #page-content-wrapper").removeClass("no-bg-image wrapper-full");
		$("#open_sidebar").hide();
		$("#close_sidebar, .hide_sidebar").show();
        
        return false;
	}

	$('#close_sidebar').click(function(){
		close_sidebar();
		if($.browser.safari) {
		    location.reload();
		}
		$.cookie('sidebar', 'closed' );
        $(this).addClass("active");
        
        return false;
	});
	
	$('#open_sidebar').click(function(){
		open_sidebar();
		if($.browser.safari) {
		    location.reload();
		}
		$.cookie('sidebar', 'open' );
        
        return false;
	});
	
	var sidebar = $.cookie('sidebar');
    if (sidebar == 'closed') {
        open_sidebar();
    };
    
    if (sidebar == 'open') {
        open_sidebar();
    };

	/* Tooltip */
	$(function() {
		$('.tooltip').tooltip({
			track: true,
			delay: 0,
			showURL: false,
			showBody: " - ",
			fade: 250
			});
	});
     
     // Same height
	var sidebarHeight = $("#sidebar").height();
	$("#page-content-wrapper").css({"minHeight" : sidebarHeight });
    
    
    $(".header").append('<span class="ui-icon ui-icon-carat-2-n-s"></span>');
});

/* Check all table rows */
var checkflag = "false";
function check(field) {
    if (checkflag == "false") {
        for (i = 0; i < field.length; i++) {
            field[i].checked = true;
        }
        checkflag = "true";
        return "check_all";
    }
    else {
        for (i = 0; i < field.length; i++) {
            field[i].checked = false;
        }
        checkflag = "false";
        return "check_none"; 
    }
}

function check_all_box(form) {
	var checked=0;
	if (form) {
	   for (var i=0;i<form.length;i++) {
	       if (form[i].value != 'check_none') {
	           if (form[i].type=='checkbox') {
	               form[i].checked=!form[i].checked;
                }
            }
		}
	}
}