# Создание, обновление и удаление данных

Чтобы продемонстрировать разнообразие методов манипуляций с записями базы данных, мы создадим,
сохраним и удалим запись.

### Создание и изменение

Создание и изменение записи производятся с использованием метода `save()`. Следует всегда помнить,
что `save()` может вызвать `Validate_Exception`, если передаваемые значения не будут проходить
валидацию по правилам, установленным для полей в модели. Поэтому всегда нужно проверять результат
на наличие исключений.

##### Пример: создание новой записи

Можно передать массив значений в метов `set()` или сформировать значения непосредственно в нём

	Jelly::factory('post')
		 ->set(array(
			 'name' => 'A new post',
			 'published' => TRUE,
			 'body' => $body,
			 'author' => $author,
			 'tags' => $some_tags,
		 ))->save()

##### Пример: обновление записи

Если модель загружена, то Jelly знает, что изменения значений были произведены для обновления
записи, а не для создания.

	$post = Jelly::select('post')->load(1);
	$post->name = $new_name;
	$post->save();

##### Пример: обновление записи, минуя этап её загрузки

Следует заметить, что в `save()` передаётся primary key записи, с которой производятся изменения.
Это позволяет обновить запись, даже если она не загружена.

	$post = Jelly::factory('post');
	$post->name = $new_name;
	$post->save($id);

##### Пример: сохранение записи с данными $_POST

Данный метод, позволяющий заполнять данные модели, будет крайне удобен при обработке форм:

	Jelly::factory('post', $_POST)->save();
	
Однако, в целях безопасности, всегда стоит заботиться о том, чтобы передавать только необходимые
при сохранении данные объекта.

	// Сперва извлекаются только требуемые ключи массива
	$model->set(Arr::extract($_POST, array('keys', 'to', 'use')));

### Удаление

Удаление в Jelly - тоже достаточно простая операция. Просто вызовите метод `delete()` для
модели. Как результат, будет возвращено количество затронутых строк (1 или 0).

##### Пример: удаление загруженной записи

	$post = Jelly::select('post')->load(1);
	$post->delete();

##### Пример: удаление записи, минуя этап её загрузки

	// В метод delete() передаётся unique_key записи
	Jelly::factory('post')->delete($id);


## Далее [Доступ и управление связями](jelly.relationships)