// +--------------------------------------------------------------------+
// | DO NOT REMOVE THIS                                                 |
// +--------------------------------------------------------------------+
// | XulTabs.js                                                         |
// | Automatic tabs creation.                                           |
// +--------------------------------------------------------------------+
// | Author:  Cezary Tomczak [www.gosu.pl]                              |
// | Project: SimpleDoc                                                 |
// | URL:     http://gosu.pl/php/simpledoc.html                         |
// | License: GPL                                                       |
// +--------------------------------------------------------------------+
function Fader(id) {
    this.start = function() {
        this.timerId = setInterval(change, 80);
    };
    this.stop = function() {
        clearInterval(this.timerId);
        this.opacity = 80;
        this.direction = 0;
        document.getElementById(this.id).style.opacity = 1;
        document.getElementById(this.id).style.MozOpacity = 1;
        document.getElementById(this.id).style.filter = 80;
    };
    function change() {
        self.opacity += (self.direction ? 10 : -10);
        document.getElementById(self.id).style.opacity = self.opacity/100;
        document.getElementById(self.id).style.MozOpacity = self.opacity/100;
        document.getElementById(self.id).style.filter = "alpha(opacity="+self.opacity+")";
        if (self.opacity == 20) { self.direction = 1; }
        if (self.opacity == 80) { self.direction = 0; }
    }
    var self = this;
    this.id = id;
    this.timerId = null;
    this.opacity = 80;
    this.direction = 0;
}

var tabsLoading = new Fader("tabs-loading");

function tabsLoadingOn() { document.getElementById("tabs-loading").style.display = "block"; tabsLoading.start(); }
function tabsLoadingOff() { document.getElementById("tabs-loading").style.display = "none"; tabsLoading.stop(); }

/** XulTabs **/
function XulTabs(id) {
    this.init = function() {
        this.parse(document.getElementById(this.id).childNodes);
        if (this.tabs != this.data) { alert("XulTabs.init() failed, tabs="+this.tabs+", data="+this.data); }
    };
    this.parse = function(nodes) {
        for (var i = 0; i < nodes.length; i++) {
            if (nodes[i].nodeType != 1) { continue; }
            if (/\btab\b/.test(nodes[i].className)) {
                nodes[i].id = this.id+"-"+this.tabs;
                nodes[i].onclick = click;
                this.tabs++;
            }
            if (/\bdata\b/.test(nodes[i].className)) {
                nodes[i].id = this.id+"-"+this.data+"-data";
                this.data++;
            }
            if (nodes[i].childNodes) {
                this.parse(nodes[i].childNodes);
            }
        }
    };
    this.show = function(id) {
		tabsLoadingOn();
        this.hide();
		document.getElementById(id).className = document.getElementById(id).className.replace(/\btab\b/, "tab-active");
        //document.getElementById(id).className = "tab-active";
        document.getElementById(id+"-data").style.display = "block";
        this.active = id;
		tabsLoadingOff();
    };
    this.hide = function() {
        if (this.active) {
            //document.getElementById(this.active).className = "tab";
			document.getElementById(this.active).className = document.getElementById(this.active).className.replace(/\btab-active\b/, "tab");
            document.getElementById(this.active+"-data").style.display = "none";
            this.active = "";
        }
    };

	this.loadTab = function(id)
	{
		self.show(id);
	}

    function click()
	{
        self.show(this.id);
        this.blur();
    }

    var self = this;
    this.id = id;
    this.active = "tabs-0";
    this.tabs = 0;
    this.data = 0;
}

function Cookie() {
    this.get = function(name) {
        var cookies = document.cookie.split(";");
        for (var i = 0; i < cookies.length; ++i) {
            var a = cookies[i].split("=");
            if (a.length == 2) {
                a[0] = a[0].trim();
                a[1] = a[1].trim();
                if (a[0] == name) {
                    return unescape(a[1]);
                }
            }
        }
        return "";
    };
    this.set = function(name, value, seconds, path) {
        var cookie = (name + "=" + escape(value));
        if (seconds) {
            var date = new Date(new Date().getTime()+seconds*1000);
            cookie += ("; expires="+date.toGMTString());
        }
        cookie += (path    ? "; path="+path : "");
        document.cookie = cookie;
    };
    this.del = function(name, path) {
        var cookie = (name + "=");
        cookie += (path    ? "; path="+path : "");
        cookie += "; expires=Thu, 01-Jan-70 00:00:01 GMT";
        document.cookie = cookie;
    };
}
/** cookies **/
function Cookie() {
    this.get = function(name) {
        var cookies = document.cookie.split(";");
        for (var i = 0; i < cookies.length; ++i) {
            var a = cookies[i].split("=");
            if (a.length == 2) {
                a[0] = a[0].trim();
                a[1] = a[1].trim();
                if (a[0] == name) {
                    return unescape(a[1]);
                }
            }
        }
        return "";
    };
    this.set = function(name, value, seconds, path, domain, secure) {
        var cookie = (name + "=" + escape(value));
        if (seconds) {
            var date = new Date(new Date().getTime()+seconds*1000);
            cookie += ("; expires="+date.toGMTString());
        }
        cookie += (path    ? "; path="+path : "");
        cookie += (domain  ? "; domain="+domain : "");
        cookie += (secure  ? "; secure" : "");
        document.cookie = cookie;
    };
    this.del = function(name) {
        document.cookie = name + "=; expires=Thu, 01-Jan-70 00:00:01 GMT";
    };
}